/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.subsystem.dog;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.cku.core.RESTResponse;
import com.cku.oa.dog.dao.DogAppraisalDao;
import com.cku.restful.v1.dog.service.RestDogService;
import com.cku.util.ServletUtils;

import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authz.UnauthenticatedException;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.cku.core.CaCheCode;
import com.cku.oa.dog.entity.Dog;
import com.cku.oa.dog.entity.DogAppraisal;
import com.cku.oa.dog.entity.DogPedigreeCertifiedExport;
import com.cku.oa.dog.service.DogAppraisalService;
import com.cku.oa.dog.service.DogColorMarkService;
import com.cku.oa.dog.service.DogPedigreeCertifiedExportService;
import com.cku.oa.dog.service.DogService;
import com.cku.oa.dog.service.DogTypeService;
import com.cku.oa.handler.entity.HandlerRegister;
import com.cku.oa.sys.service.LoginServerService;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.JedisUtils;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.modules.sys.entity.User;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

/**
 * 犬只信息管理Controller
 * @author zhuoHeng
 * @version 2016-08-03
 */
@Controller
@RequestMapping(value = "/subSystem/dog")
public class SubDogController extends BaseController {

	@Autowired
	private DogService dogService;
	@Autowired
	private LoginServerService loginServerService;
	@Autowired
	private DogColorMarkService dogColorMarkService;
	@Autowired
	private DogTypeService dogTypeService;
	/**
	 * 查询当前登录人登录类型得到跳转路径头
	 * @return
	 * @author chaixueteng
	 */
	public String getUrlByUserType(){
		User loginUser = UserUtils.getLoginUser();
		return loginServerService.getShortNameByUserType(loginUser.getUserType());
	}
	@ModelAttribute
	public Dog get(@RequestParam(required=false) String id) {
		Dog entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = dogService.get(id);
		}
		if (entity == null){
			entity = new Dog();
		}
		return entity;
	}
	
	@RequestMapping(value = {"list", ""})
	public String list(Dog dog, HttpServletRequest request, HttpServletResponse response, Model model) throws UnsupportedEncodingException {
		Page<Dog> page = dogService.findPage(new Page<Dog>(request, response), dog); 
		model.addAttribute("page", page);
		return "subSystem/"+getUrlByUserType()+"/dog/dog/dogList";
	}
	/**
	 *
	 * @Description：犬只信息查看页
	 * @author: chaixueteng
	 * @version: 2016年8月27日 下午4:10:29
	 */
	@RequestMapping(value = "view")
	public String view(Dog dog, Model model) {
		model.addAttribute("dogColorMarkList", dogColorMarkService.findAllList());
		model.addAttribute("dogBreedList", dogTypeService.findAllList());
		model.addAttribute("dog", dog);
		return "subSystem/"+getUrlByUserType()+"/dog/dog/dogView";
	}
}