package com.cku.restful.v1.show.model;

import com.cku.oa.show.entity.ShowResults;
import lombok.Data;
import org.apache.commons.lang.StringUtils;

/**
 * @author yuanshuai
 * @date 2021/6/2 15:08
 */
@Data
public class ShowResultDogInfo {
	String name;
	String breedNameCn;
	String breedNameEn;
	String gender;
	String ownerName;
	String ownerNameEn;
	String result;

	public ShowResultDogInfo(ShowResults results) {
		this.name = results.getDogName();
		this.breedNameCn = results.getBreedCnName();
		this.breedNameEn = results.getBreedEnName();
		this.gender = StringUtils.isBlank(results.getDogGender()) ? null : ("1".equals(results.getDogGender()) ? "公" : "母");
		this.ownerName = results.getDogOwnerNameCn();
		this.ownerNameEn = results.getDogOwnerNameEn();
	}

	public void setAllResult(ShowResults results) {
		this.result = (StringUtils.isBlank(results.getResultBis()) ? "" : results.getResultBis() + " ")
				+ (StringUtils.isBlank(results.getResultJbis()) ? "" : results.getResultJbis() + " ")
				+ (StringUtils.isBlank(results.getResultOhcBis()) ? "" : results.getResultOhcBis() + " ")
				+ (StringUtils.isBlank(results.getResultBbeBis()) ? "" : results.getResultBbeBis() + " ")
				+ (StringUtils.isBlank(results.getResultBig()) ? "" : results.getResultBig() + " ")
				+ (StringUtils.isBlank(results.getResultOhcBig()) ? "" : results.getResultOhcBig() + " ")
				+ (StringUtils.isBlank(results.getResultBbeBig()) ? "" : results.getResultBbeBig() + " ")
				+ (StringUtils.isBlank(results.getResultBob()) ? "" : results.getResultBob() + " ")
				+ (StringUtils.isBlank(results.getResultBoj()) ? "" : results.getResultBoj() + " ")
				+ (StringUtils.isBlank(results.getResultOhcBoh()) ? "" : results.getResultOhcBoh() + " ")
				+ (StringUtils.isBlank(results.getResultBbeWinner()) ? "" : results.getResultBbeWinner() + " ")
				+ (StringUtils.isBlank(results.getResultBos()) ? "" : results.getResultBos() + " ")
				+ (StringUtils.isBlank(results.getResultBow()) ? "" : results.getResultBow() + " ")
				+ (StringUtils.isBlank(results.getResultWb()) ? "" : results.getResultWb() + " ");
		this.result = StringUtils.isBlank(this.result) ? null : this.result.substring(0, this.result.length() - 1);
	}
}
