package com.cku.restful.v1.finance.service;

import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.cku.core.PageBeanResult;
import com.cku.core.RESTResponse;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.finance.entity.PaymentRecord;
import com.cku.oa.finance.service.PaymentRecordService;
import com.cku.restful.v1.finance.entity.RestPaymentRecord;
import com.cku.restful.v1.sys.utils.BeanUtil;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.modules.sys.utils.DictUtils;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

@Service
@Transactional(readOnly = true)
public class RestPaymentRecordService {
	@Autowired
	private PaymentRecordService paymentRecordService;

	public RESTResponse getList(HttpServletRequest request) {
		// 获取参数
		String chargingItemId = request.getParameter("chargingItemId");
		String pageNo = request.getParameter("pageNo");
		String pageSize = request.getParameter("pageSize");
		// 参数校验
		int pageNoInt = 1;
		int pageSizeInt = 10;
		try {
			if (StringUtils.isNotBlank(pageNo)) {
				pageNoInt = Integer.parseInt(pageNo);
			}
			if (StringUtils.isNotBlank(pageSize)) {
				pageSizeInt = Integer.parseInt(pageSize);
			}
		} catch (Exception e) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED,
					"pageNo和pageSize必须都为数字");
		}
		PaymentRecord example = new PaymentRecord();
		// 设置分页参数
		Page<PaymentRecord> page = new Page<PaymentRecord>();
		page.setPageNo(pageNoInt);
		page.setPageSize(pageSizeInt);
		// 设置查询条件
		example.setMemberCode(UserUtils.getLoginMember().getMemberCode());
		example.setDelFlag("0");
		example.setPage(page);
		if (StringUtils.isNotBlank(chargingItemId)) {
			example.setChargingItemId(chargingItemId);
		}
		// 查询并组装返回对象
		Page<PaymentRecord> result = paymentRecordService.findPage(page,
				example);
		List<PaymentRecord> paymentRecordList = result.getList();
		List<RestPaymentRecord> list = new ArrayList<RestPaymentRecord>();
		for (PaymentRecord paymentRecord : paymentRecordList) {
			RestPaymentRecord vo = new RestPaymentRecord();
			BeanUtil.copyProperties(vo, paymentRecord, "yyyy-MM-dd");
			vo.setPaymentWay(DictUtils.getDictLabel(vo.getPaymentWay(),
					"payment_way", ""));
			vo.setPaymentState(DictUtils.getDictLabel(vo.getPaymentState(),
					"user_payment_state", ""));
			list.add(vo);
		}
		long count = result.getCount();
		return new RESTResponse("list", new PageBeanResult<RestPaymentRecord>(
				list, count));
	}
}