/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.restful.v1.dog.web;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.cku.core.RESTResponse;
import com.cku.restful.v1.dog.service.RestDogNewbornService;
import com.cku.restful.v1.sys.web.BaseRestController;
import com.cku.util.ServletUtils;

/**
 * 配种证明Controller
 *
 * @author zhuoHeng
 * @version 2016-08-02
 */
@Controller
@RequestMapping(value = "/api/v1/dog")
public class RestDogNewbornController extends BaseRestController {

	@Autowired
	private RestDogNewbornService restDogNewbornService;

	@RequestMapping(value = "/dognewborn/{id}", method = RequestMethod.GET)
	@ResponseBody
	public void get(@PathVariable("id") String id, HttpServletResponse response) throws IOException {
		RESTResponse result = restDogNewbornService.get(id);
		ServletUtils.writeResponse(response, result);
	}

	@RequestMapping(value = "/dognewborn", method = RequestMethod.GET)
	@ResponseBody
	public void getList(HttpServletRequest request, HttpServletResponse response) throws IOException {
		RESTResponse result = restDogNewbornService.getList(request);
		ServletUtils.writeResponse(response, result);
	}

	@RequestMapping(value = "/dognewborn", method = RequestMethod.POST)
	@ResponseBody
	public void post(@RequestBody String json, HttpServletRequest request, HttpServletResponse response)
			throws IOException {
		RESTResponse result = restDogNewbornService.post(request, json);
		ServletUtils.writeResponse(response, result);
	}

	@RequestMapping(value = "/dognewborn", method = RequestMethod.PUT)
	@ResponseBody
	public void put(@RequestBody String json, HttpServletResponse response) throws IOException {
		RESTResponse result = restDogNewbornService.put(json);
		ServletUtils.writeResponse(response, result);
	}

	@RequestMapping(value = "/dognewborn/getPrice", method = RequestMethod.GET)
	@ResponseBody
	public void getPrice(HttpServletRequest request, HttpServletResponse response) throws IOException {
		RESTResponse result = restDogNewbornService.getPrice(request);
		ServletUtils.writeResponse(response, result);
	}

	/**
	 *
	 * @Description：因宠爱王国需要传递token来验证登录身份，新开根据id获取配种证明访问入口
	 * @author: zhuoHeng
	 * @version: 2016年11月9日 上午10:18:12
	 */
	@RequestMapping(value = "/cab/dognewborn", method = RequestMethod.GET)
	@ResponseBody
	public void getById(HttpServletRequest request, HttpServletResponse response) throws IOException {
		String id = request.getParameter("id");
		RESTResponse result = restDogNewbornService.get(id);
		ServletUtils.writeResponse(response, result);
	}

	/**
	 *
	 * @Description：订单详细中业务数据查询
	 * @author: zhuoHeng
	 * @version: 2016年12月29日 上午9:18:51
	 */
	@RequestMapping(value = "/dognewborn/orderDetail", method = RequestMethod.GET)
	@ResponseBody
	public void orderDetail(HttpServletRequest request, HttpServletResponse response) throws IOException {
		String id = request.getParameter("id");
		RESTResponse result = restDogNewbornService.orderDetail(id);
		ServletUtils.writeResponse(response, result);
	}

	/**
	 *
	 * @Description：根据配种证明编号查询配种信息
	 * @author: zhuoHeng
	 * @version: 2017年1月5日 下午3:56:43
	 */
	@RequestMapping(value = "/dognewborn/byBreedCertifiedCode", method = RequestMethod.GET)
	@ResponseBody
	public void byBreedCertifiedCode(HttpServletRequest request, HttpServletResponse response) throws IOException {
		String breedCertifiedCode = request.getParameter("id");
		RESTResponse result = restDogNewbornService.byBreedCertifiedCode(breedCertifiedCode);
		ServletUtils.writeResponse(response, result);
	}

	/**
	 * @description: 根据犬只精子号获取犬只信息
	 * @author: laiguanglong
	 * @date: 2017/9/5 13:51
	 */
	@RequestMapping(value = "/dognewborn/getDogBySemenCode", method = RequestMethod.GET)
	public void getDogBySemenCode(HttpServletRequest request, HttpServletResponse response) throws IOException {
		RESTResponse result = restDogNewbornService.getDogBySemenCode(request);
		ServletUtils.writeResponse(response, result);
	}

	@RequestMapping(value = "/dognewborn/isDnaParentsCompare", method = RequestMethod.GET)
	@ResponseBody
	public void isDnaParentsCompare(HttpServletRequest request, HttpServletResponse response) throws IOException {
		String dognewbornId = request.getParameter("id");
		RESTResponse result = restDogNewbornService.isDnaParentsCompare(dognewbornId);
		ServletUtils.writeResponse(response, result);
	}
}