package com.cku.restful.v1.dog.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
@ApiModel("犬只信息实体")
public class DogPedigreeCertifiedExportVo implements Serializable {
    @ApiModelProperty("犬名")
    private String nameEn;
    @ApiModelProperty("犬种英文名")
    private String breedEnName;
    @ApiModelProperty("犬主人")
    private String dogOwner;
    @ApiModelProperty("出生日期")
//    @JsonFormat(pattern = "yyyy-MM-dd")
    private String birthdate;
    @ApiModelProperty("性别")
    private String gender;
    @ApiModelProperty("毛色")
    private String colorFlagCode;
    @ApiModelProperty("电子芯片号码")
    private String identificationFlag;
    @ApiModelProperty("血统证书注册号码")
    private String pedigreeCertified;
    @ApiModelProperty("繁殖人")
    private String breeder;
    @ApiModelProperty("出口目的地")
    private String exportDestination;
    @ApiModelProperty("审核时间")
//    @JsonFormat(pattern = "yyyy-MM-dd")
    private String reviewTime;
    @ApiModelProperty("出生数")
    private String puppyBirthNum;
    @ApiModelProperty("登记数")
    private String puppyRegisterNum;
    @ApiModelProperty("签发日期")
//    @JsonFormat(pattern = "yyyy-MM-dd")
    private String printTime;
}
