package com.cku.restful.v1.dog.service;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.cku.core.ListResultDto;
import com.cku.core.PageBeanResult;
import com.cku.core.RESTResponse;
import com.cku.core.ResultDto;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.constant.Constants;
import com.cku.oa.dog.dao.DogBloodSaveDao;
import com.cku.oa.dog.dao.DogDao;
import com.cku.oa.dog.dao.DogDnaArchiveDao;
import com.cku.oa.dog.dao.DogDnaBloodDao;
import com.cku.oa.dog.entity.Dog;
import com.cku.oa.dog.entity.DogBloodSave;
import com.cku.oa.dog.entity.DogDnaArchive;
import com.cku.oa.dog.entity.DogDnaBlood;
import com.cku.oa.dog.entity.DogPedigreeCertifiedChange;
import com.cku.oa.dog.service.DogDnaParentsCompareAuditService;
import com.cku.oa.dog.service.DogPedigreeCertifiedChangeService;
import com.cku.oa.dog.service.DogService;
import com.cku.oa.dog.service.DogTypeService;
import com.cku.oa.finance.service.PaymentOrderRefundService;
import com.cku.oa.sampling.entity.Sampling;
import com.cku.oa.sampling.enums.SamplingDogSourceTypeEnum;
import com.cku.oa.sampling.service.SamplingService;
import com.cku.oa.sys.entity.Org;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.service.OrgService;
import com.cku.restful.v1.dog.model.RequestDogDnaBloodUpdateOrg;
import com.cku.restful.v1.dog.model.RestDnaBlood;
import com.cku.restful.v1.dog.request.RestDogDnaBindSamplingRequest;
import com.cku.restful.v1.dog.vo.DogDnaArchiveUnboundSampling;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

@Service
@Transactional(readOnly = false)
public class RestDogDnaBloodService extends CrudService<DogDnaBloodDao, DogDnaBlood> {

	@Autowired
	private DogDnaBloodDao dogDnaBloodDao;
	@Autowired
	private OrgService orgService;
	@Autowired
	private DogTypeService dogTypeService;
	@Autowired
	private DogBloodSaveDao dogBloodSaveDao;
	@Autowired
	private DogDnaArchiveDao dogDnaArchiveDao;
	@Autowired
	private DogService dogService;
	@Autowired
	private DogDao dogDao;
	@Autowired
	private DogPedigreeCertifiedChangeService dogPedigreeCertifiedChangeService;
	@Autowired
	private SamplingService samplingService;
	@Autowired
	private DogDnaParentsCompareAuditService dogDnaParentsCompareAuditService;
	@Autowired
	private PaymentOrderRefundService paymentOrderRefundService;

	@Transactional(readOnly = true)
	public RESTResponse list(HttpServletRequest request) throws ParseException {
		String pageNo = request.getParameter("pageNo");
		String pageSize = request.getParameter("pageSize");
		String pedigreeCertified = request.getParameter("pedigreeCertified");
		String current = request.getParameter("current");
		// 参数校验
		int pageNoInt = 1;
		int pageSizeInt = 10;
		try {
			if (StringUtils.isNotBlank(pageNo)) {
				pageNoInt = Integer.parseInt(pageNo);
			}
			if (StringUtils.isNotBlank(pageSize)) {
				pageSizeInt = Integer.parseInt(pageSize);
			}
		} catch (Exception e) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "pageNo和pageSize必须都为数字");
		}
		List<DogDnaBlood> list = new ArrayList<>();
		DogDnaBlood example = new DogDnaBlood();
		// 设置分页参数
		Page<DogDnaBlood> page = new Page<DogDnaBlood>();
		page.setPageNo(pageNoInt);
		page.setPageSize(pageSizeInt);
		// 设置查询条件
		Member member = UserUtils.getLoginMember();
		example.setMemberCode(member.getMemberCode());
		example.setPedigreeCertified(pedigreeCertified);
		example.setPage(page);
		// 查询并组装返回对象
		if ("1".equals(current)) {
			return currentOne(page, example, list);
		} else {
			return currentZero(page, example, list);
		}
	}

	// 已申请
	public RESTResponse currentOne(Page page, DogDnaBlood example, List<DogDnaBlood> list) throws ParseException {
		Page<DogDnaBlood> results = this.findPage(page, example);
		List<RestDnaBlood> restDnaBloods = new ArrayList<>();
		for (DogDnaBlood result : results.getList()) {
			RestDnaBlood dnaBlood = new RestDnaBlood();
			BeanUtils.copyProperties(result, dnaBlood);
			// 补全剩余数据
			if (StringUtils.isNotBlank(result.getOrgId())) {
				Org org = orgService.get(result.getOrgId());
				dnaBlood.setOrgName(org.getName());
			}
			if (StringUtils.isNotBlank(result.getDogBreed())) {
				dnaBlood.setDogBreed(dogTypeService.getByDogBreedCode(result.getDogBreed()).getBreedCnName());
			}
			SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
			Date parse = sdf.parse("2021-09-10");
			if (result.getFinishTime() == null && result.getCreateDate().getTime() >= parse.getTime()) {
				// 完成时间不为空则可修改
				dnaBlood.setIsComplete("1");
			}
			// 是否办理过相对业务
			if ("0".equals(result.getType())) {
				dnaBlood.setSkipBloodType(null);
				// 查位点
				DogDnaArchive byPediCodeOrChipCode = dogDnaArchiveDao
						.getByPediCodeOrChipCode(result.getPedigreeCertified());
				if (Objects.nonNull(byPediCodeOrChipCode)) {
					dnaBlood.setIsCanceled(byPediCodeOrChipCode.getIsCanceled());
				}
				if (byPediCodeOrChipCode == null) {
					dnaBlood.setApplyType("0");
				} else if (byPediCodeOrChipCode != null && !"2".equals(byPediCodeOrChipCode.getPaymentState())) {
					dnaBlood.setApplyType("0");

					if (byPediCodeOrChipCode != null
							&& StringUtils.isNotBlank(byPediCodeOrChipCode.getRunningNumber())) {
						dnaBlood.setSkipType("2");
					} else {
						dnaBlood.setSkipType("1");
					}
				} else if ("2".equals(byPediCodeOrChipCode.getPaymentState())) {
					dnaBlood.setApplyType(null);
				}
			}
			// 已申请的记录注销
			if (StringUtils.isNotBlank(result.getIsCanceled()) && "1".equals(result.getIsCanceled())) {
				dnaBlood.setApplyType(null);
				dnaBlood.setIsComplete("0");
			}
			// 犬信息不正常
			if (StringUtils.isBlank(result.getDogState()) || !"0".equals(result.getDogState())) {
				dnaBlood.setApplyType(null);
				dnaBlood.setIsComplete("0");
			}
			// 是否为当前登录会员
			if (StringUtils.isNotBlank(result.getPedigreeCertified())) {
				Dog dog = dogService.getByPedigreeCertifiedCode(result.getPedigreeCertified());
				if (dog == null || (!Objects.isNull(dog) &&!UserUtils.getLoginMember().getMemberCode().equals(dog.getMemberCode()))) {
					dnaBlood.setApplyType(null);
					dnaBlood.setIsComplete("0");
				}
				dnaBlood.setCallName(!Objects.isNull(dog)?dog.getCallName():null);
			}
			restDnaBloods.add(dnaBlood);
		}
		long count = results.getCount();
		if (restDnaBloods.size() == 0) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "未查询到血样留存申请记录!");
		}
		return new RESTResponse("list", new PageBeanResult<RestDnaBlood>(restDnaBloods, count));
	}

	// 未申请
	public RESTResponse currentZero(Page page, DogDnaBlood example, List<DogDnaBlood> list) {
		Page<DogDnaBlood> results = this.findPageByZero(page, example);
		List<RestDnaBlood> restDnaBloods = new ArrayList<>();
		for (DogDnaBlood result : results.getList()) {
			RestDnaBlood dnaBlood = new RestDnaBlood();
			BeanUtils.copyProperties(result, dnaBlood);
			// 补全剩余数据
			if (StringUtils.isNotBlank(result.getDogBreed())) {
				dnaBlood.setDogBreed(dogTypeService.getByDogBreedCode(result.getDogBreed()).getBreedCnName());
			}
			//
			StringBuffer sb = new StringBuffer();
			// 判断是否在购物车还是订单
			if (StringUtils.isNotBlank(result.getPedigreeCertified())) {
				DogDnaArchive dogDnaArchive = dogDnaArchiveDao
						.getByPedigreeCertifiedCode(result.getPedigreeCertified());
				if (dogDnaArchive != null) {
					if (StringUtils.isNotBlank(dogDnaArchive.getRunningNumber())) {
//                        dnaBlood.setSkipDnaType("2");
						sb.append("2,");
					} else {
//                        dnaBlood.setSkipDnaType("1");
						sb.append("1,");
					}
				}
				DogBloodSave dogBloodSave = dogBloodSaveDao.getByPedigreeCertifiedCode(result.getPedigreeCertified());
				if (dogBloodSave != null) {
					if (StringUtils.isNotBlank(dogBloodSave.getRunningNumber())) {
//                        dnaBlood.setSkipBloodType("2");
						sb.append("2,");
					} else {
//                        dnaBlood.setSkipBloodType("1");
						sb.append("1,");
					}
				}
			}
			if (sb.length() > 0) {
				if (sb.toString().contains("2")) {
					dnaBlood.setSkipType("2");
				} else {
					dnaBlood.setSkipType("1");
				}
			}
			restDnaBloods.add(dnaBlood);

		}
		long count = results.getCount();
		if (restDnaBloods.size() == 0) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "未查询到血样留存待申请记录!");
		}
		return new RESTResponse("list", new PageBeanResult<RestDnaBlood>(restDnaBloods, count));
	}

	public Page<DogDnaBlood> findPageByZero(Page<DogDnaBlood> page, DogDnaBlood entity) {
		int pageNo = page.getPageNo();
		int pageSize = page.getPageSize();
		entity.setPage(page);
		page.setList(dogDnaBloodDao.findListZero(entity));
		if ((pageNo - 1) * pageSize >= page.getCount()) {
			page.setList(new ArrayList<DogDnaBlood>(0));
		}
		return page;
	}

	public RESTResponse editOrganizationName(RequestDogDnaBloodUpdateOrg org) {
		try {
			if ("0".equals(org.getType())) {
				DogBloodSave dogBloodSave = dogBloodSaveDao.get(org.getId());
				dogBloodSave.setOrgId(org.getOrgId());
				// 血样
				dogBloodSaveDao.update(dogBloodSave);
			} else {
				// 位点
				DogDnaArchive dogDnaArchive = dogDnaArchiveDao.get(org.getId());
				dogDnaArchive.setOrgId(org.getOrgId());
				dogDnaArchiveDao.update(dogDnaArchive);
			}
			return new RESTResponse();
		} catch (Exception e) {
			return new RESTResponse("-1", e.getMessage());
		}
	}

	private void validIsRefundOrder(String orderCode) {
		if (paymentOrderRefundService.validOrderIsRefundingOrRefunded(orderCode)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该业务已申请退款，不可绑定");
		}
	}

	public void validBindSampling(String id) throws Exception {
		DogDnaArchive dogDnaArchive = dogDnaArchiveDao.get(id);
		if (StringUtils.isNotBlank(dogDnaArchive.getRunningNumber())) {
			dogDnaParentsCompareAuditService.cherkByOrderCode(dogDnaArchive.getRunningNumber(),
					dogDnaArchive.getPedigreeCertified());
		}
	}

	@Transactional(readOnly = false)
	public ResultDto<Boolean> bindSampling(RestDogDnaBindSamplingRequest request) {
		DogDnaArchive dogDnaArchive = dogDnaArchiveDao.get(request.getId());
		validIsRefundOrder(dogDnaArchive.getRunningNumber());
		if (Objects.isNull(dogDnaArchive)) {
			throw new ZAException(ZAErrorCode.ZA_ERROR, "未找到相应的存档记录");
		}
		if (!"1".equals(dogDnaArchive.getIsOEC())) {
			throw new ZAException(ZAErrorCode.ZA_ERROR, "非口腔上皮细胞检测，无法绑定采样包");
		}
		if (StringUtils.isNotBlank(dogDnaArchive.getSamplingCode())) {
			throw new ZAException(ZAErrorCode.ZA_ERROR, "该存档已经绑定采样包，请勿重复绑定");
		}
		if (Constants.STRING_NUM_ONE.equals(dogDnaArchive.getIsCanceled())) {
			throw new ZAException(ZAErrorCode.ZA_ERROR, "已撤销的记录不允许绑定采样包");
		}
		if (Objects.isNull(dogDnaArchive.getFinishTime())) {
			dogDnaArchive.setFinishTime(new Date());
		}
		// 是否含有双亲对比项目，含有的需要验证父母双方是否同意
		if (StringUtils.isNotBlank(dogDnaArchive.getRunningNumber())) {
			dogDnaParentsCompareAuditService.cherkByOrderCode(dogDnaArchive.getRunningNumber(),
					dogDnaArchive.getPedigreeCertified());
		}

		Sampling sampling = samplingService.findBySamplingCodeWithCase(request.getSamplingCode());

		if (Objects.isNull(sampling)) {
			throw new ZAException(ZAErrorCode.ZA_ERROR, "采样包编号有误");
		}

		if (StringUtils.isBlank(sampling.getMemberCode())) {
			throw new ZAException(ZAErrorCode.ZA_ERROR, "该采样包无归属人，暂不支持绑定");
		}

		if (Objects.nonNull(sampling.getDistributionChannel()) && 0 != sampling.getDistributionChannel()) {
			throw new ZAException(ZAErrorCode.ZA_ERROR, "请输入非机构名下的采样包编号");
		}

		dogDnaArchive.setTypeYes("1");
		dogDnaArchive.setSamplingCode(request.getSamplingCode());
		dogDnaArchive.preUpdate();
		dogDnaArchiveDao.updateSamplingInfo(dogDnaArchive);
		// 判断犬只来源
		String dogCode = null;
		SamplingDogSourceTypeEnum dogSourceType = null;
		if (StringUtils.isNotBlank(dogDnaArchive.getPedigreeCertified())) {
			dogCode = dogDnaArchive.getPedigreeCertified();
			dogSourceType = SamplingDogSourceTypeEnum.PEDIGREE_CERTIFIED;
		} else if (StringUtils.isNotBlank(dogDnaArchive.getBirthCode())) {
			dogCode = dogDnaArchive.getBirthCode();
			dogSourceType = SamplingDogSourceTypeEnum.BIRTH_CODE;
		} else if (StringUtils.isNotBlank(dogDnaArchive.getOverseasPedigreeCertified())) {
			dogCode = dogDnaArchive.getOverseasPedigreeCertified();
			dogSourceType = SamplingDogSourceTypeEnum.OVERSEAS_PEDIGREE_CERTIFIED;
		}
		samplingService.bind(request.getSamplingCode(), dogCode, dogSourceType, Boolean.TRUE);
		return ResultDto.success(Boolean.TRUE);
	}

	private static final String MSG_UNBOND = "您名下有%s条犬只申请了DNA位点留存业务，请收到采样包后尽快采集相关样本，并完成采样包编码绑定。";

	private static final String MSG_NOT_RETURNED = "为保证样本的有效性完成采集后请及时寄回平阳办公室。";

	@Transactional(readOnly = false)
	public ListResultDto<DogDnaArchiveUnboundSampling> unboundSampling() {
		Member member = UserUtils.getLoginMember();
		ListResultDto<DogDnaArchiveUnboundSampling> resultDto = ListResultDto.success(null);
		List<DogDnaArchive> unboundList = dogDnaArchiveDao.getUnboundSampling(member.getMemberCode());
		List<DogDnaArchive> notReturnedList = dogDnaArchiveDao.getNotReturnedSampling(member.getMemberCode());
		if (CollectionUtils.isNotEmpty(unboundList) && CollectionUtils.isNotEmpty(notReturnedList)) {
			String unbondMsg = String.format(MSG_UNBOND, unboundList.size());
			resultDto.setMsg(unbondMsg.concat("\r\n\r\n").concat(MSG_NOT_RETURNED));
		} else if (CollectionUtils.isNotEmpty(unboundList)) {
			resultDto.setMsg(String.format(MSG_UNBOND, unboundList.size()));
		} else if (CollectionUtils.isNotEmpty(notReturnedList)) {
			resultDto.setMsg(MSG_NOT_RETURNED);
		} else {
			resultDto.setMsg(null);
		}
		return resultDto;
	}

	// 执行定时任务
	public void updatePedigreeCertified() {
		List<DogDnaBlood> byDogBloodList = dogDnaBloodDao.getByDogBloodList();
		byDogBloodList.forEach(dog -> {
			List<Dog> lists = dogDao.getAllBirthCertificateLevelCode(dog.getBirthCode());
			if (lists.size() == 1) {
				dog.setPedigreeCertified(lists.get(0).getPedigreeCertifiedCode());
				dogDnaBloodDao.updateBloodSave(dog);
			} else if (lists.size() > 1) {
				lists.stream().filter(d -> StringUtils.isNotBlank(d.getDogState()) && "0".equals(d.getDogState()))
						.limit(1).forEach(d -> {
							dog.setPedigreeCertified(lists.get(0).getPedigreeCertifiedCode());
							dogDnaBloodDao.updateBloodSave(dog);
						});
			}
		});
		List<DogDnaBlood> byDogDnaList = dogDnaBloodDao.getByDogDnaList();
		byDogDnaList.forEach(dog -> {
			List<Dog> lists = dogDao.getAllBirthCertificateLevelCode(dog.getBirthCode());
			if (lists.size() == 1) {
				dog.setPedigreeCertified(lists.get(0).getPedigreeCertifiedCode());
				dogDnaBloodDao.updateDnaSave(dog);
			} else if (lists.size() > 1) {
				lists.stream().filter(d -> StringUtils.isNotBlank(d.getDogState()) && "0".equals(d.getDogState()))
						.limit(1).forEach(d -> {
							dog.setPedigreeCertified(lists.get(0).getPedigreeCertifiedCode());
							dogDnaBloodDao.updateDnaSave(dog);
						});
			}
		});
		// 处理采样包中没有犬只id的数据
		List<Sampling> samplingList = samplingService.findBindNoDogIdList();
		samplingList.stream().filter(s -> StringUtils.isNotBlank(s.getDogCode())).forEach(sampling -> {
			if (SamplingDogSourceTypeEnum.BIRTH_CODE.code().equals(sampling.getDogSourceType())) {
				Dog dog = dogService.getByBirthCertificateLevelCode(sampling.getDogCode());
				if (Objects.nonNull(dog) && StringUtils.isNotBlank(dog.getId())) {
					samplingService.updateDogId(sampling.getId(), dog.getId());
				}
			} else if (SamplingDogSourceTypeEnum.OVERSEAS_PEDIGREE_CERTIFIED.code()
					.equals(sampling.getDogSourceType())) {
				DogPedigreeCertifiedChange change = dogPedigreeCertifiedChangeService
						.getByOverseasPedigreeCertified(sampling.getDogCode());
				if (Objects.nonNull(change) && StringUtils.isNotBlank(change.getDogId())) {
					samplingService.updateDogId(sampling.getId(), change.getDogId());
				}
			}
		});
	}

	public Boolean validRefund(String id) throws IOException {
		String orderCode = null;
		DogDnaArchive dogDnaArchive = dogDnaArchiveDao.get(id);
		if (Objects.nonNull(dogDnaArchive)) {
			orderCode = dogDnaArchive.getRunningNumber();
		} else {
			DogBloodSave dogBloodSave = dogBloodSaveDao.get(id);
			orderCode = Objects.nonNull(dogBloodSave) ? dogBloodSave.getRunningNumber() : null;
		}
		if (StringUtils.isEmpty(orderCode)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "记录不存在，请刷新后重试");
		}
		return paymentOrderRefundService.validOrderIsRefundingOrRefunded(orderCode);
	}
}
