/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.restful.v1.contest.model;

import com.cku.oa.contest.entity.ContestClass;

/**
 * 赛场年龄组别Entity
 *
 * @author yuanshuai
 * @version 2020-10-12
 */
public class RestContestClass {

	private static final long serialVersionUID = 1L;
	private String class_no;        // 编号
	private String code;        // 代码
	private String name;        // 名称
	private String sort_no;        // 排序
	private String grade_type_no;        // 成绩组别类型
	private String language_no;        // 语言

	public RestContestClass() {
		super();
	}

	public RestContestClass(ContestClass contestClass) {
		this.class_no = contestClass.getClassNo();
		this.code = contestClass.getCode();
		this.name = contestClass.getName();
		this.sort_no = contestClass.getSortNo();
		this.grade_type_no = contestClass.getGradeTypeNo();
		this.language_no = contestClass.getLanguageNo();
	}

	public String getClass_no() {
		return class_no;
	}

	public void setClass_no(String class_no) {
		this.class_no = class_no;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getSort_no() {
		return sort_no;
	}

	public void setSort_no(String sort_no) {
		this.sort_no = sort_no;
	}

	public String getGrade_type_no() {
		return grade_type_no;
	}

	public void setGrade_type_no(String grade_type_no) {
		this.grade_type_no = grade_type_no;
	}

	public String getLanguage_no() {
		return language_no;
	}

	public void setLanguage_no(String language_no) {
		this.language_no = language_no;
	}
}