package com.cku.partner.open.finace.service;

import com.cku.core.PageBeanResult;
import com.cku.core.RESTResponse;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.buying.dao.AdvertisementDao;
import com.cku.oa.buying.dao.BuyingDao;
import com.cku.oa.buying.dao.BuyingOrderDao;
import com.cku.oa.buying.entity.BuyingOrder;
import com.cku.oa.dog.dao.DogAppraisalDao;
import com.cku.oa.dog.dao.DogChipDao;
import com.cku.oa.dog.dao.DogVideoAppraisalDao;
import com.cku.oa.dog.service.*;
import com.cku.oa.finance.dao.*;
import com.cku.oa.finance.entity.PaymentChargingItem;
import com.cku.oa.finance.entity.PaymentOrder;
import com.cku.oa.finance.entity.PaymentOrderDetail;
import com.cku.oa.finance.entity.PaymentRecord;
import com.cku.oa.finance.service.PaymentCartService;
import com.cku.oa.finance.service.PaymentChargingItemService;
import com.cku.oa.finance.service.PaymentOrderService;
import com.cku.oa.finance.service.PaymentRecordService;
import com.cku.oa.kennel.service.KennelService;
import com.cku.oa.show.dao.MainShowsDao;
import com.cku.oa.show.dao.ShowApplyDao;
import com.cku.oa.show.entity.ShowApply;
import com.cku.oa.show.service.ShowApplyService;
import com.cku.oa.statistics.dao.MemberInfoDao;
import com.cku.oa.statistics.service.SplitOrderService;
import com.cku.oa.sys.coupon.service.SysCouponService;
import com.cku.oa.sys.dao.OrgDao;
import com.cku.oa.sys.dao.user.MemberDao;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.service.OrgService;
import com.cku.oa.sys.service.user.MemberService;
import com.cku.oa.trainschool.dao.TrainingInstitutionDao;
import com.cku.partner.open.club.service.AppHospitalService;
import com.cku.restful.v1.buying.service.RestAdvertisementService;
import com.cku.restful.v1.finance.entity.RestPaymentOrder;
import com.cku.restful.v1.finance.entity.RestPaymentOrderDetail;
import com.cku.restful.v1.finance.service.RestOrderService;
import com.cku.restful.v1.sys.utils.BeanUtil;
import com.cku.schools.mrschool.service.SchoolsMemberService;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.modules.sys.dao.UserDao;
import com.thinkgem.jeesite.modules.sys.entity.User;
import com.thinkgem.jeesite.modules.sys.utils.DictUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import javax.servlet.http.HttpServletRequest;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

@Service
@Transactional(readOnly = true)
public class AppOrderService {

	private Logger logger = LoggerFactory.getLogger(AppOrderService.class);

	@Autowired
	PaymentOrderService paymentOrderService;
	@Autowired
	private PaymentOrderDetailDao paymentOrderDetailDao;
	@Autowired
	private PaymentCartService paymentCartService;
	@Autowired
	private PaymentOrderDao paymentOrderDao;
	@Autowired
	private PaymentRecordDao paymentRecordDao;
	@Autowired
	private PaymentRecordService paymentRecordService;
	@Autowired
	private PaymentChargingItemDao paymentChargingItemDao;
	@Autowired
	private PaymentChargingItemGroupDao paymentChargingItemGroupDao;
	@Autowired
	private MemberDao memberDao;
	@Autowired
	private BuyingOrderDao buyingOrderDao;
	@Autowired
	private MemberService memberService;
	@Autowired
	private PaymentChargingItemService paymentChargingItemService;
	@Autowired
	private ShowApplyDao showApplyDao;
	@Autowired
	private BuyingDao buyingDao;
	@Autowired
	private DogChipService dogChipService;
	@Autowired
	private DogChipDao dogChipDao;
	@Autowired
	private DogNewbornService dogNewbornService;
	@Autowired
	private KennelService kennelService;
	@Autowired
	private DogChipChangeService dogChipChangeService;
	@Autowired
	private DogPedigreeCertifiedChangeService dogPedigreeCertifiedChangeService;
	@Autowired
	private OrgDao orgDao;
	@Autowired
	private DogDnaArchiveService dogDnaArchiveService;
	@Autowired
	private TrainingInstitutionDao trainingInstitutionDao;
	@Autowired
	private SchoolsMemberService schoolsMemberService;
	@Autowired
	private RestAdvertisementService restAdvertisementService;
	@Autowired
	private AdvertisementDao advertisementDao;
	@Autowired
	private MainShowsDao mainShowsDao;
	@Autowired
	private DogActivationService dogActivationService;
	@Autowired
	private MemberInfoDao memberInfoDao;
	@Autowired
	private DogStickerApplyService dogStickerApplyService;
	@Autowired
	private ShowApplyService showApplyService;
	@Autowired
	private UserDao userDao;
	@Autowired
	private SysCouponService sysCouponService;
	@Autowired
	private SplitOrderService splitOrderService;
	@Autowired
	private OrgService orgService;
	@Autowired
	private AppHospitalService appHospitalService;
	@Autowired
	private DogVideoAppraisalDao dogVideoAppraisalDao;
	@Autowired
	private DogAppraisalDao dogAppraisalDao;
	@Autowired
	private DogVideoAppraisalService dogVideoAppraisalService;
	@Autowired
	private RestOrderService restOrderService;
//	/**
//	 * 分页查询订单
//	 *
//	 * @param request
//	 * @return
//	 */
//	public RESTResponse findByPage(HttpServletRequest request) {
//
//		//获取当前合作机构
//		User user = appHospitalService.loginUser();
//		//Member member = appHospitalService.loginMember();
//
//		String pageNo = request.getParameter("pageNo");
//		String pageSize = request.getParameter("pageSize");
//		String paymentState = request.getParameter("paymentState");
//		String orderCode = request.getParameter("orderCode");
//		int pageNoInt = 1;
//		int pageSizeInt = 10;
//		try {
//			if (StringUtils.isNotBlank(pageNo)) {
//				pageNoInt = Integer.parseInt(pageNo);
//			}
//			if (StringUtils.isNotBlank(pageSize)) {
//				pageSizeInt = Integer.parseInt(pageSize);
//			}
//		} catch (Exception e) {
//			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "pageNo和pageSize必须都为数字");
//		}
//
//		Page<PaymentOrder> page = new Page<PaymentOrder>();
//		page.setPageSize(pageSizeInt);
//		page.setPageNo(pageNoInt);
//
//		// 封装订单
//		PaymentOrder order = new PaymentOrder();
//		// 会员端查询标志位，如果不为空，则查询除会员充值外的收费项记录
//		order.setClientFlag("true");
//		order.setCreateBy(user);
//		//order.setMemberCode(member.getMemberCode());
//		if (paymentState != null) {
//			order.setPaymentState(paymentState);
//		}
//		if (StringUtils.isNotBlank(orderCode)) {
//			order.setOrderCode(orderCode);
//		}
//		order.setDelFlag("0");
//		Page<PaymentOrder> orders = paymentOrderService.findPage(page, order);
//		List<PaymentOrder> paymentOrderList = orders.getList();
//		List<RestPaymentOrder> list = new ArrayList<RestPaymentOrder>();
//		for (PaymentOrder paymentOrder : paymentOrderList) {
//			RestPaymentOrder vo = new RestPaymentOrder();
//			BeanUtil.copyProperties(vo, paymentOrder, "yyyy-MM-dd HH:mm:ss");
//			Member member = memberService.getByMemberCode(paymentOrder.getMemberCode());
//			//订单详情
//			getOrderDetail(vo, member);
//			vo.setPaymentWay(DictUtils.getDictLabel(vo.getPaymentWay(), "payment_way", ""));
//			vo.setPaymentStateName(DictUtils.getDictLabel(vo.getPaymentState(), "user_payment_state", ""));
//			list.add(vo);
//		}
//
//		long count = orders.getCount();
//		return new RESTResponse("list", new PageBeanResult<RestPaymentOrder>(list, count));
//	}
//
//	/**
//	 * 获取订单详情
//	 *
//	 * @param restPaymentOrder
//	 * @param member
//	 */
//	private void getOrderDetail(RestPaymentOrder restPaymentOrder, Member member) {
//		PaymentOrder order = new PaymentOrder();
//		order.setMemberCode(member.getMemberCode());
//		order.setOrderCode(restPaymentOrder.getOrderCode());
//		List<RestPaymentOrderDetail> rDetails = new ArrayList<RestPaymentOrderDetail>();
//		List<PaymentOrderDetail> orderDetailList = paymentOrderDetailDao.findList(new PaymentOrderDetail(order));
//		Map<String, List<PaymentOrderDetail>> collect = orderDetailList.stream().filter(
//				i -> StringUtils.isNotEmpty(i.getBusinessId()) && StringUtils.isNotEmpty(i.getBusinessOrderCode()))
//				.collect(Collectors.groupingByConcurrent(PaymentOrderDetail::getBusinessId));
//		System.out.println("==================" + collect.entrySet().size());
//		if (collect != null && collect.size() > 0) {// TODO: 2019/8/24 新功能上线前需要先清空购物车
//			collect.entrySet().forEach(i -> {
//				RestPaymentOrderDetail r = new RestPaymentOrderDetail();
//				r.setNum(String.valueOf(i.getValue().stream()
//						.collect(Collectors.groupingByConcurrent(PaymentOrderDetail::getBusinessOrderCode)).size()));
//				i.getValue().forEach(j -> {
//					r.setChargingItemId(j.getBusinessId());
//					r.setChargingItemName(j.getBusinessName());
//					r.setBusinessRefund(j.getBusinessRefund());
//					r.setBusinessRefundState(j.getBusinessRefundState());
//				});
//				Double d = 0.0;
//				for (PaymentOrderDetail p : i.getValue())
//					d = d + Double.parseDouble(p.getTotalPrice());
//				r.setPrice(d.toString());
//				r.setTotalPrice(d.toString());
//				rDetails.add(r);
//			});
//		}
//
//		/**
//		 * 判断是否为券，为券的话不在二级收费项显示，故过滤掉
//		 */
//		List<PaymentChargingItem> coupons = paymentChargingItemDao.getByShortNamePrefix("sys_coupon");
//		List<String> couponIds = new ArrayList<>();
//		if (!CollectionUtils.isEmpty(coupons)) {
//			couponIds.addAll(coupons.stream().map(PaymentChargingItem::getId).collect(Collectors.toList()));
//			couponIds.remove("");
//		}
//		/**
//		 * 判断是否为券，为券的话不在二级收费项显示，故过滤掉
//		 */
//		for (PaymentOrderDetail detail : orderDetailList) {
//			if (StringUtils.isNotEmpty(detail.getBusinessId())
//					&& StringUtils.isNotEmpty(detail.getBusinessOrderCode())) {
//				continue;
//			}
//			if (couponIds.contains(detail.getChargingItemId())) {
//				continue;
//			}
//			RestPaymentOrderDetail d = new RestPaymentOrderDetail();
//			BeanUtil.copyProperties(d, detail, "yyyy-MM-dd");
//			// 赛事报名订单详情需要显示报名场次、证书号、年龄组别
//			if ("show_apply".equals(detail.getBusinessTable())) {
//				String id = detail.getBusinessIds().split("#")[0];
//				ShowApply showApply = showApplyDao.get(id);
//				d.setIsShowApply("1");
//				d.setPedigreeCertified(showApply.getPedigreeCertified());
//				d.setShowCode(showApply.getShowCode());
//				d.setAgeGroup(DictUtils.getDictLabel(showApply.getAgeGroup(), "show_age_group", ""));
//			}
//			// 抢购订单详情需显示抢购的产品名
//			if ("buying_order".equals(detail.getBusinessTable())) {
//				BuyingOrder buyingOrder = buyingOrderDao.get(detail.getBusinessIds());
//				if (buyingOrder != null) {
//					if (StringUtils.isNotBlank(buyingOrder.getDogType())) {
//						d.setChargingItemName(buyingOrder.getCommodityName() + "(" + buyingOrder.getDogType() + ")");
//					} else {
//						d.setChargingItemName(buyingOrder.getCommodityName());
//					}
//				}
//			}
//			rDetails.add(d);
//		}
//		restPaymentOrder.setItems(rDetails);
//	}
	/**
	* @Description:   费用中心
	* @author: zhangxiang
	* @date: 2020/7/14 11:16
	*/
	public RESTResponse findByPageCost(HttpServletRequest request) {
		RESTResponse result = null;
		User user = appHospitalService.loginUser();
		Member member = appHospitalService.loginMember();
		//收入
		double income=0;
		//支出
		double expend=0;

		String pageNo = request.getParameter("pageNum");
		String pageSize = request.getParameter("pageSize");
		//默认近一年
		Integer year = 1;
		String paymentTime = request.getParameter("paymentTime");
		String isRecharge = request.getParameter("isRecharge");
		int pageNoInt = 1;
		int pageSizeInt = 10;
		try {
			if (StringUtils.isNotBlank(pageNo)) {
				pageNoInt = Integer.parseInt(pageNo);
			}
			if (StringUtils.isNotBlank(pageSize)) {
				pageSizeInt = Integer.parseInt(pageSize);
			}
		} catch (Exception e) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "pageNo和pageSize必须都为数字");
		}
		// 封装订单 分页
		Page<PaymentRecord> page = new Page<PaymentRecord>();
		page.setPageSize(pageSizeInt);
		page.setPageNo(pageNoInt);
		PaymentRecord order = new PaymentRecord();

		//计算时间
		if(StringUtils.isNotBlank(paymentTime)){
			getTime(order,Integer.parseInt(paymentTime));
		}else{
			getTime(order,1);
		}

		//判断类型
		if(StringUtils.isNotBlank(isRecharge)){
			order.setIsRecharge(isRecharge);
		}

		// 会员端查询标志位，如果不为空，则查询除会员充值外的收费项记录
		//order.setClientFlag("true");
		//order.setCreateBy(user);
		order.setMemberCode(member.getMemberCode());
		order.setPaymentState("2");
		order.setDelFlag("0");
		List<PaymentRecord> listCost = paymentRecordDao.findListCost(order);
		//计算收支明细
		for(int i=0;i<listCost.size();i++){
			if("0".equals(listCost.get(i).getChargingItemId()) || "27".equals(listCost.get(i).getPaymentWay())){
				income+=Double.parseDouble(listCost.get(i).getPaymentAmount());
			}else{
				expend+=Double.parseDouble(listCost.get(i).getPaymentAmount());
			}
		}

		Page<PaymentRecord> list = paymentRecordService.findPageCost(page, order);
		List<PaymentRecord> PaymentOrderList = list.getList();
		List<RestPaymentOrder> ll = new ArrayList<>();

		for(int i=0;i<PaymentOrderList.size();i++){
			RestPaymentOrder vo = new RestPaymentOrder();
			if("0".equals(listCost.get(i).getChargingItemId()) || "27".equals(listCost.get(i).getPaymentWay())){
				vo.setTotalPrice(PaymentOrderList.get(i).getPaymentAmount());
			}else{
				vo.setTotalPrice(PaymentOrderList.get(i).getPaymentAmount());
			}
			vo.setPaymentWay(DictUtils.getDictLabel(PaymentOrderList.get(i).getPaymentWay(), "payment_way", ""));
			vo.setPaymentStateName(DictUtils.getDictLabel(PaymentOrderList.get(i).getPaymentState(), "user_payment_state", ""));
			vo.setPaymentTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(PaymentOrderList.get(i).getPaymentTime()));
			ll.add(vo);
		}
		long count = list.getCount();
		Map<String,Object> map = new HashMap<>();
		map.put("expend",expend);
		map.put("income",income);
		map.put("accountBalance",member.getAccountBalance());
		result = new RESTResponse("list", new PageBeanResult<RestPaymentOrder>(ll, count),map);

		return result;
	}
	//近一年
	public void getTime(PaymentRecord order,Integer paymentTime){
		try {
			SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
			Date date = new Date();//获取当前时间
			Calendar calendar = Calendar.getInstance(); //创建Calendar 的实例
			if(paymentTime==1){
				calendar.add(Calendar.YEAR, -1);//近一年
			}
			if(paymentTime==2){
				calendar.add(Calendar.DAY_OF_MONTH, -30);//近30天
			}
			if(paymentTime==3){
				calendar.add(Calendar.DAY_OF_MONTH, -7);//近7天
			}
			if(paymentTime==4){
				//当前日期
			}
			order.setBeginAddTime(calendar.getTime());
		} catch (Exception e) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "时间转换错误");
		}
	}



	/**
	 * 分页查询订单
	 *
	 * @param request
	 * @return
	 */
	public RESTResponse findByPage(HttpServletRequest request) {
		// 封装分页

		User user = appHospitalService.loginUser();
		String pageNo = request.getParameter("pageNo");
		String pageSize = request.getParameter("pageSize");
		String paymentState = request.getParameter("paymentState");
		String orderCode = request.getParameter("orderCode");
		int pageNoInt = 1;
		int pageSizeInt = 10;
		try {
			if (StringUtils.isNotBlank(pageNo)) {
				pageNoInt = Integer.parseInt(pageNo);
			}
			if (StringUtils.isNotBlank(pageSize)) {
				pageSizeInt = Integer.parseInt(pageSize);
			}
		} catch (Exception e) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "pageNo和pageSize必须都为数字");
		}

		Page<PaymentOrder> page = new Page<PaymentOrder>();
		page.setPageSize(pageSizeInt);
		page.setPageNo(pageNoInt);

		// 封装订单
		PaymentOrder order = new PaymentOrder();
		// 俱乐部查询根据创建人
		order.setCreateBy(user);
		if (paymentState != null) {
			order.setPaymentState(paymentState);
		}
		if (StringUtils.isNotBlank(orderCode)) {
			order.setOrderCode(orderCode);
		}
		order.setDelFlag("0");
		//视频鉴定收费项
		PaymentChargingItem dogAppraisalItem = dogVideoAppraisalService.getDogAppraisalItem();

		order.setChargingItemId(dogAppraisalItem.getId());
		Page<PaymentOrder> orders = paymentOrderService.findPage(page, order);
		List<PaymentOrder> paymentOrderList = orders.getList();
		List<RestPaymentOrder> list = new ArrayList<RestPaymentOrder>();
		for (PaymentOrder paymentOrder : paymentOrderList) {
			RestPaymentOrder vo = new RestPaymentOrder();
			BeanUtil.copyProperties(vo, paymentOrder, "yyyy-MM-dd HH:mm:ss");
			getOrderDetail(vo,user);
			vo.setPaymentWay(DictUtils.getDictLabel(vo.getPaymentWay(), "payment_way", ""));
			vo.setPaymentStateName(DictUtils.getDictLabel(vo.getPaymentState(), "user_payment_state", ""));
			list.add(vo);
		}

		long count = orders.getCount();
		return new RESTResponse("list", new PageBeanResult<RestPaymentOrder>(list, count));
	}
	/**
	 * 获取订单详情
	 *
	 * @param restPaymentOrder
	 * @param
	 */
	private void getOrderDetail(RestPaymentOrder restPaymentOrder,User user) {
		PaymentOrder order = new PaymentOrder();
		order.setCreateBy(user);
		order.setOrderCode(restPaymentOrder.getOrderCode());
		List<RestPaymentOrderDetail> rDetails = new ArrayList<RestPaymentOrderDetail>();
		List<PaymentOrderDetail> orderDetailList = paymentOrderDetailDao.findList(new PaymentOrderDetail(order));
		Map<String, List<PaymentOrderDetail>> collect = orderDetailList.stream().filter(
				i -> StringUtils.isNotEmpty(i.getBusinessId()) && StringUtils.isNotEmpty(i.getBusinessOrderCode()))
				.collect(Collectors.groupingByConcurrent(PaymentOrderDetail::getBusinessId));
		System.out.println("==================" + collect.entrySet().size());
		if (collect != null && collect.size() > 0) {// TODO: 2019/8/24 新功能上线前需要先清空购物车
			collect.entrySet().forEach(i -> {
				RestPaymentOrderDetail r = new RestPaymentOrderDetail();
				r.setNum(String.valueOf(i.getValue().stream()
						.collect(Collectors.groupingByConcurrent(PaymentOrderDetail::getBusinessOrderCode)).size()));
				i.getValue().forEach(j -> {
					r.setChargingItemId(j.getBusinessId());
					r.setChargingItemName(j.getBusinessName());
					r.setBusinessRefund(j.getBusinessRefund());
					r.setBusinessRefundState(j.getBusinessRefundState());
					r.setMemberCode(j.getMemberCode());
					r.setBusinessIds(j.getBusinessIds());
					r.setBusinessTable(j.getBusinessTable());
				});
				Double d = 0.0;
				for (PaymentOrderDetail p : i.getValue())
					d = d + Double.parseDouble(p.getTotalPrice());
				r.setPrice(d.toString());
				r.setTotalPrice(d.toString());
//				//只允许视频鉴定退款
//				if("dog_video_appraisal".equals(r.getBusinessTable())){
//					r.setBusinessRefund(r.getBusinessRefund());
//				}else{
//					r.setBusinessRefund("0");
//				}
				rDetails.add(r);
			});
		}

		/**
		 * 判断是否为券，为券的话不在二级收费项显示，故过滤掉
		 */
		List<PaymentChargingItem> coupons = paymentChargingItemDao.getByShortNamePrefix("sys_coupon");
		List<String> couponIds = new ArrayList<>();
		if (!CollectionUtils.isEmpty(coupons)) {
			couponIds.addAll(coupons.stream().map(PaymentChargingItem::getId).collect(Collectors.toList()));
			couponIds.remove("");
		}
		/**
		 * 判断是否为券，为券的话不在二级收费项显示，故过滤掉
		 */
		for (PaymentOrderDetail detail : orderDetailList) {
			if (StringUtils.isNotEmpty(detail.getBusinessId())
					&& StringUtils.isNotEmpty(detail.getBusinessOrderCode())) {
				continue;
			}
			if (couponIds.contains(detail.getChargingItemId())) {
				continue;
			}
			RestPaymentOrderDetail d = new RestPaymentOrderDetail();
			BeanUtil.copyProperties(d, detail, "yyyy-MM-dd");
			// 赛事报名订单详情需要显示报名场次、证书号、年龄组别
			if ("show_apply".equals(detail.getBusinessTable())) {
				String id = detail.getBusinessIds().split("#")[0];
				ShowApply showApply = showApplyDao.get(id);
				d.setIsShowApply("1");
				d.setPedigreeCertified(showApply.getPedigreeCertified());
				d.setShowCode(showApply.getShowCode());
				d.setAgeGroup(DictUtils.getDictLabel(showApply.getAgeGroup(), "show_age_group", ""));
			}
			// 抢购订单详情需显示抢购的产品名
			if ("buying_order".equals(detail.getBusinessTable())) {
				BuyingOrder buyingOrder = buyingOrderDao.get(detail.getBusinessIds());
				if (buyingOrder != null) {
					if (StringUtils.isNotBlank(buyingOrder.getDogType())) {
						d.setChargingItemName(buyingOrder.getCommodityName() + "(" + buyingOrder.getDogType() + ")");
					} else {
						d.setChargingItemName(buyingOrder.getCommodityName());
					}
				}
			}
			rDetails.add(d);
		}
		restPaymentOrder.setItems(rDetails);
	}
}