package com.cku.partner.club.web;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.dog.dao.DogBloodSaveDao;
import com.cku.oa.dog.dao.DogDnaArchiveDao;
import com.cku.oa.dog.entity.Dog;
import com.cku.oa.dog.entity.DogBloodSave;
import com.cku.oa.dog.entity.DogDnaArchive;
import com.cku.oa.dog.entity.DogType;
import com.cku.oa.dog.service.DogBloodSaveService;
import com.cku.oa.dog.service.DogDnaArchiveService;
import com.cku.oa.dog.service.DogService;
import com.cku.oa.dog.service.DogTypeService;
import com.cku.oa.finance.dao.PaymentOrderDao;
import com.cku.oa.finance.entity.PaymentOrder;
import com.cku.oa.finance.entity.PaymentOrderDetail;
import com.cku.oa.sys.entity.Org;
import com.cku.oa.sys.service.OrgService;
import com.cku.partner.club.service.ClubDnaService;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

/**
 * user chaixueteng 2016年10月12日
 */
@Controller
@RequestMapping(value = "/partner/dna")
public class clubDnaController extends BaseController {
	@Autowired
	private DogDnaArchiveService dogDnaArchiveService;
	@Autowired
	private ClubDnaService clubDnaService;

	@Autowired
	private DogTypeService dogTypeService;
	@Autowired
	private OrgService orgService;
	@Autowired
	private PaymentOrderDao paymentOrderDao;
	@Autowired
	private DogBloodSaveService dogBloodSaveService;
	@Autowired
	private DogDnaArchiveDao dogDnaArchiveDao;
	@Autowired
	private DogService dogService;
	@Autowired
	private DogBloodSaveDao dogBloodSaveDao;

	@ModelAttribute
	public DogDnaArchive get(@RequestParam(required = false) String id) {
		DogDnaArchive entity = null;
		if (StringUtils.isNotBlank(id)) {
			entity = dogDnaArchiveService.get(id);
		}
		if (entity == null) {
			entity = new DogDnaArchive();
		}
		return entity;
	}

	public DogDnaArchive getId(String id) {
		return dogDnaArchiveService.get(id);
	}

	// dna位点分析申请页
	@RequestMapping(value = "form")
	public String form(DogDnaArchive dogDnaArchive, Model model) {
		model.addAttribute("dogDnaArchive", dogDnaArchive);
		return "partner/club/dogChipDnaForm";
	}

	@RequestMapping(value = { "list", "" })
	public String listDna(DogDnaArchive dogDnaArchive, HttpServletRequest request, HttpServletResponse response,
			Model model) {
		Org org = (Org) UserUtils.getSession().getAttribute("org");
		dogDnaArchive.setOrgId(org.getId());
		Page<DogDnaArchive> page = dogDnaArchiveService.findPage(new Page<DogDnaArchive>(request, response),
				dogDnaArchive);
		List<DogDnaArchive> list = page.getList();
		for (DogDnaArchive dogDnaArchive2 : list) {
			if (StringUtils.isNotBlank(dogDnaArchive2.getDogBreed())) {
				DogType dogType = dogTypeService.getByDogBreedCode(dogDnaArchive2.getDogBreed());
				dogDnaArchive2.setDogBreed(dogType.getBreedCnName());
			}
		}
		model.addAttribute("page", page);

		model.addAttribute("orgType", org.getOrgType());
		return "partner/club/dogDnaArchiveList";
	}

	@RequestMapping(value = { "listBlood", "" })
	public String listBlood(DogBloodSave dogBloodSave, HttpServletRequest request, HttpServletResponse response,
			Model model) {
		Org org = (Org) UserUtils.getSession().getAttribute("org");
		dogBloodSave.setOrgId(org.getId());
		dogBloodSave.setIsOEC("0"); // 是否为口腔上皮细胞测试法:否0；是1
		Page<DogBloodSave> page = dogBloodSaveService.findPageAll(new Page<DogBloodSave>(request, response),
				dogBloodSave);

		List<DogBloodSave> list = page.getList();
		for (DogBloodSave dogBloodSave1 : list) {
			if (StringUtils.isNotBlank(dogBloodSave1.getDogBreed())) {
				DogType dogType = dogTypeService.getByDogBreedCode(dogBloodSave1.getDogBreed());
				dogBloodSave1.setDogBreed(dogType.getBreedCnName());
			}
			if (StringUtils.isNotBlank(dogBloodSave1.getRunningNumber())) {
				// 根据订单查询是否办理了位点分析
				DogDnaArchive dogDnaArchive = new DogDnaArchive();
				dogDnaArchive.setDelFlag("0");
				dogDnaArchive.setRunningNumber(dogBloodSave1.getRunningNumber());
				List<DogDnaArchive> dnalist = dogDnaArchiveDao.getBirthCodeAndPed(dogDnaArchive);
				DogDnaArchive birthCodeAndPed = null;
				if (dnalist.size() == 1) {
					birthCodeAndPed = dnalist.get(0);
				} else if (dnalist.size() > 1) {
					List<DogDnaArchive> dnalist2 = dnalist.stream()
							.filter(a -> (StringUtils.isNotBlank(a.getOverseasPedigreeCertified())
									&& a.getOverseasPedigreeCertified()
											.equals(dogBloodSave1.getOverseasPedigreeCertified()))
									|| (StringUtils.isNotBlank(a.getBirthCode())
											&& a.getBirthCode().equals(dogBloodSave1.getBirthCode()))
									|| (StringUtils.isNotBlank(a.getPedigreeCertified())
											&& a.getPedigreeCertified().equals(dogBloodSave1.getPedigreeCertified())))
							.collect(Collectors.toList());
					birthCodeAndPed = dnalist2.size() == 1 ? dnalist2.get(0) : null;
				}
				if (birthCodeAndPed != null && birthCodeAndPed.getId() != null) {
					dogBloodSave1.setDelete("1");
				} else {
					dogBloodSave1.setDelete("0");
				}
			}

		}
		model.addAttribute("orgType", org.getOrgType());
		model.addAttribute("page", page);
		return "partner/club/dogBloodSaveList";
	}

	@RequestMapping(value = { "editFrom", "" })
	public String editFrom(HttpServletRequest request, Model model) {
		String type = request.getParameter("type");
		String id = request.getParameter("id");
		if (type.equals("1")) {
			// 位点分析
			DogDnaArchive dogDnaArchive = dogDnaArchiveService.get(id);
			// Dog dog =
			// dogService.getByPedigreeCertifiedCode(dogDnaArchive.getBirthCode());
			// if (dog == null) {// 通过芯片查询
			// dog =
			// dogService.getByIdentificationFlag(dogDnaArchive.getPedigreeCertified());
			// if (dog == null) {
			// throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "无查询结果!");
			// }
			// }

			// Map<String, String> map = new HashMap<String, String>();
			model.addAttribute("dogName", dogDnaArchive.getDogName());
			if (org.apache.commons.lang3.StringUtils.isNotBlank(dogDnaArchive.getDogBreed())) {
				DogType dogType = dogTypeService.getByDogBreedCode(dogDnaArchive.getDogBreed());
				model.addAttribute("dogBreed", dogType.getBreedCnName());
			}
			model.addAttribute("dogOwnerCode", dogDnaArchive.getPaymentMemberCode());
			model.addAttribute("dogOwner", dogDnaArchive.getMemberName());
			model.addAttribute("type", "1");
			model.addAttribute("typeYes", dogDnaArchive.getTypeYes());
			model.addAttribute("id", dogDnaArchive.getId());
			model.addAttribute("isOEC", dogDnaArchive.getIsOEC());
			model.addAttribute("samplingCode", dogDnaArchive.getSamplingCode());
			return "partner/club/dogBloodSaveForm";
		} else {
			// 血样留存
			DogBloodSave dogBloodSave = dogBloodSaveService.get(id);
			Dog dog = null;
			if (StringUtils.isNotBlank(dogBloodSave.getPedigreeCertified())) {
				dog = dogService.getByPedigreeCertifiedCode(dogBloodSave.getPedigreeCertified());
			}
			if (StringUtils.isNotBlank(dogBloodSave.getBirthCode())) {
				dog = dogService.getByBirthCertificateLevelCode(dogBloodSave.getBirthCode());
			}
			if (dog == null) {// 通过芯片查询
				dog = dogService.getByIdentificationFlag(dogBloodSave.getChipCode());
				if (dog == null) {
					throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "请先完血统证书办理，办理完成采血状态将自动标记为已完成!");
				}
			}
			// Map<String, String> map = new HashMap<String, String>();
			model.addAttribute("dogName", dog.getNameEn());
			if (org.apache.commons.lang3.StringUtils.isNotBlank(dog.getDogBreed())) {
				DogType dogType = dogTypeService.getByDogBreedCode(dog.getDogBreed());
				model.addAttribute("dogBreed", dogType.getBreedCnName());
			}
			model.addAttribute("dogOwnerCode", dog.getMemberCode());
			model.addAttribute("dogOwner", dog.getDogOwner());
			model.addAttribute("type", "2");
			model.addAttribute("typeYes", dogBloodSave.getTypeYes());
			model.addAttribute("id", dogBloodSave.getId());
			return "partner/club/dogBloodSaveForm";
		}

	}

	@RequestMapping(value = { "edit", "" }, method = RequestMethod.POST)
	public String edit(HttpServletRequest request) {
		
		String type = request.getParameter("type");
		String dnayes = request.getParameter("dnayes");
		String id = request.getParameter("id");
		String samplingCode = request.getParameter("samplingCode");
		if (type.equals("1")) {
			// 位点分析
			clubDnaService.saveDogDnaArchive(dnayes, id, samplingCode);
			return "redirect:/partner/dna/list?repage";
		} else {
			// 血样留存
			DogBloodSave dogBloodSave = dogBloodSaveService.get(id);
			dogBloodSave.setTypeYes(dnayes);
			if ("2".equals(dnayes)) {
				dogBloodSave.setFinishTime(new Date());
			}
			dogBloodSaveService.save(dogBloodSave);
			return "redirect:/partner/dna/listBlood?repage";
		}

	}

	// @RequestMapping(value = {"list", ""})
	// public String list(DogDnaArchive dogDnaArchive, HttpServletRequest request,
	// HttpServletResponse response, Model model) {
	//
	// //分页
	// Org org = (Org) UserUtils.getSession().getAttribute("org");
	// dogDnaArchive.setOrgId(org.getId());
	// dogDnaArchive.setCreateBy(UserUtils.getUser());
	//
	// DogBloodSave dogBloodSave = new DogBloodSave();
	// dogBloodSave.setCreateBy(UserUtils.getUser());
	// if(StringUtils.isNotBlank(dogDnaArchive.getPaymentMemberCode())){
	// dogBloodSave.setPaymentMemberCode(dogDnaArchive.getPaymentMemberCode());
	// }
	// if(StringUtils.isNotBlank(dogDnaArchive.getPedigreeCertified())){
	// dogBloodSave.setPedigreeCertified(dogDnaArchive.getPedigreeCertified());
	// }
	// //留存方式
	// if(StringUtils.isNotBlank(dogDnaArchive.getTypeYes())){
	// dogBloodSave.setTypeYes(dogDnaArchive.getTypeYes());
	// }
	// Page<DogBloodSave> page = dogBloodSaveService.findPageAll(new
	// Page<DogBloodSave>(request, response), dogBloodSave);
	// List<DogBloodSave> list = page.getList();
	// //返回封装集合
	// List<DogDnaArchive> list1 = dogBloodSaveService.getList(list,
	// dogDnaArchive.getType());
	//
	// //返回分页对象
	// Page<DogDnaArchive> pageAll = dogBloodSaveService.findPageAll(new
	// Page<DogDnaArchive>(request, response), list1, dogDnaArchive,page);
	//
	//
	// model.addAttribute("page", pageAll);
	// return "partner/club/dogDnaArchiveList";
	// }
	/**
	 * 根据出生纸和标识码查询
	 * 
	 * @Author chaixueteng
	 * @2016年10月12日下午4:26:03
	 */
	@RequestMapping(value = "searchDnaMessage")
	@ResponseBody
	public Object searchDnaMessage(HttpServletRequest request, HttpServletResponse response) {
		Map<String, String> map = new HashMap<String, String>();
		try {
			String pedigreeCertifiedCode = request.getParameter("pedigreeCertifiedCode");
			map = clubDnaService.searchDnaMessage(pedigreeCertifiedCode.trim());
			map.put("rc", "0");
		} catch (Exception e) {
			map.put("rc", "1");
			map.put("msg", e.getMessage());
		}
		return map;
	}

	/**
	 * 添加DNA位点分析记录
	 * 
	 * @Author chaixueteng
	 * @2017年9月7日上午11:09:57
	 */
	@RequestMapping(value = "add")
	public String add(HttpServletRequest request, HttpServletResponse response, RedirectAttributes redirectAttributes) {
		String dogId = request.getParameter("dogId");
		String havaBlood = request.getParameter("havaBlood");
		String dna = request.getParameter("dna");
		String dnayes = request.getParameter("dnayes");
		String samplingCode = request.getParameter("samplingCode");
		try {
			clubDnaService.add(dogId, havaBlood, dna, dnayes,samplingCode);
			addMessage(redirectAttributes, "录入成功,请缴费");
		} catch (Exception e) {
			logger.warn("录入分析失败", e);
			addMessage(redirectAttributes, "录入分析失败:" + e.getMessage());
		}
		if (dna.equals("1")) {

			return "redirect:/partner/dna/list?repage";
		} else {
			return "redirect:/partner/dna/listBlood?repage";
		}

	}

	/**
	 * 删除位点分析记录
	 * 
	 * @Author chaixueteng
	 * @2017年9月7日下午2:27:00
	 */
	@RequestMapping(value = "delete")
	public String delete(HttpServletRequest request, RedirectAttributes redirectAttributes) {
		String id = request.getParameter("id");
		String type = request.getParameter("type");
		try {
			clubDnaService.delete(type, id);
			addMessage(redirectAttributes, "删除犬只DNA存档成功");
		} catch (Exception e) {
			addMessage(redirectAttributes, "删除犬只DNA存档失败:" + e.getMessage());
		}
		if (type.equals("1")) {// 位点
			return "redirect:/partner/dna/list?repage";
		} else {
			return "redirect:/partner/dna/listBlood?repage";
		}
	}

	/**
	 * 生成订单
	 * 
	 * @Author chaixueteng
	 * @2017年9月7日下午2:27:10
	 */
	@RequestMapping(value = "toOrder")
	public String toOrder(HttpServletRequest request, RedirectAttributes redirectAttributes, Model model) {
		Org org = (Org) UserUtils.getSession().getAttribute("org");
		// 重新查找 session域固定不变 所以需要重新查询 余额
		String id = org.getId();
		Org org2 = orgService.get(id);
		List<PaymentOrderDetail> list = new ArrayList<PaymentOrderDetail>();
		String type = request.getParameter("type");
		try {
			String id1 = request.getParameter("id");

			if (type.equals("1")) {// 位点
				DogDnaArchive dogDnaArchive = getId(id1);
				list = clubDnaService.toOrder(dogDnaArchive);
			}
			if (type.equals("2")) {// 血样
				DogBloodSave dogBloodSave = dogBloodSaveService.get(id1);
				list = clubDnaService.toOrder(dogBloodSave);
			}
		} catch (Exception e) {
			addMessage(redirectAttributes, "生成订单失败:" + e.getMessage());
			return "redirect:/partner/dna/list?repage";
		}
		String orderCode = list.get(0).getOrderCode();
		PaymentOrder byOrderCode = paymentOrderDao.getOrderByRunningNum(orderCode);
		model.addAttribute("orderId", byOrderCode.getId());
		model.addAttribute("paymentOrderDetail", list);
		model.addAttribute("org", org2);
		model.addAttribute("type", type);
		return "partner/sys/dogDnaPayPage";

	}

}
