package com.cku.oa.tcb.service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.kennel.dao.KennelDao;
import com.cku.oa.kennel.entity.Kennel;
import com.cku.oa.sys.dao.user.MemberDao;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.util.MemberUtil;
import com.cku.oa.tcb.dao.TcbKennelDao;
import com.cku.oa.tcb.entity.TcbKennel;
import com.cku.util.DateUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;

/**
 * 淘宠宝犬舍Service
 * @author lgl
 * @version 2017-02-21
 */
@Service
@Transactional(readOnly = true)
public class TcbKennelService extends CrudService<TcbKennelDao, TcbKennel> {

	@Autowired
	private MemberDao memberDao;
	@Autowired
	private KennelDao kennelDao;

	public TcbKennel get(String id) {
		return super.get(id);
	}
	
	public List<TcbKennel> findList(TcbKennel tcbKennel) {
		return super.findList(tcbKennel);
	}
	
	public Page<TcbKennel> findPage(Page<TcbKennel> page, TcbKennel tcbKennel) {
		return super.findPage(page, tcbKennel);
	}
	
	@Transactional(readOnly = false)
	public void save(TcbKennel tcbKennel) {
		super.save(tcbKennel);
	}
	
	@Transactional(readOnly = false)
	public void delete(TcbKennel tcbKennel) {
		super.delete(tcbKennel);
	}

	public Map<String, Object> setMemberInfo(String memberCode) throws Exception {
		Map<String, Object> map = new HashMap<String, Object>();
		//会员信息
		Member member = memberDao.getByMemberCode(memberCode);
		if(member==null){
			map.put("status", 1);
			map.put("msg", "会员号有误!");
			return map;
		}
		map.put("memberName", member.getName());
		String memberGender = "";
		if("male".equals(member.getGender())){
			memberGender = "男";
		}
		if("female".equals(member.getGender())){
			memberGender = "女";
		}
		map.put("memberGender", memberGender);
		map.put("memberCardType", member.getCardType());
		map.put("memberCardNo", member.getCardNo());
		map.put("memberMobile", member.getMobile());
		map.put("memberAddress", member.getProvince()+member.getCity()+member.getStreet()+member.getAddress());
		String memberMemberType = "";
		if(StringUtils.isNotBlank(member.getMemberType())){
			memberMemberType = member.getMemberType();
			if("basic".equals(member.getMemberType())){
				memberMemberType = "基础会员";
			}
			if("professional".equals(member.getMemberType())){
				memberMemberType = "专业会员";
			}
		}
		map.put("memberMemberType", memberMemberType);
		String memberEndDate = "";
		if(member.getMemberEndDate()!=null){
			memberEndDate = DateUtils.dateToStr(member.getMemberEndDate());
		}
		map.put("memberMemberEndDate", memberEndDate);
		//是否已经存在这样的记录
		if(isExistMemberCode(memberCode)){
			map.put("status", 1);
			map.put("msg", "该会员已经办理了淘宠犬舍业务");
			return map;
		}
		//会员是否是有效专业会员
		if(!"professional".equals(member.getMemberType())|| !MemberUtil.isActiveMember(member)){
			map.put("status", 1);
			map.put("msg", "该会员不是有效专业会员");
			return map;
		}
		//犬舍信息
		Kennel kennel = kennelDao.getKennelByMemberCode(memberCode);
		if(kennel==null){
			map.put("status", 1);
			map.put("msg", "该会员没有相关的犬舍信息");
			return map;
		}
		map.put("kennelName", kennel.getName());
		String kennelEndTime = "";
		if(kennel.getEndTime()!=null){
			kennelEndTime = DateUtils.dateToStr(kennel.getEndTime());
		}
		map.put("kennelEndTime", kennelEndTime);
		//有效犬舍校验
		if(kennel.getEndTime()==null||kennel.getEndTime().getTime()<System.currentTimeMillis()){
			map.put("status", 1);
			map.put("msg", "犬舍无效");
			return map;
		}
		return map;
	}

	/**
	 * @description: 判断该会员是否已有淘宠犬舍记录，有返回true
	 * @author: laiguanglong
	 * @date: 2017/2/22 11:57
	 */
	public boolean isExistMemberCode(String memberCode){
		if(StringUtils.isBlank(memberCode)){
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "会员号为空");
		}
		boolean flag = false;
		if(dao.countByMemberCode(memberCode)>0){
			flag = true;
		}
		return flag;
	}
	/**
	 * @description: 判断该合同号是否已经存在，存在返回true
	 * @author: laiguanglong
	 * @date: 2017/2/22 11:58
	 */
	public boolean isExistContractCode(String contractCode){
		if(StringUtils.isBlank(contractCode)){
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "合同号为空");
		}
		boolean flag = false;
		if(dao.countByContractCode(contractCode)>0){
			flag = true;
		}
		return flag;
	}

	@Transactional(readOnly = false)
	public void add(TcbKennel tcbKennel){
		//淘宠犬舍业务校验
		validate(tcbKennel);
		save(tcbKennel);
	}

	/**
	 * @description: 淘宠犬舍业务校验
	 * @author: laiguanglong
	 * @date: 2017/2/22 14:51
	 */
	public void validate(TcbKennel tcbKennel){
		if(isExistMemberCode(tcbKennel.getMemberCode())){
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该会员已经办理了淘宠犬舍业务");
		}
		if(isExistContractCode(tcbKennel.getContractCode())){
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该合同号已经存在");
		}
		//有效专业会员
		Member member = memberDao.getByMemberCode(tcbKennel.getMemberCode());
		if(member==null){
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "会员号有误");
		}
		if(!"professional".equals(member.getMemberType())|| !MemberUtil.isActiveMember(member)){
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该会员不是有效专业会员");
		}
		//有效犬舍
		Kennel kennel = kennelDao.getKennelByMemberCode(tcbKennel.getMemberCode());
		if(kennel==null){
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该会员没有相关的犬舍信息");
		}
		if(kennel.getEndTime()==null||kennel.getEndTime().getTime()<System.currentTimeMillis()){
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬舍无效");
		}
	}

	/**
	 * @description: 加急费用是否免收，返回true表示免收加急费
	 * @author: laiguanglong
	 * @date: 2016/12/30 10:42
	 */
	public boolean isUrgentFree(String memberCode){
		boolean flag = false;
		long now = System.currentTimeMillis();
		//不校验犬舍是否有效，因为配种证明、出生证明申请业务已经校验母犬主有犬舍，且犬舍有效
//		Kennel kennel = kennelService.getKennelByMemberCode(memberCode);
//		if(kennel!=null&&kennel.getEndTime()!=null&&kennel.getEndTime().getTime()>now){
		TcbKennel tcbKennel = dao.getByMemberCode(memberCode);
		if(tcbKennel!=null
				&&tcbKennel.getStartDate()!=null
				&&tcbKennel.getEndDate()!=null
				&&tcbKennel.getStartDate().getTime()<now
				&&tcbKennel.getEndDate().getTime()>now){
				flag = true;
		}
//		}
		return flag;
	}
}