package com.cku.oa.sys.service.user;

import java.io.IOException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.text.StrBuilder;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.shiro.SecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.web.multipart.MultipartFile;

import com.cku.core.RESTResponse;
import com.cku.core.ResultDto;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.activity.dao.SysMemberActivityRecordDao;
import com.cku.oa.activity.entity.SysMemberActivityRecord;
import com.cku.oa.activity.service.SysMemberActivityRecordService;
import com.cku.oa.dog.dao.DogDao;
import com.cku.oa.dog.dao.DogSemenDao;
import com.cku.oa.dog.entity.DogSemen;
import com.cku.oa.finance.dao.PaymentChargingItemDao;
import com.cku.oa.finance.dao.PaymentOrderDao;
import com.cku.oa.finance.dao.PaymentOrderDetailDao;
import com.cku.oa.finance.entity.PaymentCart;
import com.cku.oa.finance.entity.PaymentChargingItem;
import com.cku.oa.finance.entity.PaymentOrder;
import com.cku.oa.finance.entity.PaymentOrderDetail;
import com.cku.oa.finance.entity.PaymentOrderProject;
import com.cku.oa.finance.entity.PaymentRecord;
import com.cku.oa.finance.service.PaymentCartService;
import com.cku.oa.finance.service.PaymentChargingItemGroupService;
import com.cku.oa.finance.service.PaymentChargingItemService;
import com.cku.oa.finance.service.PaymentOrderProjectService;
import com.cku.oa.finance.service.PaymentRecordService;
import com.cku.oa.groomer.dao.GroomerQualificationCertificateDao;
import com.cku.oa.groomer.dao.GroomerRegisterDao;
import com.cku.oa.groomer.entity.GroomerQualificationCertificate;
import com.cku.oa.groomer.entity.GroomerRegister;
import com.cku.oa.handler.dao.HandlerQualificationCertificateDao;
import com.cku.oa.handler.dao.HandlerRegisterDao;
import com.cku.oa.handler.entity.HandlerQualificationCertificate;
import com.cku.oa.handler.entity.HandlerRegister;
import com.cku.oa.kennel.dao.KennelDao;
import com.cku.oa.kennel.entity.Kennel;
import com.cku.oa.kennel.service.KennelService;
import com.cku.oa.report.vo.ReportMemberVO;
import com.cku.oa.sys.code.SysCodeUtil;
import com.cku.oa.sys.dao.SysBussinessLogsDao;
import com.cku.oa.sys.dao.user.CabSysUserThirdRefDao;
import com.cku.oa.sys.dao.user.MemberDao;
import com.cku.oa.sys.entity.LoginServer;
import com.cku.oa.sys.entity.MemberSyncTask;
import com.cku.oa.sys.entity.NoseprintSwitchSettingLog;
import com.cku.oa.sys.entity.RestShareMember;
import com.cku.oa.sys.entity.RestShareRegister;
import com.cku.oa.sys.entity.SysBussinessLogs;
import com.cku.oa.sys.entity.SysMemberKennelModifyLog;
import com.cku.oa.sys.entity.user.CabSysUser;
import com.cku.oa.sys.entity.user.CabSysUserThirdRef;
import com.cku.oa.sys.entity.user.CardTypeEnum;
import com.cku.oa.sys.entity.user.IEnum;
import com.cku.oa.sys.entity.user.KennelType;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.entity.user.MemberCardTypeEnum;
import com.cku.oa.sys.entity.user.MemberClubTypeEnum;
import com.cku.oa.sys.entity.user.MemberType;
import com.cku.oa.sys.entity.user.MemberTypeEnum;
import com.cku.oa.sys.service.LoginServerService;
import com.cku.oa.sys.service.MemberSyncTaskService;
import com.cku.oa.sys.service.NoseprintSwitchSettingLogService;
import com.cku.oa.sys.service.RemindService;
import com.cku.oa.sys.service.SysMemberKennelModifyLogService;
import com.cku.oa.sys.util.CheckPswUtil;
import com.cku.oa.sys.util.IPLimitUtil;
import com.cku.oa.sys.util.MemberUtil;
import com.cku.oa.sys.util.PinYinUtil;
import com.cku.oa.sys.util.ValidateUtil;
import com.cku.oa.sys.zalog.SysContext;
import com.cku.restful.v1.sys.model.CancelVerifyResp;
import com.cku.restful.v1.sys.model.VerifyInfoResp;
import com.cku.restful.v1.sys.service.RestIDCardService;
import com.cku.util.MD5Generator;
import com.google.common.collect.Lists;
import com.thinkgem.jeesite.common.persistence.BaseEntity;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.thinkgem.jeesite.common.utils.Collections3;
import com.thinkgem.jeesite.common.utils.DateUtils;
import com.thinkgem.jeesite.common.utils.IdGen;
import com.thinkgem.jeesite.common.utils.JedisUtils;
import com.thinkgem.jeesite.common.utils.excel.ExportExcel;
import com.thinkgem.jeesite.common.utils.excel.ImportExcel;
import com.thinkgem.jeesite.modules.sys.dao.UserDao;
import com.thinkgem.jeesite.modules.sys.entity.Dict;
import com.thinkgem.jeesite.modules.sys.entity.User;
import com.thinkgem.jeesite.modules.sys.utils.DictUtils;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

/**
 * 用户会员信息表Service
 *
 * @author fanhuibin
 * @version 2016-07-07
 */
@Service
@Transactional(readOnly = true)
public class MemberService extends CrudService<MemberDao, Member> {

	private static final String RECHARGE = "sys_member@recharge";

	@Autowired
	private RemindService remindService;
	@Autowired
	private PaymentOrderDao paymentOrderDao;
	@Autowired
	private PaymentOrderDetailDao paymentOrderDetailDao;
	@Autowired
	private PaymentRecordService paymentRecordService;
	@Autowired
	private PaymentChargingItemDao paymentChargingItemDao;
	@Autowired
	private PaymentOrderProjectService paymentOrderProjectService;
	@Autowired
	private UserDao userDao;
	@Autowired
	private PaymentCartService paymentCartService;
	@Autowired
	private PaymentChargingItemService paymentChargingItemService;
	@Autowired
	public LoginServerService loginServerService;
	@Autowired
	public KennelDao kennelDao;
	@Autowired
	public MemberDao memberDao;
	@Autowired
	public KennelService kennelService;
	@Autowired
	private SysBussinessLogsDao sysBussinessLogsDao;

	@Autowired
	private RestIDCardService restIDCardService;

	@Autowired
	private SysMemberActivityRecordDao sysMemberActivityRecordDao;

	@Autowired
	private SysMemberActivityRecordService sysMemberActivityRecordService;

	@Autowired
	private PaymentChargingItemGroupService paymentChargingItemGroupService;

	@Autowired
	private CabSysUserThirdRefDao cabSysUserThirdRefDao;

	@Value("${touxiangUrl}")
	private String shareUrl;

	@Autowired
	private MemberSyncTaskService memberSyncTaskService;

	@Autowired
	private MemberActivity20201212Discount memberActivity20201212Discount;

	@Autowired
	private NoseprintSwitchSettingLogService noseprintSwitchSettingLogService;

	@Autowired
	private SysMemberKennelModifyLogService sysMemberKennelModifyLogService;

	@Autowired
	private DogDao dogDao;

	@Autowired
	private DogSemenDao dogSemenDao;

	@Autowired
	private GroomerRegisterDao groomerRegisterDao;

	@Autowired
	private GroomerQualificationCertificateDao groomerQualificationCertificateDao;

//	@Autowired
//	private SMSRemindService smsRemindService;
	@Autowired
	private HandlerRegisterDao handlerRegisterDao;
	@Autowired
	private HandlerQualificationCertificateDao handlerQualificationCertificateDao;

	public List<Member> findGroomerCertificateList(Member member) {
		return dao.findGroomerCertificateList(member);
	}

	/**
	 * 通过id查询用户信息
	 */
	public Member get(String id) {
		return super.get(id);
	}

	public Member getByMemberCode(String memberCode) {
		return dao.getByMemberCode(memberCode);
	}

	public List<Member> getByMemberCodeAMobile(String memberCode) {
		return dao.getByMemberCodeAMobile(memberCode);
	}

	public List<Member> getByMemberCodes(Set<String> memberCodes) {
		return dao.getByMemberCodes(memberCodes);
	}

	public RESTResponse getUseMember(String memberCode) {
		Member member = dao.getByMemberCode(memberCode);
		if (!MemberUtil.isActiveMember(member)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "会员无效！");
		}
		return new RESTResponse();
	}

	public RESTResponse getReferee(String memberCode) {
		Member member = dao.getByMemberCode(memberCode);
		if (!MemberUtil.isActiveMember(member)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "推荐编号有误，请重新填写或删除！");
		}
		return new RESTResponse();
	}

	/**
	 * 分页查询用户列表
	 */
	public Page<Member> findPage(Page<Member> page, Member sysMember) {
		sysMember.setPage(page);
		page.setIbatisPagePluginEnable(false);
		// 根据当前登录账号查询可查询的会员站点
		sysMember.getSqlMap().put("memberSiteMap", loginServerService.getMemberSiteByAlike());
		int count = dao.listCount(sysMember);
		int pageNo = page.getPageNo();
		int pageSize = page.getPageSize();
		page.setCount(count);
		if ((pageNo - 1) * pageSize >= count) {
			page.setList(new ArrayList<Member>(0));
			return page;
		}
		page.setList(dao.findList(sysMember));
		return page;
	}

	/**
	 * 淘宠宝会员添加方法
	 *
	 * @param sysMember
	 */
	@Transactional(readOnly = false)
	public void tcsave(Member sysMember) {
		// 保存淘宠宝会员的基本信息
		// 校验用户提交的数据，如果不合法，抛出异常
		if (!sysMember.getGender().equals("male") && !sysMember.getGender().equals("female")) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "用户的性别格式不正确");
		}
		if (!ValidateUtil.Mobile(sysMember.getMobile())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "手机号格式不正确");
		}
		/*
		 * if(!ValidateUtil.Email(sysMember.getEmail())){ throw new
		 * ZAException(ZAErrorCode.ZA_VALID_FAILED,"邮箱格式不正确"); }
		 */

		// 身份证号不能重复
		if (StringUtils.isBlank(sysMember.getCardNo())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "身份证号不能为空");
		}
		if (dao.countByCardNo(sysMember) > 0) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该身份证号码已注册会员，请勿重复注册");
		}
		if (dao.countByContractCode(sysMember) > 0) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该淘宠会员合同编号已注册会员，请勿重复注册");
		}
		// 校验身份证黑名单
		checkCardNoBlackList(sysMember);
		sysMember.preInsert();
		sysMember.setNameEn(PinYinUtil.getFullSpell(sysMember.getName()));
		sysMember.setPaymentState("2"); // 未付费
		Date current = new Date();// 当前日期
		String date = DateUtils.get1YearLater(current);
		sysMember.setMemberEndDate(DateUtils.parseDate(date));
		sysMember.setKuFlag(null);
		sysMember.setKuEndDate(null);
		sysMember.setGroomerEndDate(null);
		sysMember.setDgMemberType(null);
		sysMember.setDgEndDate(null);
		sysMember.setMemberCode(SysCodeUtil.getMemberCode());
		sysMember.setAccountBalance("0");
		sysMember.setPrintState("0");
		sysMember.setReviewState("0");// 审核状态
		User u = UserUtils.getLoginUser();
		if (u != null) {
			sysMember.setRegistrant(u.getName());// 登记人
		}
		// dao.insert(sysMember); modified by GYH
		insertMemberAndSyncTask(sysMember);
	}

	@Transactional(readOnly = false)
	public void save(Member sysMember) {
		// 保存用户的基本信息
		if (sysMember.getIsNewRecord()) {// 新加会员才校验 编辑不校验了
			// 校验用户提交的数据，如果不合法，抛出异常
			if (!sysMember.getGender().equals("male") && !sysMember.getGender().equals("female")) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "用户的性别格式不正确");
			}
			try {
				if (!ValidateUtil.Mobile(sysMember.getMobile())) {
					throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "手机号格式不正确");
				}
			} catch (Exception e) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "手机号格式不正确");
			}
			/*
			 * if(!ValidateUtil.Email(sysMember.getEmail())){ throw new
			 * ZAException(ZAErrorCode.ZA_VALID_FAILED,"邮箱格式不正确"); }
			 */
			// 身份证号不能重复
			if (StringUtils.isBlank(sysMember.getCardNo())) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "身份证号不能为空");
			}
			if (dao.countByCardNo(sysMember) > 0) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该身份证号码已注册会员，请勿重复注册");
			}
			// 校验身份证黑名单
			checkCardNoBlackList(sysMember);
			sysMember.setSafeMobile(sysMember.getMobile());
			sysMember.preInsert();
			sysMember.setNameEn(PinYinUtil.getFullSpell(sysMember.getName()));
			sysMember.setPaymentState("1"); // 未付费
			sysMember.setMemberEndDate(null);
			sysMember.setKuFlag(null);
			sysMember.setKuEndDate(null);
			sysMember.setGroomerEndDate(null);
			sysMember.setDgMemberType(null);
			sysMember.setDgEndDate(null);
			String memberCode = "";
			if (StringUtils.isBlank(sysMember.getMemberCode())) {
				memberCode = SysCodeUtil.getMemberCode();
				// 其他站点
				if (!StringUtils.isBlank(sysMember.getMemberSite()) && !sysMember.getMemberSite().equals("0")) {
					LoginServer loginServer = loginServerService.getLoginServerByMemberSite(sysMember.getMemberSite());
					memberCode = loginServer.getUserShortName().toUpperCase() + memberCode;
				}
			} else {
				memberCode = sysMember.getMemberCode();
			}
			sysMember.setMemberCode(memberCode);
			sysMember.setAccountBalance("0");
			sysMember.setPrintState("0");
			sysMember.setReviewState("0");// 审核状态

			User u = UserUtils.getLoginUser();
			if (u != null) {
				sysMember.setRegistrant(u.getName());// 登记人
			}

			// 保存用户头像历史记录
			saveMemberAvatarHistory(sysMember);
			// dao.insert(sysMember); modified by GYH
			insertMemberAndSyncTask(sysMember);
			if (MemberCardTypeEnum.PLATINUM_CARD.code().equals(sysMember.getMemberCardType())
					|| MemberCardTypeEnum.PURPLE_CARD.code().equals(sysMember.getMemberCardType())) {
				if (sysMember.getKennel() == null || StringUtils.isBlank(sysMember.getKennel().getName())) {
					throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬舍信息为空，无法保存");
				}
				validateKennelBusiness(sysMember.getKennel(), sysMember);
				Kennel kennel = new Kennel();
				kennel.setName(sysMember.getKennel().getName());
				if (!kennel.getName().endsWith("犬舍")) {
					kennel.setName(kennel.getName() + "犬舍");
				}
				kennel.setNameEn(sysMember.getKennel().getNameEn());
				kennel.setFciName(sysMember.getKennel().getFciName());
				kennel.setFciNameBackup(sysMember.getKennel().getFciNameBackup());
				kennel.setMemberCode(sysMember.getMemberCode());
				kennel.setKennelCode(sysMember.getMemberCode());
				kennel.setType(MemberCardTypeEnum.PLATINUM_CARD.code().toString().equals(sysMember.getMemberCardType())
						? KennelType.year.toString()
						: KennelType.permanent.toString());
				kennel.setReviewState("0");// 新申请犬舍初始审核状态
				kennel.setFciReviewState("0");// 新申请犬舍初始审核状态
				kennel.setPrintState("0");// 新申请犬舍初始审核状态
				kennel.setFciPrintState("0");// 新申请犬舍初始审核状态
				kennel.setId(IdGen.uuid());
				kennel.setCreateDate(new Date());
				kennel.setUpdateDate(kennel.getCreateDate());
				kennel.setCreateBy(sysMember.getCreateBy());
				kennel.setUpdateBy(sysMember.getCreateBy());
				kennelDao.insert(kennel);
			}
			// 会员提醒
			String date = new SimpleDateFormat("yyyy年MM月dd日HH时mm分").format(sysMember.getCreateDate());
			String type = "";
			if (MemberCardTypeEnum.PLATINUM_CARD.code().equals(sysMember.getMemberCardType())
					|| MemberCardTypeEnum.PURPLE_CARD.code().equals(sysMember.getMemberCardType())) {
				type = "繁育专业会员";
			} else {
				type = "爱宠会员";
			}
			StringBuffer sb = new StringBuffer();
			sb.append("您于").append(date).append("提交了").append(type).append("注册申请，请您务必于当日24时前完成缴费，过期订单失效哦。");
			remindService.addRemind(sb.toString(), sysMember.getMemberCode());
		} else {
			sysMember.preUpdate();
			String id = sysMember.getId();
			Member dbMember = dao.get(id);
			SysContext sysContext = new SysContext(dbMember.getPaymentState(), dbMember.getReviewState(), "0");
			if ("1".equals(sysMember.getReviewState())) {// 通过
				if (!"1".equals(dbMember.getReviewState())) {
					sysMember.setReviewState("1");
					User u = UserUtils.getLoginUser();
					if (u != null) {
						sysMember.setReviewer(u.getId());// 登记人
						sysMember.setReviewerName(u.getName());
					}
					sysMember.setReviewDate(new Date());
					sysContext.confirmSuccess(sysContext, "CKU会员", dbMember.getMemberCode(), "sys_member",
							dbMember.getId(), "", (str) -> {

							});
					remindService.addRemind("您提交的CKU会员信息信息已经审核通过。", sysMember.getMemberCode());
				}
			} else if ("2".equals(sysMember.getReviewState())) {// 未通过
				if (!"2".equals(dbMember.getReviewState())) {
					sysMember.setReviewState("2");
					User u = UserUtils.getLoginUser();
					if (u != null) {
						sysMember.setReviewer(u.getId());// 登记人
						sysMember.setReviewerName(u.getName());
					}
					sysMember.setReviewDate(new Date());
					sysContext.confirmFail(sysContext, "CKU会员", null, dbMember.getMemberCode(), "sys_member",
							dbMember.getId(), "", (str) -> {
							});
					remindService.addRemind("您提交的CKU会员信息信息已经审核失败，请重新提交。", sysMember.getMemberCode());
				}
			}

			if (!sysMember.getMemberCardType().equals(dbMember.getMemberCardType())) {

				// 原外籍会员不能修改会员类型为 铂金卡 紫金卡 待后期开发
				if (MemberCardTypeEnum.FOREIGN_CARD.code().equals(dbMember.getMemberCardType())
						&& (MemberCardTypeEnum.PLATINUM_CARD.code().equals(sysMember.getMemberCardType())
								|| MemberCardTypeEnum.PURPLE_CARD.code().equals(sysMember.getMemberCardType()))) {
					throw new ZAException(ZAErrorCode.ZA_ERROR, "会员类型错误，外籍会员暂不能修改为铂金卡，紫金卡，请修改为其他会员类型");
				}

				// 原正常会员不能修改外籍会员
				if (!MemberCardTypeEnum.FOREIGN_CARD.code().equals(dbMember.getMemberCardType())
						&& MemberCardTypeEnum.FOREIGN_CARD.code().equals(sysMember.getMemberCardType())) {
					throw new ZAException(ZAErrorCode.ZA_ERROR, "不允许修改为外籍会员！");
				}

				// 修改的会员等级 高于自身等级 提示错误
				if (!MemberCardTypeEnum.FOREIGN_CARD.code().equals(dbMember.getMemberCardType())
						&& StringUtils.isNotBlank(dbMember.getMemberCardType())
						&& Integer.valueOf(dbMember.getMemberCardType()) < Integer
								.valueOf(sysMember.getMemberCardType())) {
					throw new ZAException(ZAErrorCode.ZA_ERROR, "会员类型错误，只能修改为比自身等级低的类型");
				}

				// 会员有效期内，提示无法修改会员类型
				// 会员有效的情况下不能修改会员类型，无效可修改
				if (dbMember.getMemberEndDate() != null && dbMember.getMemberEndDate().after(new Date())) {
					throw new ZAException(ZAErrorCode.ZA_ERROR, "有效期内的会员，无法修改会员类型");
				}

				// 如果是铂金或紫金卡会员，降级时犬舍必须为注销状态
				if (MemberCardTypeEnum.PLATINUM_CARD.code().equals(dbMember.getMemberCardType())
						|| MemberCardTypeEnum.PURPLE_CARD.code().equals(dbMember.getMemberCardType())) {
					throw new ZAException(ZAErrorCode.ZA_ERROR, "铂金卡及以上会员，修改会员请先注销犬舍");
				}

				// 降级涉及 字段 sys_member：member_type，member_card_type,
				dao.updateMemberType(sysMember.getMemberCode(),
						IEnum.getMessage(MemberCardTypeEnum.class, sysMember.getMemberCardType()),
						sysMember.getMemberCardType());

			}
			// 保存用户头像历史记录
			saveMemberAvatarHistory(sysMember);
			// 记录注册地址修改信息
			if ((StringUtils.isNotEmpty(dbMember.getRegisterProvince())
					&& !dbMember.getRegisterProvince().equals(sysMember.getRegisterProvince()))
					|| (StringUtils.isNotEmpty(dbMember.getRegisterCity())
							&& !dbMember.getRegisterCity().equals(sysMember.getRegisterCity()))
					|| (StringUtils.isNotEmpty(dbMember.getRegisterArea())
							&& !dbMember.getRegisterArea().equals(sysMember.getRegisterArea()))
					|| (StringUtils.isNotEmpty(dbMember.getRegisterStreet())
							&& !dbMember.getRegisterStreet().equals(sysMember.getRegisterStreet()))) {

				SysMemberKennelModifyLog sysMemberKennelModifyLog = new SysMemberKennelModifyLog();
				sysMemberKennelModifyLog.setSqlInfo("OA");
				sysMemberKennelModifyLog.setMemberCode(sysMember.getMemberCode());
				StringBuffer sb = new StringBuffer();
				sb.append("原注册地址:").append(dbMember.getRegisterProvince()).append("-")
						.append(dbMember.getRegisterCity()).append("-").append(dbMember.getRegisterArea()).append("-")
						.append(dbMember.getRegisterStreet()).append(" ");
				sb.append("改变为:").append(sysMember.getRegisterProvince()).append("-")
						.append(sysMember.getRegisterCity()).append("-").append(sysMember.getRegisterArea()).append("-")
						.append(sysMember.getRegisterStreet()).append(" ");
				sysMemberKennelModifyLog.setContent(sb.toString());
				sysMemberKennelModifyLog.setSource("OA");
				sysMemberKennelModifyLog.setCreateTime(new Date());
				sysMemberKennelModifyLogService.save(sysMemberKennelModifyLog);
			}

			dao.update(sysMember);
			sysMemberActivityRecordService.saveMemberRecordWoOrder(dbMember, sysMember, sysMember.getCreateBy(), null);
			User user = sysMember.getUser();
			if (user != null) {
				// TODO：对user表的邮箱和手机进行查重
				// member进行更新时同步user表里的邮箱和手机
				user.setEmail(sysMember.getEmail());
				user.setMobile(sysMember.getMobile());
				userDao.updateEmailAndMobile(user);
				if ("1".equals(sysMember.getFreezeFlag())) {// 修改冻结会员禁止登陆会员中心
					if ("1".equals(user.getLoginFlag())) {
						user.setLoginFlag("0");
						userDao.updateLoginFlag(user);
					}
				} else {
					if (!"1".equals(user.getLoginFlag())) {
						user.setLoginFlag("1");
						userDao.updateLoginFlag(user);
					}
				}
			}
		}
	}

	@Transactional(readOnly = false, rollbackFor = Exception.class)
	public void delete(Member member) {
		Member dbMember = dao.get(member.getId());
		if (Objects.nonNull(dbMember) && StringUtils.isNoneBlank(dbMember.getUserId())) {
			throw new ZAException(ZAErrorCode.ZA_ERROR, "该会员已绑定登录账户，请解绑关系后在删除！");
		}
		super.delete(member);
	}

	/**
	 * 查询会员当前的缴费项。 外籍会员缴外籍会员费 普通会员缴基础会员费 专业会员缴专业会员费 专业会员过期或者 过期超过一个月，
	 * 则需要重新缴纳初次升级专业会员的费用
	 *
	 * @param member
	 * @return
	 */
	public String getPayItem(Member member) {
		if (Objects.equals(member.getMemberType(), "foreign")) {
			return "sys_member@WJ";
		}
		// 增加会员和犬舍日期是否同步校验
		if (member.getMemberEndDate() != null && member.getKennel() != null && member.getKennel().getEndTime() != null
				&& !DateUtils.isSameDay(member.getMemberEndDate(), member.getKennel().getEndTime())) {
			return "";
		}
		String memberRenewType = this.getMemberRenewalType(member);
		List<PaymentChargingItem> itemList = paymentChargingItemGroupService
				.findPaymentChargingItemById(memberRenewType.toString());
		if (itemList != null && !itemList.isEmpty()) {
			return itemList.stream().map(item -> item.getShortName()).collect(Collectors.joining(","));
		}
		return "";
	}

	/**
	 * example 99910109011010 拆解为 999(固定开头) 1010(会员自身卡片类型 100普卡 1010银卡 1020金卡
	 * 2030铂金卡 2040紫金卡) 9(固定中格) 0(升级续费标识 0续费 1升级) 1(会员过期标识 0日期为空 1未过期 2已过期)
	 * 1010(会员卡片类型 续费与前面的相同，升级时为具体要升级的卡片类型)
	 *
	 * 组装会员升级续费的业务类型 得到类型后 可以从 收费项关系表 查找相应的收费项
	 *
	 * @param member
	 * @return
	 */

	public String getMemberRenewalType(Member member) {
		StringBuilder memberRenewType = new StringBuilder();
		// 固定前缀
		memberRenewType.append("999");
		// 会员自身卡片类型
		memberRenewType.append(member.getMemberCardType());
		// 固定中格
		memberRenewType.append("9");
		// 此处为续费，则固定为 0
		memberRenewType.append("0");
		// 会员过期时间判断
		// 续费判断会员过期时，判断过期时间是否超过一个月，超过一个月内不缴纳初次费用，不算过期，所以依当前时间向前一个月为判断条件
		Calendar calendar = Calendar.getInstance();// 日历对象
		calendar.add(Calendar.MONTH, -1);// 月份+1

		if (member.getMemberEndDate() == null) {
			memberRenewType.append("0");
		} else if (calendar.getTime().after(member.getMemberEndDate())) {
			memberRenewType.append("2");
		} else {
			memberRenewType.append("1");
		}
		// 会员自身卡片类型
		memberRenewType.append(member.getMemberCardType());

		return memberRenewType.toString();
	}

	/**
	 * example 99910109112030 拆解为 999(固定开头) 1010(会员自身卡片类型 100普卡 1010银卡 1020金卡
	 * 2030铂金卡 2040紫金卡) 9(固定中格) 1(升级续费标识 0续费 1升级) 1(会员过期标识 0日期为空 1未过期 2已过期)
	 * 2030(会员卡片类型 续费与前面的相同，升级时为具体要升级的卡片类型)
	 *
	 * 组装会员升级续费的业务类型 得到类型后 可以从 收费项关系表 查找相应的收费项
	 *
	 * @param member
	 * @return
	 */
	public String getMemberUpgradeType(Member member, String upgradeType) {
		StringBuilder memberUpgradeType = new StringBuilder();
		// 固定前缀
		memberUpgradeType.append("999");
		// 会员自身卡片类型
		memberUpgradeType.append(member.getMemberCardType());
		// 固定中格
		memberUpgradeType.append("9");
		// 此处为升级，则固定为 1
		memberUpgradeType.append("1");
		// 会员过期时间判断
		// 续费判断会员过期时，判断过期时间是否超过一个月，超过一个月内不缴纳初次费用，不算过期，所以依当前时间向前一个月为判断条件
		Calendar calendar = Calendar.getInstance();// 日历对象
		calendar.add(Calendar.MONTH, -1);// 月份+1
		if (member.getMemberEndDate() == null) {
			memberUpgradeType.append("2");
		} else if (calendar.getTime().after(member.getMemberEndDate())) {
			memberUpgradeType.append("2");
		} else {
			memberUpgradeType.append("1");
		}
		// 会员要升级的卡片类型
		memberUpgradeType.append(upgradeType);

		return memberUpgradeType.toString();
	}

	/**
	 * 绑定会员与网站的登录帐号
	 *
	 * @param memberCode
	 * @param loginName
	 * @throws ZAException
	 */
	@Transactional(readOnly = false)
	public void bindUser(String memberCode, String loginName, String loginMobile) throws ZAException {
		Member member = this.getByMemberCode(memberCode);
		if (member == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "输入的会员信息有误,绑定失败");
		}
		// 冻结会员无法办理
		if ("1".equals(member.getFreezeFlag())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "冻结会员无法操作!");
		}
		// OA和会员中心都不允许绑定外籍会员
		if ("foreign".equals(member.getMemberType())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "不允许绑定外籍会员");
		}
		LoginServer loginServer = loginServerService.getLoginServerByMemberSite(member.getMemberSite());
		User user = UserUtils.getByLoginNameAndUserType(loginName, loginServer.getUserType());
		if (user == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "输入的用户登录帐号错误,或账号类型不支持");
		}
		// 校验账号是否可绑定会员
		loginServerService.validUserBind(user, member);

		// 判断当前用户是否已经绑定了其他会员
		Member tempMember = new Member();
		User tempUser = new User();
		tempUser.setId(user.getId());
		tempMember.setUser(tempUser);
		List result = this.findList(tempMember);
		if (result.size() > 0) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "当前的网站帐号已经绑定了其他会员，请先删除关联关系才能继续绑定。");
		}

		// if(!user.getUserType().equals("2")){
		// throw new
		// ZAException(ZAErrorCode.ZA_VALID_FAILED,"当前网站帐号类型不正确，只有会员自己注册的帐号才能绑定会员");
		// }

		member.setUser(user);
		if (member.getUser() != null && member.getUser().getLoginName() != null
				&& !member.getUser().getLoginName().equals("")) {
			// 检验用户是否可用

			if (StringUtils.isNotBlank(loginMobile)) {
				user.setBindMobile(loginMobile);
				user.setMobile(loginMobile);
				user.setPhone(loginMobile);
				userDao.updateAllMobile(user);
				member.setSafeMobile(loginMobile);
				member.setMobile(loginMobile);
				member.setPhone(loginMobile);
				dao.updateMemberAllMobile(member);
			}
			dao.updateBind(member);
		} else {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "录入的信息不完整，绑定失败");
		}

	}

	/**
	 * 解绑登录帐号与会员信息
	 *
	 * @param member 要解绑的用户
	 */
	@Transactional(readOnly = false)
	public void unbindUser(Member member) {
		Member m = this.getByMemberCode(member.getMemberCode());
		User user = new User();
		user.setId("");
		m.setUser(user);
		dao.updateBind(m);
	}

	/**
	 * 普通用户转为会员（会员中心使用）
	 *
	 * @param member 会员信息
	 * @throws ZAException 业务异常
	 */
	@Transactional(readOnly = false)
	public void memberRegister(Member member) throws ZAException {
		User user = member.getUser();
		if (user.getIsNewRecord()) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该会员的登录信息不存在，无法做用户身份转换");
		}
		member.setMemberCode(SysCodeUtil.getMemberCode());

		if (dao.getByCardNo(member.getCardNo(), member.getMemberSite()) != null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "此证件号已经录入，不可重复！");
		}
		if (emailCheck(member.getEmail(), member.getId(), member.getMemberSite()).contains("false")) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "邮箱重复，请重新输入！");
		}
		if (mobileCheck(member.getMobile(), member.getId(), member.getMemberSite()).contains("false")) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "手机号码重复，请重新输入！");
		}
		// 判断该会员是否已经存在
		Member example = new Member();
		User userExample = new User();
		userExample.setId(user.getId());
		example.setUser(userExample);
		if (dao.findList(example).size() > 0) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "已存在绑定的会员号");
		}
		// TODO:会员手机号和邮箱取User表的信息,由于user里的邮箱和电话已查重，所以这里不需要查重
		// member.setEmail(user.getEmail());
		// member.setMobile(user.getMobile());
		this.save(member);
		buildPaymentCart(member);
	}

	/**
	 * 写入购物车
	 *
	 * @Author chaixueteng
	 * @2016年9月25日上午11:11:41
	 */
	private void buildPaymentCart(Member member) {
		// 批次号
		String businessOrderCode = IdGen.uuid();
		// 专业会员缴费
		if (member.getMemberType().equals(MemberType.professional.toString())) {
			// 初次注册费
			PaymentCart paymentCart = new PaymentCart();
			PaymentChargingItem paymentChargingItem = paymentChargingItemService.getByShortName("sys_member@F");

			paymentCart.setChargingItemId(paymentChargingItem.getId());
			paymentCart.setChargingItemName(paymentChargingItem.getName());
			paymentCart.setNum("1");

			String price = paymentChargingItem.getPrice();
			paymentCart.setPrice(price);
			paymentCart.setTotalPrice(price);
			paymentCart.setBusinessIds(member.getId());
			paymentCart.setBusinessTable("sys_member");
			paymentCart.setBusinessOrderCode(businessOrderCode);
			paymentCartService.addToCart(paymentCart, "1021");

			// 年费
			PaymentCart paymentCart2 = new PaymentCart();
			PaymentChargingItem paymentChargingItem2 = paymentChargingItemService.getByShortName("sys_member@P");

			paymentCart2.setChargingItemId(paymentChargingItem2.getId());
			paymentCart2.setChargingItemName(paymentChargingItem2.getName());
			paymentCart2.setNum("1");

			String price2 = paymentChargingItem2.getPrice();
			paymentCart2.setPrice(price2);
			paymentCart2.setTotalPrice(price2);
			paymentCart2.setBusinessIds(member.getId());
			paymentCart2.setBusinessTable("sys_member");
			paymentCart2.setBusinessOrderCode(businessOrderCode);
			paymentCartService.addToCart(paymentCart2, "1021");

		} else {
			PaymentCart paymentCart = new PaymentCart();
			PaymentChargingItem paymentChargingItem = paymentChargingItemService.getByShortName("sys_member@B");

			paymentCart.setChargingItemId(paymentChargingItem.getId());
			paymentCart.setChargingItemName(paymentChargingItem.getName());
			paymentCart.setNum("1");

			String price = paymentChargingItem.getPrice();
			paymentCart.setPrice(price);
			paymentCart.setTotalPrice(price);
			paymentCart.setBusinessIds(member.getId());
			paymentCart.setBusinessTable("sys_member");
			paymentCart.setBusinessOrderCode(businessOrderCode);
			paymentCartService.addToCart(paymentCart, "1021");
		}
	}

	/**
	 * 会员升级服务（基础会员升级为专业会员）
	 *
	 * @param memberCode 会员号
	 * @throws ZAException 业务异常
	 */
	@Transactional(readOnly = false)
	public void memberGradeUpgraded(String memberCode) throws ZAException {
		Member member = this.getByMemberCode(memberCode);
		if (member == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该会员的登录信息不存在");
		}

		if (!MemberUtil.isBasicMember(member)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该会员不是普通会员，无法升级为专业会员");
		}

		member.setMemberType(MemberType.professional.toString());
		super.save(member);
	}

	/**
	 * 会员扣费
	 *
	 * @param memberCode
	 * @param chargeAcmount 扣费金额
	 * @return
	 */
	@Transactional(readOnly = false, rollbackFor = Exception.class)
	public void memberCharge(String memberCode, String chargeAcmount, String runningNumber) throws ZAException {
		Member member = dao.getByMemberCode(memberCode);
		// 判断会员余额是否冻结
		if ("1".equals(member.getBalanceBlockedFlag())) {
			throw new ZAException(ZAErrorCode.ZA_ERROR, "会员余额已冻结，不允许扣费");
		}
		int result = 0;
		String accountBalance = member.getAccountBalance();
		BigDecimal ab = new BigDecimal(accountBalance);
		BigDecimal ca = new BigDecimal(chargeAcmount);
		// 扣款费用大于余额时
		if (ab.compareTo(ca) < 0) {
			// C0014 应收账款 余额可以为负值
			// 财务扣费 可为负值 权限
			boolean hasPermission = SecurityUtils.getSubject().isPermitted("finance:deductCost:receivable");
			if ("C0014".equals(memberCode) && hasPermission) {

			} else {
				throw new ZAException(ZAErrorCode.ZA_ERC_PAYMENTRECORD_MEMBERMONEY_STATE, "会员余额不足！");

			}
		}
		;
		// 当扣费金额为0时跳过修改账户表
		if (ca.compareTo(BigDecimal.ZERO) > 0) {
			result = dao.memberCharge(memberCode, chargeAcmount);
			if (result <= 0) {
				throw new ZAException(ZAErrorCode.ZA_ERC_PAYMENTRECORD_MEMBERUPDATEFAIL_STATE, "修改会员余额失败！");
			}
		}
		// 增加原余额、变动
		int resultChange = dao.insertSysAccountBalanceChange(member.getMemberCode(), runningNumber, accountBalance,
				"-" + chargeAcmount);
		if (resultChange <= 0) {
			throw new ZAException(ZAErrorCode.ZA_ERC_PAYMENTRECORD_MEMBERUPDATEFAIL_STATE, "增加余额变动记录失败！");
		}
	}

	/**
	 * 会员充值
	 *
	 * @param memberCode
	 * @param rechargeAmount
	 * @param paymentTime
	 * @return
	 */
	@Transactional(readOnly = false)
	public void memberRecharge(String memberCode, String rechargeAmount, Date paymentTime, String runningNumber)
			throws ZAException {
		int result = 0;
		Member member = dao.getByMemberCode(memberCode);
		String accountBalance = member.getAccountBalance();
		BigDecimal ab = new BigDecimal(accountBalance);
		BigDecimal ra = new BigDecimal(rechargeAmount);
		result = dao.memberRecharge(memberCode, rechargeAmount, paymentTime);
		if (result <= 0) {
			throw new ZAException(ZAErrorCode.ZA_ERC_PAYMENTRECORD_MEMBERUPDATEFAIL_STATE, "修改会员余额失败！");
		}
		// 增加原余额、变动
		int resultChange = dao.insertSysAccountBalanceChange(member.getMemberCode(), runningNumber, accountBalance,
				rechargeAmount);
		if (resultChange <= 0) {
			throw new ZAException(ZAErrorCode.ZA_ERC_PAYMENTRECORD_MEMBERUPDATEFAIL_STATE, "增加余额变动记录失败！");
		}
	}

	/**
	 * 美容报名 证件照审核通过同步到会员表
	 *
	 * @param avatar
	 * @param memberCode
	 * @Author chaixueteng
	 * @2016年8月17日下午7:06:58
	 */
	@Transactional(readOnly = false)
	public void synImage(String memberCode, String avatar) {
		Member member2 = dao.getByMemberCode(memberCode);
		String oldAvatar = member2.getAvatar();
		if (!avatar.equals(oldAvatar)) {
			dao.synImage(memberCode, avatar);
		}
	}

	@Transactional(readOnly = false)
	public void memberGuoQiBeforeTwoWeek() {
		List<Member> list = dao.getList(14);
		for (Member member : list) {
			String date = DateFormatUtils.format(member.getMemberEndDate(), "yyyy年M月d日");
			StringBuffer sb = new StringBuffer();
			sb.append("您的cku会员将于").append(date).append("过期，为了不影响你的业务正常使用，请及时续费，续费期为有效期截止后的一个月内，超过续费期将按照新注册会员标准收费。");
			remindService.addRemind(sb.toString(), member.getMemberCode());
			System.out.println(sb);
		}
	}

	@Transactional(readOnly = false)
	public void memberGuoQiBeforeOneWeek() {
		List<Member> list = dao.getList(7);
		for (Member member : list) {
			String date = DateFormatUtils.format(member.getMemberEndDate(), "yyyy年M月d日");
			StringBuffer sb = new StringBuffer();
			sb.append("您的cku会员将于").append(date).append("过期，为了不影响你的业务正常使用，系统将于").append(date)
					.append("日自动从您账户扣除相应费用完成会员续费，请保证会员账户余额充足；如不需要支付下一年度会员费，请于尽快联系会员部办理退费。");
			remindService.addRemind(sb.toString(), member.getMemberCode());
			System.out.println(sb);
		}
	}

	/**
	 * 根据身份证号查询会员是否有效
	 *
	 * @Author chaixueteng
	 * @2016年9月23日上午10:38:34
	 */
	public Map<String, String> getByCardNo(String cardNo, String memberSite) {
		Map<String, String> map = new HashMap<String, String>();
		Member member = dao.getByCardNo(cardNo, memberSite);
		if (member != null) {
			String paymentState = member.getPaymentState();
			if ("2".equals(paymentState)) {// 有效会员
				map.put("isValid", "1");
				map.put("name", member.getName());
				map.put("memberCode", member.getMemberCode());
			} else {// 无效会员
				map.put("isValid", "2");
				map.put("name", member.getName());
				map.put("memberCode", member.getMemberCode());
			}
		} else {// 非会员
			map.put("isValid", "0");
		}
		return map;
	}

	/**
	 * 校验业务重复
	 *
	 * @Author chaixueteng
	 * @2016年9月25日上午11:07:54
	 */
	public void validateBusiness(Member po) {
		Member member = new Member();
		Member m = dao.getByCardNo(member.getCardNo(), po.getMemberSite());
		if (m != null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "您已经是CKU会员了,请勿重复申请!");
		}
	}

	public void validateKennelBusiness(Kennel kennel, Member member) {
		if (kennelDao.getKennelByMemberCode(member.getMemberCode()) != null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "您已经注册过犬舍，不能重复注册");
		}
		if (!MemberCardTypeEnum.PLATINUM_CARD.code().equals(member.getMemberCardType())
				&& !MemberCardTypeEnum.PURPLE_CARD.code().equals(member.getMemberCardType())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "只有专业会员才能申请注册犬舍");
		}
		if (!kennelService.nameCnCheck(kennel.getName(), member.getMemberCode())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬舍名称不正确");
		}
		if (!kennelService.nameEnCheck(kennel.getNameEn(), Boolean.TRUE, member.getMemberCode())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬舍英名称不正确");
		}
		if (!kennelService.nameEnCheck(kennel.getFciName(), Boolean.TRUE, member.getMemberCode())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬舍FCI英名称不正确");
		}
		if (!kennelService.nameEnCheck(kennel.getFciNameBackup(), Boolean.FALSE, member.getMemberCode())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬舍FCI备用英名称不正确");
		}
	}

	/**
	 *
	 * @description: 充值
	 * @author: laiguanglong
	 * @date: 2016年9月25日 下午3:06:00
	 */
	@Transactional(readOnly = false)
	public String recharge(String memberCode, String name, String amount, String paymentWay) {
		// 参数校验
		if (StringUtils.isBlank(memberCode)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "会员号为空");
		}
		if (StringUtils.isBlank(name)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "会员姓名为空");
		}
		if (StringUtils.isBlank(amount)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "金额为空");
		}
		if (StringUtils.isBlank(paymentWay)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "支付方式为空");
		}
		int amountInt;
		try {
			amountInt = Integer.parseInt(amount);
			// 过滤103账号
			if (amountInt < 1 && !"103".equals(memberCode)) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "金额不能低于1元");
			}
		} catch (Exception e) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "金额必须为整数");
		}
		// 103账号金额永远为0.01
		if ("103".equals(memberCode)) {
			amount = "0.01";
		}
		if (!"1".equals(paymentWay) && !"24".equals(paymentWay)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "支付方式只能是1或24");
		}
		// 校验会员是否存在
		Member member = dao.getByMemberCode(memberCode);
		if (member == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "会员号有误");
		}
		if (!member.getName().equals(name)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "会员姓名有误");
		}
		// 写入业务订单表
		PaymentOrder paymentOrder = new PaymentOrder();
		String runningNumber = SysCodeUtil.getPayRunningNumberWithMemberCode(memberCode);
		Date now = new Date();
		paymentOrder.setMemberCode(member.getMemberCode());
		paymentOrder.setMemberName(member.getName());
		paymentOrder.setOrderCode(runningNumber);
		paymentOrder.setTotalPrice(amount);
		paymentOrder.setPaymentWay(paymentWay);
		paymentOrder.setPaymentState("1");// 未支付
		paymentOrder.setAddTime(now);
		paymentOrder.setLocked("0");
		paymentOrder.preInsert();
		User user = UserUtils.getLoginUser();
		paymentOrder.setSource(user.getLoginType());
		paymentOrder.setCreateBy(user);
		paymentOrder.setUpdateBy(user);
		// 只有充值才设为1
		paymentOrder.setIsRecharge("1");
		paymentOrderDao.insert(paymentOrder);
		// 写入业务订单详情表
		PaymentOrderDetail detail = new PaymentOrderDetail();
		detail.setOrderCode(paymentOrder.getOrderCode());
		detail.setMemberCode(member.getMemberCode());
		detail.setMemberName(member.getName());
		PaymentChargingItem paymentChargingItem = paymentChargingItemDao.getByShortName(RECHARGE);
		detail.setChargingItemId(paymentChargingItem.getId());
		detail.setChargingItemName(paymentChargingItem.getName());
		detail.setNum("1");
		detail.setPrice(amount);
		detail.setTotalPrice(amount);
		detail.setAddTime(now);
		// detail.setBusinessIds(cart.getBusinessIds());
		// detail.setBusinessTable(cart.getBusinessTable());
		detail.preInsert();
		detail.setCreateBy(user);
		detail.setUpdateBy(user);
		paymentOrderDetailDao.insert(detail);
		return paymentOrder.getId();
	}

	/**
	 * 校验身份证号,email,手机号重复验证
	 *
	 * @Author chaixueteng
	 * @2016年10月11日下午1:59:47
	 */
	public String cardNoCheck(String param, String memberSite) {
		List<Member> m = dao.check("card_no", param, memberSite);
		if (m.size() > 0) {
			return "{\"rc\":false}";
		}
		return "{\"rc\":true}";
	}

	/**
	 * 校验身份证号,email,手机号重复验证
	 *
	 * @Author chaixueteng
	 * @2016年10月11日下午1:59:47
	 */
	public String emailCheck(String param, String id, String memberSite) {
		List<Member> m = dao.check("email", param, memberSite);
		if (m.size() > 0) {
			if (id != null) {
				String id2 = m.get(0).getId();
				if (!id2.equals(id)) {
					return "{\"rc\":false}";
				}
			} else {
				return "{\"rc\":false}";
			}
		}
		return "{\"rc\":true}";
	}

	/**
	 * 校验身份证号,email,手机号重复验证
	 *
	 * @Author chaixueteng
	 * @2016年10月11日下午1:59:47
	 */
	public String mobileCheck(String param, String id, String memberSite) {
		List<Member> m = dao.check("mobile", param, memberSite);
		if (m.size() > 0) {
			if (id != null) {
				String id2 = m.get(0).getId();
				if (!id2.equals(id)) {
					return "{\"rc\":false}";
				}
			} else {
				return "{\"rc\":false}";
			}
		}
		return "{\"rc\":true}";
	}

	/**
	 * @Description： 校验安全手机号重复验证
	 *
	 * @author: yuanshuai
	 * @date: 2017/12/22 10:45
	 */
	public String safeMobileCheck(String param, String id, String memberSite) {
		List<Member> m = dao.check("safe_mobile", param, memberSite);
		if (m.size() > 0) {
			if (id != null) {
				String id2 = m.get(0).getId();
				if (!id2.equals(id)) {
					return "{\"rc\":false}";
				}
			} else {
				return "{\"rc\":false}";
			}
		}
		return "{\"rc\":true}";
	}

	/**
	 *
	 * @Description：根据会员号对会员截止时间进行更改
	 * @author: zhuoHeng
	 * @version: 2016年10月31日 下午4:32:02
	 */
	@Transactional(readOnly = false)
	public int memberEndDatecharge(String memberCode, Date endDate, String memberType) throws ZAException {
		int result = 0;
		Member member = dao.getByMemberCode(memberCode);
		member.setMemberEndDate(endDate);
		result = dao.memberEndDatecharge(memberCode, endDate, memberType,
				UserUtils.getMemberType(member).toString() + UserUtils.getMemberCardType(member).toString());
		return result;
	}

	/**
	 * 修改会员姓名拼音
	 *
	 * @Author chaixueteng
	 * @2016年11月2日下午5:03:31
	 */
	@Transactional(readOnly = false)
	public void updateNameEn(Member member) {
		dao.update(member);
	}

	@Transactional(readOnly = false)
	public int updateUserId(String userId, String memberCode, String mobile) {
		return dao.updateUserId(userId, memberCode, mobile);
	}

	/**
	 * 首页 获取未审核的会员数量
	 *
	 * @Author chaixueteng
	 * @2016年8月30日下午5:42:46
	 */
	public int getAuditCount(String memberType) {
		Member member = new Member();
		member.setMemberType(memberType);
		member.setReviewState("0");
		return dao.getAuditCount(member);
	}

	/**
	 *
	 * @Description：更改个人证件照
	 * @author: zhuoHeng
	 * @version: 2016年12月15日 上午10:10:41
	 */
	@Transactional(readOnly = false)
	public void updateAvatar(String avatar, String id) {
		dao.updateAvatar(avatar, id);
	}

	/**
	 *
	 * @Description：基于手机号申请宠爱王国账号生成未缴费的会员信息
	 * @author: zhuoHeng
	 * @version: 2017年5月23日 下午2:19:59
	 */
	@Transactional(readOnly = false)
	public void newMemberRegister(Member member) throws ZAException {
		User user = member.getUser();
		if (user.getIsNewRecord()) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该会员的登录信息不存在，无法做用户身份转换");
		}
		if (dao.getByCardNo(member.getCardNo(), member.getMemberSite()) != null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "此证件号已经录入，不可重复！");
		}
		/*
		 * if(mobileCheck(member.getMobile(),member.getId()).indexOf("false")>-1){ throw
		 * new ZAException(ZAErrorCode.ZA_VALID_FAILED, "手机号码重复，请重新输入！"); };
		 */
		// 判断该会员是否已经存在
		Member example = new Member();
		User userExample = new User();
		userExample.setId(user.getId());
		example.setUser(userExample);
		if (dao.findList(example).size() > 0) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "已存在绑定的会员号");
		}
		// 设置安全手机
		member.setSafeMobile(user.getBindMobile());
		// 设置实名认证标识
		member.setAuthentication("1");
		this.save(member);
	}

	/**
	 * @description: 校验身份证黑名单
	 * @author: laiguanglong
	 * @date: 2017/8/31 16:46
	 */
	public void checkCardNoBlackList(Member member) {
		if (StringUtils.isNotBlank(member.getCardNo())) {
			if (dao.countOnCardNoBlackList(member.getCardNo()) > 0) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该身份证号已被锁定，无法注册会员");
			}
		}
	}

	/**
	 * @Description： 修改绑定的安全手机号
	 *
	 * @author: yuanshuai
	 * @date: 2017/12/21 11:06
	 */
	@Transactional(readOnly = false)
	public void updateMemberSafeMobile(Member member, String mobile) {
		member.setSafeMobile(mobile);
		dao.updateMemberSafeMobile(member);
	}

	@Transactional(readOnly = false)
	public void updateMemberEndDate(String memberCode, String endDate) {
		dao.updateMemberEndDate(memberCode, endDate);
	}

	@Transactional(readOnly = false)
	public void updateMemberCardTypeAndEndDate(String memberCode, String memberCardType, String endDate) {
		dao.updateMemberCardTypeAndEndDate(memberCode, memberCardType, endDate);
	}

	@Transactional(readOnly = false)
	public void updateMemberCardType(String memberCode, String memberCardType) {
		if (StringUtils.isNotBlank(memberCardType)) {
			dao.updateMemberCardType(memberCode, memberCardType);
		}
	}

	/**
	 * @Description： 修改绑定的安全手机号
	 *
	 * @author: yuanshuai
	 * @date: 2017/12/21 11:06
	 */
	@Transactional(readOnly = false)
	public void updateMemberAuthentication(Member member, String authentication) {
		member.setAuthentication(authentication);
		dao.updateMemberAuthentication(member);
	}

	@Transactional(readOnly = false)
	public void updateCardNo(Member member, String cardNo, String authentication) {
		member.setAuthentication(authentication);
		member.setCardNo(cardNo);
		dao.updateCardNo(member);
	}

	/**
	 * @Description： 实名认证
	 *
	 * @author: chaixueteng
	 * @date: 2018/01/03 11:06
	 */
	@Transactional(readOnly = false)
	public void authenticationVild(Member member) {
		if (!"foreign".equals(member.getMemberCardType())) {// 非外籍会员实名验证
			if (member.getIsNewRecord()) {// 新增的验证实名
				int flag = restIDCardService.validateIDCard(null, member.getCardNo(), member.getName(),
						member.getMemberSite(), true);
				if (flag == 0) {
					throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "实名认证失败，请重试");
				} else {
					member.setAuthentication(String.valueOf(flag));
				}
			}
		}
	}

	/**
	 * @Description： 修改会员、犬舍截止日期
	 *
	 * @author: chaixueteng
	 * @date: 2018/01/03 11:06
	 */
	@Transactional(readOnly = false)
	public void cardTimeEdit(String memberCode, String memberEndDate, String kennelEndTime) {
		if (memberCode == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "会员不存在,修改失败");
		}

		Member member = this.getByMemberCode(memberCode);
		Date oldEndDate = member.getMemberEndDate();
		if (member == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "会员信息有误,修改失败");
		}
		if (StringUtils.isNotBlank(memberEndDate)) {
			member.setMemberEndDate(DateUtils.parseDate(memberEndDate));
			member.preUpdate();
			dao.update(member);
		}

		if (!"undefined".equals(kennelEndTime)) {
			Kennel kennel = kennelDao.getKennelByMemberCode(memberCode);
			if (kennel == null) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬舍不存在,修改失败");
			}
			kennel.setEndTime(DateUtils.parseDate(kennelEndTime));
			kennelDao.update(kennel);
		}

		Member newMember = this.getByMemberCode(memberCode);
		member.setMemberEndDate(oldEndDate);
		sysMemberActivityRecordService.saveMemberRecordWoOrder(member, newMember, UserUtils.getUser(), null);

	}

	/**
	 * @Description： 修改身份证号码
	 *
	 * @author: chaixueteng
	 * @date: 2018/01/03 11:06
	 */
	@Transactional(readOnly = false)
	public void cardEdit(String memberCode, String memberName, String cardNo, String validType, String safeMobile) {
		Member member = this.getByMemberCode(memberCode);

		if (member == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "输入的会员信息有误,修改失败");
		}
		if (StringUtils.isBlank(memberName)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "姓名不可为空");
		}
		if (StringUtils.isBlank(cardNo)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "身份证号码不可为空");
		}
		// 查看证件号是否重复
		Member m = dao.getByMemberCode(memberCode);
		member.setName(memberName);
		member.setCardNo(cardNo);
		if ("MANUAL".equals(validType)) {// 选择手动验证
			member.setAuthentication("1");
			if (member.getRemarks() != null && !member.getRemarks().contains("手动实名认证")) {
				member.setRemarks(member.getRemarks() + " " + DateUtils.formatDate(new Date(), "yyyy-M-d") + "手动实名认证");
			}
			if (StringUtils.isNotBlank(safeMobile)) {
				member.setSafeMobile(safeMobile);
			}
			dao.updateCardNo(member);
		} else {// 选择自动验证
			int flag = restIDCardService.validateIDCard(null, member.getCardNo(), member.getName(),
					member.getMemberSite(), false);
			if (flag == 0) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "实名认证失败，请重试");
			} else {
				member.setAuthentication(String.valueOf(flag));
				dao.updateCardNo(member);
			}
		}
		// add by zjw 2022-08-31 认证通过后，但绑定手机号未认证的，同时修改APP端绑定账户的认证状态
		if ("1".equals(member.getAuthentication())) {
			CabSysUser cabSysUser = cabSysUserThirdRefDao.selectUserByThirdId(m.getUserId());
			if (Objects.nonNull(cabSysUser)) {
				cabSysUser.setRealName(member.getName());
				cabSysUser.setCardNo(member.getCardNo());
				cabSysUser.setAuthentication(member.getAuthentication());
				cabSysUserThirdRefDao.updateSysUserAuthentication(cabSysUser);
			}
		}
	}

	/**
	 * @description: 保存用户头像历史记录
	 * @author: laiguanglong
	 * @date: 2018/1/17 11:16
	 */
	@Transactional(readOnly = false)
	private void saveMemberAvatarHistory(Member member) {
		if (StringUtils.isNotBlank(member.getAvatar())) {
			Member po = dao.getByMemberCode(member.getMemberCode());
			if (po == null) {
				dao.saveMemberAvatarHistory(member);
			} else {
				if (!member.getAvatar().equals(po.getAvatar())) {
					dao.saveMemberAvatarHistory(member);
				}
			}
		}
	}

	/**
	 * @Description： 导入会员信息的模板
	 *
	 * @author: yuanshuai
	 * @date: 2019/5/29 17:28
	 */
	public String importFileTemplate(HttpServletResponse response) throws IOException {
		String fileName = "会员数据导入模板.xlsx";
		List<Member> list = Lists.newArrayList();
		Member member = new Member();
		member.setName("姓名");
		member.setGender("男/女");
		member.setBirthday(new Date());
		member.setCardNo("导入会员无实名校验");
		member.setProvince("xx省/xx市/xx区/国外");
		member.setCity("xx市/xx区/国外");
		member.setStreet("xxxxxx");
		member.setMemberType("基础会员/专业会员/外籍会员");
		member.setPaymentState("已缴费/未缴费");
		member.setMemberSite("CKU会员/CKUDC会员/CKUMC会员");
		list.add(member);
		new ExportExcel("会员信息", Member.class, 2).setDataList(list).write(response, fileName).dispose();
		return null;
	}

	/**
	 * 导入会员信息
	 *
	 * @author: yuanshuai
	 * @date: 2019/5/29 17:28
	 */
	@Transactional(readOnly = false)
	public void importMember(MultipartFile file)
			throws InvalidFormatException, IOException, IllegalAccessException, InstantiationException {
		ImportExcel ei = new ImportExcel(file, 1, 0);
		List<Member> list = ei.getDataList(Member.class);
		boolean error = false;
		StrBuilder strBuilder = new StrBuilder();
		for (Member member : list) {
			if (StringUtils.isBlank(member.getName())) {
				continue;
			}
			member.setName(StringEscapeUtils.unescapeHtml4(member.getName()));
			String memberType = DictUtils.getDictValue(member.getMemberType(), "user_member_type", null);
			if (StringUtils.isBlank(memberType)) {
				error = recordError(strBuilder, member.getName() + "会员类型有误");
			}
			member.setMemberType(memberType);
			String memberSite = DictUtils.getDictValue(member.getMemberSite(), "member_site", null);
			if (StringUtils.isBlank(memberSite)) {
				error = recordError(strBuilder, member.getName() + "会员站点有误");
			} else {
				member.setMemberSite(memberSite.replace("2", ""));
			}
			String gender = DictUtils.getDictValue(member.getGender(), "user_gender", null);
			if (StringUtils.isBlank(gender)) {
				error = recordError(strBuilder, member.getName() + "会员性别有误");
			}
			member.setGender(gender);
			// if (member.getBirthday() == null) {
			// error = recordError(strBuilder, member.getName() + "会员出生日期有误");
			// }
			if (StringUtils.isBlank(member.getCardNo())) {
				error = recordError(strBuilder, member.getName() + "会员身份证信息有误");
			} else if (dao.countByCardNo(member) > 0) {
				error = recordError(strBuilder, member.getName() + "该身份证号码已注册会员，请勿重复注册");
			} else {
				// 校验身份证黑名单
				checkCardNoBlackList(member);
			}
			if (StringUtils.isBlank(member.getMobile())) {
				error = recordError(strBuilder, member.getName() + "会员电话有误");
			}
			if (StringUtils.isBlank(member.getProvince()) || StringUtils.isBlank(member.getCity())
					|| StringUtils.isBlank(member.getStreet())) {
				error = recordError(strBuilder, member.getName() + "会员地址有误");
			}
			// 会员支付状态
			String paymentState = DictUtils.getDictValue(member.getPaymentState(), "user_payment_state", null);
			if (StringUtils.isBlank(paymentState)) {
				error = recordError(strBuilder, member.getName() + "会员支付状态有误");
			}
			member.setPaymentState(paymentState);
			// 校验订单项目
			PaymentOrderProject project = new PaymentOrderProject();
			project.setName(member.getOrderProject());
			if ("2".equals(paymentState)) {
				if (!StringUtils.isBlank(member.getOrderProject())) {
					List<PaymentOrderProject> projectList = paymentOrderProjectService.findList(project);
					if (projectList == null || projectList.size() == 0) {
						error = recordError(strBuilder, member.getName() + "订单项目名称有误");
					} else if (projectList.size() > 1) {
						error = recordError(strBuilder, member.getName() + "订单项目名称不唯一");
					} else {
						project = projectList.get(0);
					}
				} else {
					error = recordError(strBuilder, member.getName() + "订单项目名称为空");
				}
			}
			if (!error) {
				// 收费项
				String items = getPayItem(member);
				if ("2".equals(member.getPaymentState())) {
					// 会员截止日期
					member.setMemberEndDate(DateUtils.get1YearLaterDate(new Date()));
				}
				// 备注
				member.setRemarks(member.getImportRemark());
				// 默认数据
				member.setNameEn(PinYinUtil.getFullSpell(member.getName()));
				member.setKuFlag(null);
				member.setKuEndDate(null);
				member.setGroomerEndDate(null);
				member.setDgMemberType(null);
				member.setDgEndDate(null);
				// 会员号
				String memberCode = SysCodeUtil.getMemberCode();
				if (!StringUtils.isBlank(member.getMemberSite()) && !member.getMemberSite().equals("0")) {
					LoginServer loginServer = loginServerService.getLoginServerByMemberSite(member.getMemberSite());
					memberCode = loginServer.getUserShortName().toUpperCase() + memberCode;
				}
				member.setMemberCode(memberCode);
				member.setAccountBalance("0");
				member.setPrintState("0");
				member.setReviewState("0");// 审核状态
				member.setFreezeFlag("0");
				member.preInsert();
				if (StringUtils.isBlank(member.getCreateBy().getName())) {
					throw new ZAException(ZAErrorCode.ZA_ERROR, "用户登录信息有误");
				}
				member.setRegistrant(member.getCreateBy().getName());// 登记人
				// 已付款数据录入订单
				if ("2".equals(member.getPaymentState())) {
					buildImportOrder(member, items, project);
				}
				// dao.insert(sysMember); modified by GYH
				insertMemberAndSyncTask(member);
			}
		}
		if (error) {
			throw new ZAException(ZAErrorCode.ZA_ERROR, strBuilder.toString());
		}
	}

	/**
	 * @Description： 导入统一记录错误
	 *
	 * @author: yuanshuai
	 * @date: 2019/6/11 16:01
	 */
	private boolean recordError(StrBuilder strBuilder, String msg) {
		strBuilder.append(msg).append("##");
		return true;
	}

	/**
	 * @Description： 创建导入订单
	 *
	 * @author: yuanshuai
	 * @date: 2019/6/11 14:52
	 */
	private void buildImportOrder(Member member, String items, PaymentOrderProject project) {
		String orderCode = SysCodeUtil.getPayRunningNumber();
		Date now = new Date();
		Double orderTotal = Double.valueOf("0");
		// 生成订单明细
		for (String shortName : items.split(",")) {
			PaymentOrderDetail detail = new PaymentOrderDetail();
			detail.setOrderCode(orderCode);
			detail.setAddTime(now);
			detail.setProjectId(project.getId());
			detail.setProjectName(project.getName());
			detail.setProccessState("1");
			detail.setProccessTime(now);
			PaymentChargingItem item = paymentChargingItemDao.getByShortName(shortName);
			orderTotal = orderTotal + Double.parseDouble(item.getPrice());
			detail.setChargingItemId(item.getId());
			detail.setChargingItemName(item.getName());
			detail.setPrice(item.getPrice());
			detail.setTotalPrice(item.getPrice());
			detail.setNum("1");
			detail.setBusinessIds(member.getId());
			detail.setShowBusinessModelFlag("0");
			detail.setBusinessTable("sys_member");
			detail.setMemberCode(member.getMemberCode());
			detail.setMemberName(member.getName());
			detail.preInsert();
			paymentOrderDetailDao.insert(detail);
		}
		// 生成订单
		PaymentOrder order = new PaymentOrder();
		order.setSource("oa");
		// 比赛现场收入
		order.setPaymentWay("21");
		order.setOrderCode(orderCode);
		order.setAddTime(now);
		order.setLocked("0");
		order.setTotalPrice(orderTotal.toString());
		order.setPaymentState("2");
		order.setPaymentTime(now);
		order.setMemberCode(member.getMemberCode());
		order.setMemberName(member.getName());
		order.setProjectId(project.getId());
		order.setProjectName(project.getName());
		order.setReceiver(member.getName());
		order.setReceiveAddress(member.getAddress());
		order.setReceiveCity(member.getCity());
		order.setReceiveProvince(member.getProvince());
		order.setReceiveDel(member.getMobile());
		order.setReceivePostCode(member.getPostcode());
		order.preInsert();
		paymentOrderDao.insert(order);
		// 生成流水记录
		PaymentRecord paymentRecord = new PaymentRecord();
		paymentRecord.setRunningNumber(orderCode);
		paymentRecord.setBusinessId(member.getId());
		paymentRecord.setMemberCode(member.getMemberCode());
		paymentRecord.setPaymentState("2");
		paymentRecord.setPaymentWay(order.getPaymentWay());
		paymentRecord.setPaymentTime(now);
		paymentRecord.setPrice(order.getTotalPrice());
		paymentRecord.setPaymentAmount(order.getTotalPrice());
		paymentRecord.setPaymentRemarks("会员导入自动生成订单");
		// 所有现金收入都为96
		paymentRecord.setChargingItemId("96");
		paymentRecordService.newRecord(paymentRecord);
	}

	/**
	 * @Description： 会员转杜高马犬
	 *
	 * @author: zhangxiang
	 * @date: 2019/07/22 11:06
	 */
	@Transactional(readOnly = false)
	public void editMemberType(Member member, String type, String remarklogs) {
		if (StringUtils.isBlank(type)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "会员类型有误，请选择");
		}
		MemberClubTypeEnum clubType = IEnum.codeOf(MemberClubTypeEnum.class, type)
				.orElseThrow(() -> new ZAException(ZAErrorCode.ZA_VALID_FAILED, "会员不存在,修改失败"));
		if (Objects.isNull(member)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "会员不存在,修改失败");
		}
		if (!(MemberUtil.isActiveMember(member))) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该会员不是有效的会员");
		}
		if ((StringUtils.isBlank(member.getMemberSite()) ? "" : member.getMemberSite())
				.equals(clubType.equals(MemberClubTypeEnum.CKU) ? "" : clubType.message())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "转换身份类型与当前会员身份类型相同，无法转换");
		}
		Member yOldMember = dao.getByMemberCode(member.getMemberCode());
		// 判断要转换的身份是否存在
		List<CabSysUserThirdRef> thirdRefs = cabSysUserThirdRefDao.selectAllByThirdId(member.getUserId());
		CabSysUserThirdRef thirdRef = null;
		if (thirdRefs.stream().filter(ref -> clubType.code().equals(ref.getThirdType())).count() > 0) {
			thirdRef = thirdRefs.stream().filter(ref -> clubType.code().equals(ref.getThirdType())).findAny().get();
		}
		// 会员已存在相应身份，则校验被转类型是否有效
		Member newMember = null;
		if (Objects.nonNull(thirdRef)) {
			newMember = this.getByUserId(thirdRef.getThirdId());
			if (MemberUtil.isActiveMember(newMember)) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED,
						"该会员已存在有效的" + clubType.code().toUpperCase() + "身份，无法转换");
			}
			// 如会员未绑定身份，则校验相同身份证号的会员身份
		} else {
			Member tempMember = this.dao.findByMemberSiteAndCardNo(clubType.message(), member.getCardNo());
			if (!CollectionUtils.isEmpty(thirdRefs) && Objects.nonNull(tempMember)) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED,
						"已存在与会员身份证号相同的" + clubType.code().toUpperCase() + "身份，但身份未与该会员绑定，请绑定身份后重试");
			} else {
				newMember = tempMember;
			}
		}
		// 如未找到会员相应身份，则创建新身份
		if (Objects.isNull(newMember)) {
			newMember = this.getByMemberCode(member.getMemberCode());
			// 如果该用户账号不为空
			User user = newMember.getUser();
			if (Objects.nonNull(user) && StringUtils.isNotBlank(user.getId())) {
				user = userDao.get(newMember.getUser().getId());
				user.setId(null);
				user.preInsert();
				user.setUserType(clubType.message());
				int row = userDao.insert(user);
				if (row <= 0) {
					throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "会员转" + clubType.code().toUpperCase() + "错误");
				}
				newMember.setUser(user);
				newMember.setUserId(user.getId());
			}
			newMember.setId(IdGen.uuid());
			newMember.setIsNewRecord(Boolean.TRUE);
			newMember.setMemberCode(clubType.code().substring(3).toUpperCase() + SysCodeUtil.getMemberCode());
			newMember.setMemberSite("2".equals(clubType.message()) ? "" : clubType.message());
			newMember.setClubType(clubType.code().toLowerCase());
			try {
				super.save(newMember);
				this.dao.memberRecharge(newMember.getMemberCode(), member.getAccountBalance(), new Date());
			} catch (Exception e) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "会员转" + clubType.code().toUpperCase() + "错误");
			}
			// 如会员其他身份已绑定，则直接绑定会员身份
			if (!CollectionUtils.isEmpty(thirdRefs)) {
				this.createCabSysUserRef(thirdRefs.get(0).getUserId(), newMember);
			}
		} else {
			// 如找到会员相应身份，则更新会员相应信息
			newMember.setFirstPaymentTime(Objects.isNull(newMember.getFirstPaymentTime()) ? member.getFirstPaymentTime()
					: newMember.getFirstPaymentTime());
			newMember.setMemberEndDate(member.getMemberEndDate());
			newMember.setMemberType(member.getMemberType());
			newMember.setMemberCardType(member.getMemberCardType());
			newMember.setAccountBalance(member.getAccountBalance());
			newMember.setUpMemberType("1");
			try {
				super.save(newMember);
				this.dao.memberRecharge(newMember.getMemberCode(), member.getAccountBalance(), new Date());
			} catch (Exception e) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "会员转" + clubType.code().toUpperCase() + "错误");
			}
		}
		// 将原会员身份失效，失效逻辑为将有效期过期处理，余额清零
		this.dao.invalidMemberByMemberCode(member.getMemberCode());
		// 记录会员变动日志
		// 转之前会员
		Member yNewMember = dao.getByMemberCode(member.getMemberCode());
		sysMemberActivityRecordService.saveMemberRecordWoOrder(yOldMember, yNewMember, UserUtils.getUser(), null);
		// 转之后会员
		newMember = dao.getByMemberCode(newMember.getMemberCode());
		sysMemberActivityRecordService.saveMemberRecordWoOrder(null, newMember, UserUtils.getUser(),
				member.getMemberCode());
		// 插入日志
		SysBussinessLogs bussinessLogs = new SysBussinessLogs();
		bussinessLogs.preInsert();
		bussinessLogs.setType("1");
		bussinessLogs.setParamsA(member.getMemberCode());// 修改前会员号
		bussinessLogs.setParamsB(newMember.getMemberCode());// 修改后会员号
		SimpleDateFormat simpleDateate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		String endDate = "";
		if (Objects.nonNull(newMember.getMemberEndDate())) {
			endDate = simpleDateate.format(newMember.getMemberEndDate());
		}
		bussinessLogs.setParamsC(endDate);// 会员截至日期
		if (Objects.nonNull(newMember.getGroomerEndDate())) {
			endDate = simpleDateate.format(newMember.getGroomerEndDate());
		}
		bussinessLogs.setParamsD(endDate);// 美容截至日期
		bussinessLogs.setRemarks(remarklogs);
		try {
			sysBussinessLogsDao.insert(bussinessLogs);
		} catch (Exception e) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "插入日志记录失败");
		}

	}

	public Member getByUserId(String userId) {
		Member member = dao.getByUserId(userId);
		if (member == null) {
			return null;
		}
		return member;
	}

	@Transactional(readOnly = false)
	public void insertMemberAndSyncTask(Member member) {
		dao.insert(member);
		if (!member.getMemberCode().startsWith("DC") && !member.getMemberCode().startsWith("MC")) {
			MemberSyncTask task = new MemberSyncTask();
			// task.setIsNewRecord(true);
			task.setCreateTime(new Date());
			task.setMemberCode(member.getMemberCode());
			task.setMemberName(member.getName());
			task.setMemberType(MemberSyncTask.MEMBER_TYPE_CKU);
			task.setMemberId(member.getId());
			memberSyncTaskService.save(task);
		}

	}

	/**
	 * 查询cku会员
	 *
	 * @param memberCodeMobile
	 * @return
	 */
	public Member getByMobileOrMemberCode(String memberCodeMobile) {
		Member member = dao.getByMemberCode(memberCodeMobile);
		if (member == null) {
			List<Member> memberList = dao.findByMobile(memberCodeMobile);
			if (!Collections3.isEmpty(memberList)) {
				for (Member data : memberList) {
					if (!data.getMemberSite().equals("4") && !data.equals("6")) {
						member = data;
					}
				}
			}
		}
		return member;
	}

	public Member findMemberAndKennelByUserId(String userId) {
		return dao.findMemberAndKennelByUserId(userId);
	}

	/**
	 * @Description： 根据会员号获取会员犬舍信息
	 *
	 * @author: yuanshuai
	 * @date: 2019/12/12 10:47
	 */
	public Member findMemberAndKennelByMemberCode(String userId) {
		return dao.findMemberAndKennelByMemberCode(userId);
	}

	public Member findMemberAndKennelByMemberId(String memberId) {
		return dao.findMemberAndKennelByMemberId(memberId);
	}

	@Transactional(readOnly = false)
	public void preferentialHandlerByPartner(String memberId, String orderCode, String businessCode, String couponDefId,
			User createBy) {
		// 是否为代缴会员
		Member member = this.findMemberAndKennelByMemberId(memberId);
		SysMemberActivityRecord queryRecord = new SysMemberActivityRecord();
		queryRecord.setMemeberCode(member.getMemberCode());
		queryRecord.setOrderCode(orderCode);
		SysMemberActivityRecord record = sysMemberActivityRecordDao.getOneEntity(queryRecord);
		if (record == null) {
			record = new SysMemberActivityRecord();
			record.setId(IdGen.uuid());
			record.setActivityType(businessCode);
			// 不变的部分
			record.setMemeberCode(member.getMemberCode());
			record.setMemeberName(member.getName());
			// 变化部分
			record.setMemberCardType(member.getMemberCardType());
			record.setMemberEndDate(member.getMemberEndDate());
			record.setMemberType(member.getMemberType());
			record.setGroomerEndDate(member.getGroomerEndDate());
			record.setGroomerType(member.getGroomerType());
			if (member.getKennel() != null) {
				record.setKennelCode(member.getKennel().getKennelCode());
				record.setKennelEndDate(member.getKennel().getEndTime());
				record.setKennelName(member.getKennel().getName());
				record.setKennelType(member.getKennel().getType());
			}
			record.setCreateDate(new Date());
			record.setGiveGift("0");
			record.setGiveMonth("0");
			record.setOrderCode(orderCode);
			record.setParticipationTime(new Date());
			record.setRecordType("8");
			record.setMemberCardType(member.getMemberCardType());
			record.setCreateBy(createBy);
			sysMemberActivityRecordDao.insert(record);
		}

		// if (StringUtils.isNotBlank(couponDefId)) {
		// SysCouponDef sysCouponDef = sysCouponDefService.get(couponDefId);
		// if (sysCouponDef != null) {
		// Calendar calendar = Calendar.getInstance();
		// calendar.add(Calendar.MONTH, sysCouponDef.getEffectivePeriod());
		// sysCouponService.saveCoupon(member.getMemberCode(),
		// sysCouponDef.getCouponName(),
		// sysCouponDef.getFacePrice(), calendar.getTime(), new Date(),
		// sysCouponDef.getTarget(), "",
		// sysCouponDef.getExplains(), 1, sysCouponDef.getCouponType());
		// record.setPreferentialWay("2");
		// record.setPreferentialAmount(sysCouponDef.getFacePrice());
		//
		// }
		// }
		record.setNewMemberType(member.getMemberType());
		record.setNewMemberCardType(member.getMemberCardType());
		record.setNewMemberEndDate(member.getMemberEndDate());
		record.setNewGroomerType(member.getGroomerType());
		record.setNewGroomerEndDate(member.getGroomerEndDate());
		record.setNewKennelEndDate(member.getKennel() == null ? null : member.getKennel().getEndTime());
		record.setNewKennelType(member.getKennel() == null ? null : member.getKennel().getType());

		// 2020双十二活动特别活动
		memberActivity20201212Discount.build20201212Discount(record, couponDefId, member);
		sysMemberActivityRecordDao.update(record);
	}

	@Transactional(readOnly = false)
	public void preferentialHandler(String orderCode, String businessCode, String couponDefId, Member oldMember,
			User createBy) {
		// 更新后会员
		Member member = this.findMemberAndKennelByMemberCode(oldMember.getMemberCode());
		SysMemberActivityRecord queryRecord = new SysMemberActivityRecord();
		queryRecord.setMemeberCode(oldMember.getMemberCode());
		queryRecord.setOrderCode(orderCode);
		SysMemberActivityRecord record = sysMemberActivityRecordDao.getOneEntity(queryRecord);
		if (record == null) {
			record = new SysMemberActivityRecord();
			record.setId(IdGen.uuid());
			// 不变的部分
			record.setMemeberCode(oldMember.getMemberCode());
			record.setMemeberName(oldMember.getName());
			// 变化部分
			record.setMemberCardType(oldMember.getMemberCardType());
			record.setGroomerEndDate(oldMember.getGroomerEndDate());
			record.setGroomerType(oldMember.getGroomerType());
			record.setMemberEndDate(oldMember.getMemberEndDate());
			record.setMemberType(oldMember.getMemberType());
			if (member.getKennel() != null) {
				// 不变
				record.setKennelCode(oldMember.getKennel().getKennelCode());
				record.setKennelName(oldMember.getKennel().getName());
				// 变化
				record.setKennelEndDate(oldMember.getKennel().getEndTime());
				record.setKennelType(oldMember.getKennel().getType());
			}
			// 动作记录
			record.setActivityType(StringUtils.isNotBlank(businessCode) && businessCode.endsWith("8088811") ? "8088811"
					: businessCode);
			record.setCreateDate(new Date());
			record.setGiveGift("0");
			record.setGiveMonth("0");
			record.setOrderCode(orderCode);
			record.setParticipationTime(new Date());
			record.setRecordType("9");
			record.setCreateBy(createBy);
			sysMemberActivityRecordDao.insert(record);
		}
		// 变化部分
		record.setNewMemberCardType(member.getMemberCardType());
		record.setNewGroomerType(member.getGroomerType());
		record.setNewGroomerEndDate(member.getGroomerEndDate());
		record.setNewMemberType(member.getMemberType());
		record.setNewMemberEndDate(member.getMemberEndDate());
		record.setNewKennelEndDate(member.getKennel() == null ? null : member.getKennel().getEndTime());
		record.setNewKennelType(member.getKennel() == null ? null : member.getKennel().getType());
		// 2020双十二活动特别活动
		memberActivity20201212Discount.build20201212Discount(record, couponDefId, member);
		sysMemberActivityRecordDao.update(record);
	}

	public RestShareRegister shareRegister(Member member, LoginServer loginServer) {
		RestShareRegister result = new RestShareRegister();
		result.setShareCode(member.getMemberCode());

		String site = "";
		if (!StringUtils.isBlank(loginServer.getMemberSite()) && !loginServer.getMemberSite().equals("0")) {
			loginServer = loginServerService.getLoginServerByMemberSite(loginServer.getMemberSite());
			site = loginServer.getUserShortName().toLowerCase();
		}
		result.setShareUrl(DictUtils.getDict("rq_code_url", "pull_user_active_introduct", new Dict()).getRemarks());
		List<RestShareMember> shareList = new ArrayList<>();
		Member entity = new Member();
		entity.setReferee(member.getMemberCode());
		List<Member> refereeList = this.findList(entity);
		for (Member m : refereeList) {
			RestShareMember vo = new RestShareMember();
			vo.setMemberCode(m.getMemberCode());
			// 第一次缴费时的会员类型
			SysMemberActivityRecord r = sysMemberActivityRecordDao.getFirstOne(m.getMemberCode());
			if (r == null) {
				r = sysMemberActivityRecordDao.getPKOne(m.getMemberCode());
			}
			if (r != null && StringUtils.isNotBlank(r.getActivityType())) {
				String afterMemberType = null;// 续费后会员类型
				if (r.getActivityType().length() == 13) {
					afterMemberType = r.getActivityType().substring(9, 13);// 续费后会员类型 10-13位
				} else if (r.getActivityType().length() == 14) {
					afterMemberType = r.getActivityType().substring(10, 14);// 续费后会员类型 11-14位
				} else if (r.getActivityType().length() == 12) {
					afterMemberType = r.getActivityType().substring(9, 12);// 续费后会员类型 9-12位
				}
				if ("100".equals(afterMemberType))
					vo.setMemberType("爱宠会员普卡");
				else if ("1010".equals(afterMemberType))
					vo.setMemberType("爱宠会员银卡");
				else if ("1020".equals(afterMemberType))
					vo.setMemberType("爱宠会员金卡");
				else if ("2030".equals(afterMemberType))
					vo.setMemberType("繁专会员铂金卡");
				else if ("2040".equals(afterMemberType))
					vo.setMemberType("繁专会员紫金卡");
			}
			vo.setName(m.getName());
			vo.setPaymentDate(m.getFirstPaymentTime());
			vo.setRegisterDate(m.getCreateDate());
			vo.setPaymentStatus(m.getFirstPaymentTime() == null ? "未缴费" : "已缴费");
			shareList.add(vo);
		}
		result.setShareList(shareList);
		String remarks = StringEscapeUtils
				.unescapeHtml4(DictUtils.getDict("html_over", "pull_user_active_introduct", new Dict()).getRemarks());
		result.setActivityRuleHtml(remarks);
		result.setShareTopImage(DictUtils.getDict("image_over", "pull_user_active_introduct", new Dict()).getRemarks());

		return result;

	}

	@Transactional(readOnly = false)
	public RESTResponse shareRegisterReturn(Member member) {
		RESTResponse result = new RESTResponse("data", Boolean.TRUE);
		return result;
	}

	// 是否为单犬种俱乐部会员（机构负责人是单犬种俱乐部会员）
	public Member singleMember(String memberCode, String registrant) {
		return dao.singleMember(memberCode, registrant);
	}

	/**
	 * 获得真实的续费/新增会员的会员号（防止是代缴费）
	 * 
	 * @param orderCode
	 * @return
	 */
	public Member getBeneficiary(String orderCode) {
		String memberCode = null;
		List<PaymentOrderDetail> orderList = paymentOrderDetailDao.findByOrderCode(orderCode);
		if (orderList != null && orderList.size() > 0) {
			memberCode = orderList.get(0).getMemberCode();
		}
		Member member = this.findMemberAndKennelByMemberCode(memberCode);
		List<PaymentOrderDetail> orderListF = orderList.stream().filter(a -> "sys_member".equals(a.getBusinessTable()))
				.collect(Collectors.toList());
		if (orderListF != null && orderListF.size() > 0) {
			if (StringUtils.isNotBlank(orderListF.get(0).getBusinessIds())) {
				member = memberDao.get(orderListF.get(0).getBusinessIds());
			}
		}

		return member;
	}

	@Transactional(readOnly = false)
	public void dogNoseEdit(String memberCode, String dogNoseRepeatedDetection, String dogNoseLivenessDetection,
			HttpServletRequest request) {
		Member member = this.getByMemberCode(memberCode);
		if (member == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "输入的会员信息有误,修改失败");
		}
		dao.updateDogNoseEdit(memberCode, dogNoseRepeatedDetection, dogNoseLivenessDetection);

		/**
		 * 记录鼻纹修改日志
		 */
		try {
			if (!dogNoseLivenessDetection.equals(member.getDogNoseLivenessDetection())
					|| !dogNoseRepeatedDetection.equals(member.getDogNoseRepeatedDetection())) {
				User user = UserUtils.getUser();
				NoseprintSwitchSettingLog nosePringSettingLog = NoseprintSwitchSettingLog.builder()
						.operatorId(user.getId()).operatorName(user.getName()).memberCode(member.getMemberCode())
						.memberName(member.getName()).detectionLivenessOld(member.getDogNoseLivenessDetection())
						.detectionRepeatedOld(member.getDogNoseRepeatedDetection())
						.detectionLivenessNew(dogNoseLivenessDetection).detectionRepeatedNew(dogNoseRepeatedDetection)
						.ipAddr(IPLimitUtil.getIpAddr(request)).build();
				nosePringSettingLog.preInsert();
				nosePringSettingLog.setIsNewRecord(Boolean.TRUE);
				noseprintSwitchSettingLogService.save(nosePringSettingLog);
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	@Transactional(readOnly = false)

	public int restoreMemberDogNoseDetection() {
		return dao.restoreMemberDogNoseDetection();
	}

	public CabSysUserThirdRef findByThirdId(String userId) {
		return cabSysUserThirdRefDao.selectByThirdId(userId);
	}

	public List<CabSysUserThirdRef> findByThirdIds(List<String> userIds) {
		return cabSysUserThirdRefDao.selectByThirdIds(userIds);
	}

	public List<CabSysUserThirdRef> findByCabUserId(String userId) {
		return this.cabSysUserThirdRefDao.selectAllByUserId(userId);
	}

	@Transactional(readOnly = false)
	public ResultDto<String> editBindRelation(Member member) {
		// 查询原会员的所有绑定关系
		Member dbMember = this.get(member.getId());
		CabSysUserThirdRef dbCabSysUserThirdRef = cabSysUserThirdRefDao.selectByThirdId(dbMember.getUserId());
		if (Objects.isNull(dbMember)) {
			throw new ZAException(ZAErrorCode.ZA_ERROR, "会员不存在，请输入正确的会员号！");
		}
		if (dbMember.getMemberCode().startsWith("DQZ") || dbMember.getMemberCode().startsWith("CJH")
				|| dbMember.getMemberCode().startsWith("CAB") || dbMember.getMemberCode().startsWith("HZ")
				|| dbMember.getMemberCode().startsWith("MRHZ")) {
			throw new ZAException(ZAErrorCode.ZA_ERROR, "会员类型错误，请输入正确的会员号！");
		}
		User dbUser = dbMember.getUser();
		CabSysUserThirdRef dbCabUserRef = null;
		if (StringUtils.isNotBlank(dbMember.getUserId())) {
			dbCabUserRef = this.findByThirdId(dbMember.getUserId());
		}
		String newLoginMobile = StringUtils.isBlank(member.getLoginMobile()) ? "" : member.getLoginMobile();
		String newLoginName = StringUtils.isBlank(member.getLoginName()) ? "" : member.getLoginName();
		String dbLoginMobile = Objects.isNull(dbCabUserRef) ? "" : dbCabUserRef.getMobile();
		String dbLoginName = Objects.isNull(dbUser) ? "" : dbUser.getLoginName();
		// 登录手机号和网站账号都发生变化
		if (dbLoginMobile.equals(newLoginMobile) && dbLoginName.equals(newLoginName)) {
			return ResultDto.success("修改绑定关系成功！");
		}

		if (dbMember.getMemberCode().startsWith("DC")) {
			dbMember.setClubType(MemberClubTypeEnum.CKUDC.code());
		} else if (dbMember.getMemberCode().startsWith("MC")) {
			dbMember.setClubType(MemberClubTypeEnum.CKUMC.code());
		} else {
			dbMember.setClubType(MemberClubTypeEnum.CKU.code());
		}

		// 登录手机号不为空，网站账号为空情况
		// 创建同登录手机号相同的网站账号，故将登录手机号赋予网站账号
		if (StringUtils.isNotBlank(newLoginMobile) && StringUtils.isBlank(newLoginName)) {
			newLoginName = newLoginMobile;
		}
		// 解绑会员所有关系
		this.unbundAllRelation(dbMember, dbUser, dbCabUserRef);
		// 从新绑定会员关系
		this.bindRelation(dbMember, newLoginName, newLoginMobile);
		// 清除前端用户登录状态
		if (!Objects.isNull(dbCabSysUserThirdRef)) {
			String redisKey = "token_userid_" + dbCabSysUserThirdRef.getUserId() + "_" + "system" + "_" + dbMember.getMobile();
			JedisUtils.del(redisKey);
		}
		return ResultDto.success("修改绑定关系成功！");
	}

	@Transactional(readOnly = false)
	public ResultDto<String> editBindRelationByCancel(Member member) {
		// 查询原会员的所有绑定关系
		Member dbMember = this.get(member.getId());
		if (Objects.isNull(dbMember)) {
			throw new ZAException(ZAErrorCode.ZA_ERROR, "会员不存在，请输入正确的会员号！");
		}
		if (dbMember.getMemberCode().startsWith("DQZ") || dbMember.getMemberCode().startsWith("CJH")
				|| dbMember.getMemberCode().startsWith("CAB") || dbMember.getMemberCode().startsWith("HZ")
				|| dbMember.getMemberCode().startsWith("MRHZ")) {
			throw new ZAException(ZAErrorCode.ZA_ERROR, "会员类型错误，请输入正确的会员号！");
		}
		User dbUser = dbMember.getUser();
		CabSysUserThirdRef dbCabUserRef = null;
		if (StringUtils.isNotBlank(dbMember.getUserId())) {
			dbCabUserRef = this.findByThirdId(dbMember.getUserId());
		}
		String newLoginMobile = StringUtils.isBlank(member.getLoginMobile()) ? "" : member.getLoginMobile();
		String newLoginName = StringUtils.isBlank(member.getLoginName()) ? "" : member.getLoginName();
		String dbLoginMobile = Objects.isNull(dbCabUserRef) ? "" : dbCabUserRef.getMobile();
		String dbLoginName = Objects.isNull(dbUser) ? "" : dbUser.getLoginName();
		// 登录手机号和网站账号都发生变化
		if (dbLoginMobile.equals(newLoginMobile) && dbLoginName.equals(newLoginName)) {
			return ResultDto.success("修改绑定关系成功！");
		}

		if (dbMember.getMemberCode().startsWith("DC")) {
			dbMember.setClubType(MemberClubTypeEnum.CKUDC.code());
		} else if (dbMember.getMemberCode().startsWith("MC")) {
			dbMember.setClubType(MemberClubTypeEnum.CKUMC.code());
		} else {
			dbMember.setClubType(MemberClubTypeEnum.CKU.code());
		}

		// 登录手机号不为空，网站账号为空情况
		// 创建同登录手机号相同的网站账号，故将登录手机号赋予网站账号
		if (StringUtils.isNotBlank(newLoginMobile) && StringUtils.isBlank(newLoginName)) {
			newLoginName = newLoginMobile;
		}
		// 解绑会员所有关系
		this.unbundAllRelation(dbMember, dbUser, dbCabUserRef);
		// 从新绑定会员关系
		this.bindRelation(dbMember, newLoginName, newLoginMobile);

		memberDao.updateCabUserFlag(member.getSafeMobile());
		memberDao.updateUserFlag(member.getUser().getId());
		// 清除前端用户登录状态
		String redisKey = "token_userid_" + dbCabUserRef.getUserId() + "_" + "system" + "_" + dbCabUserRef.getMobile();
		JedisUtils.del(redisKey);

		return ResultDto.success("修改绑定关系成功！");
	}

	// 绑定会员关系
	private void bindRelation(Member dbMember, String newLoginName, String newLoginMobile) {
		if (StringUtils.isBlank(newLoginName) && StringUtils.isBlank(newLoginName)) {
			return;
		}
		// 根据网站账号，查询User信息
		User newUser = UserUtils.getByLoginNameAndUserType(newLoginName,
				IEnum.getMessage(MemberClubTypeEnum.class, dbMember.getClubType()));
		// 如根据新登录名查询用户为空，则创建登录用户
		if (Objects.isNull(newUser)) {
			// 新创建的网站账号，应满足输入手机号
			if (!Pattern.compile("^1\\d{10}$").matcher(newLoginName).matches()) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "网站账号输入错误，新创建的网站账号必须是手机号码！");
			}
			this.newRegistAndBindMember(newLoginName, dbMember);
		} else {
			this.bindUser(dbMember.getMemberCode(), newLoginName, newLoginMobile);
			dbMember.setUserId(newUser.getId());
		}
		if (StringUtils.isNotBlank(newLoginMobile)) {
			// 根据登录手机号查询CabUser信息
			CabSysUser cabSysUser = this.cabSysUserThirdRefDao.selectByMobile(newLoginMobile);
			if (Objects.isNull(cabSysUser)) {
				// 创建用户及用户关系并绑定
				cabSysUser = this.createCabSysUser(newLoginMobile, dbMember);
				this.createCabSysUserRef(cabSysUser.getId(), dbMember);
			} else {

				List<CabSysUserThirdRef> cabUserRefs = this.cabSysUserThirdRefDao.selectAllByUserId(cabSysUser.getId());
				cabUserRefs = cabUserRefs.stream()
						.filter(user -> MemberClubTypeEnum.CKU.code().equals(user.getThirdType())
								|| MemberClubTypeEnum.CKUDC.code().equals(user.getThirdType())
								|| MemberClubTypeEnum.CKUMC.code().equals(user.getThirdType()))
						.collect(Collectors.toList());
				if (!CollectionUtils.isEmpty(cabUserRefs) && cabUserRefs.stream()
						.filter(ref -> ref.getThirdType().equals(dbMember.getClubType())).count() > 0) {
					throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "当前绑定的手机号与该会员其他身份已绑定的手机号不一致，无法绑定！");
				}
				// 如果绑定的所有身份会员为空
				if (CollectionUtils.isEmpty(cabUserRefs)) {
					this.updateCabSysUser(cabSysUser, dbMember);
				} else {
					// 判断已绑定的会员身份是否与要绑定的会员身份一致
					Member validMember = this.dao.getByUserId(cabUserRefs.get(0).getThirdId());
					if (validMember.getCardNo() != null && !validMember.getCardNo().equals(dbMember.getCardNo())) {
						throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "请检查所绑定的会员身份证号与其他已绑定的是否一致，未实名认证的请先认证身份信息！");
					}
				}
				this.createCabSysUserRef(cabSysUser.getId(), dbMember);
			}
		}
	}

	@Transactional(readOnly = false)
	public User newRegistAndBindMember(String loginName, Member member) {
		String mobile = loginName;
		String userType = IEnum.getMessage(MemberClubTypeEnum.class, member.getClubType());
		if (member.getUser() != null && StringUtils.isNotBlank(member.getUser().getId())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "当前会员存在网站账号ID,请联系技术部处理");
		}
//		if (this.bindMobileCheck(mobile,null,userType).contains("false")) {
//			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "当前手机号与其他用户的绑定手机号重复，无法绑定");
//		}
//		if (this.safeMobileCheck(mobile,member.getId(),userType).contains("false")) {
//			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "当前手机号与其他用户的安全手机号重复，无法绑定");
//		}
		// 登录名查重
		if (userDao.check("login_name", mobile, userType).size() > 0) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该登录名已存在，请换一个登录名");
		}
		// 添加User记录
		User user = new User();
		user.setLoginName(mobile);
		user.setPassword(MD5Generator.generate16(CheckPswUtil.generateRandomString(8)));
		user.setName(StringUtils.isNotBlank(member.getName()) ? member.getName() : mobile);
		user.setMobile(mobile);
		user.setBindMobile(mobile);
		user.setPhone(mobile);
		user.setUserType(userType);
		user.setMailCheck("0");// 0表示未验证邮箱
		user.setLoginFlag("1");
		user.setTicket(UUID.randomUUID().toString());
		user.setBindMobile(mobile);
		user.preInsert();
		int row = userDao.insert(user);
		if (row == 0) {
			throw new ZAException(ZAErrorCode.ZA_ERROR, "创建登录账户失败");
		}
		row = this.updateUserId(user.getId(), member.getMemberCode(), mobile);
		if (row == 0) {
			throw new ZAException(ZAErrorCode.ZA_ERROR, "绑定会员与登录账户失败");
		}
		member.setUserId(user.getId());
		return user;
	}

	/**
	 * @Description： 校验绑定手机号重复验证
	 * 
	 * @author: yuanshuai
	 * @date: 2018/1/4 14:25
	 */
	public String bindMobileCheck(String param, String id, String userType) {
		List<User> userList = userDao.check("bind_mobile", param, userType);
		if (userList.size() > 0) {
			if (id != null) {
				String id2 = userList.get(0).getId();
				if (!id2.equals(id)) {
					return "{\"rc\":false}";
				}
			} else {
				return "{\"rc\":false}";
			}
		}
		return "{\"rc\":true}";
	}

	// 解绑会员的所有关系
	private void unbundAllRelation(Member dbMember, User dbUser, CabSysUserThirdRef dbCabUser) {
		if (Objects.nonNull(dbCabUser)) {
			this.cabSysUserThirdRefDao.deleteByThirdId(dbCabUser.getThirdId());
			this.cabSysUserThirdRefDao.deleteUserById(dbCabUser.getUserId());
		}
		if (Objects.nonNull(dbUser)) {
			Member entity = new Member();
			entity.setId(dbMember.getId());
			entity.setUserId(null);
			this.memberDao.updateBind(entity);
			dbMember.setUser(null);
			dbMember.setUserId(null);
		}
	}

	private CabSysUser createCabSysUser(String loginMobile, Member member) {
		CabSysUser cabSysUser = new CabSysUser();
		cabSysUser.preInsert();
		cabSysUser.setMobile(loginMobile);
		cabSysUser.setPassword(MD5Generator.generate16(CheckPswUtil.generateRandomString(8)));
		cabSysUser.setCardNo(member.getCardNo());
		cabSysUser.setAuthentication(StringUtils.isBlank(member.getCardNo()) ? "0" : "1");
		cabSysUser.setRealName(member.getName());
		cabSysUser.setProvinceName(member.getProvince());
		cabSysUser.setCityName(member.getCity());
		cabSysUser.setAreaName(member.getArea());
		cabSysUser.setAddress(member.getStreet());
		cabSysUser.setRegistIp("0.0.0.0");
		cabSysUser.setDelFlag(BaseEntity.DEL_FLAG_NORMAL);
		int row = cabSysUserThirdRefDao.insertSysUser(cabSysUser);
		if (row == 0) {
			throw new ZAException(ZAErrorCode.ZA_ERROR, "绑定登录手机号失败，请重试！");
		}
		return cabSysUser;
	}

	private CabSysUser updateCabSysUser(CabSysUser cabSysUser, Member member) {
		cabSysUser.preUpdate();
		cabSysUser.setCardNo(member.getCardNo());
		cabSysUser.setAuthentication(StringUtils.isBlank(member.getCardNo()) ? "0" : "1");
		cabSysUser.setRealName(member.getName());
		cabSysUser.setProvinceName(member.getProvince());
		cabSysUser.setCityName(member.getCity());
		cabSysUser.setAreaName(member.getArea());
		cabSysUser.setAddress(member.getStreet());
		cabSysUser.setDelFlag(BaseEntity.DEL_FLAG_NORMAL);
		int row = cabSysUserThirdRefDao.updateSysUser(cabSysUser);
		if (row == 0) {
			throw new ZAException(ZAErrorCode.ZA_ERROR, "绑定登录手机号失败，请重试！");
		}
		return cabSysUser;
	}

	private void createCabSysUserRef(String cabUserId, Member member) {
		CabSysUserThirdRef cabSysUserRef = new CabSysUserThirdRef();
		cabSysUserRef.preInsert();
		cabSysUserRef.setBindTime(new Date());
		cabSysUserRef.setMemberCardType(member.getMemberCardType());
		cabSysUserRef.setMemberEndDate(
				Objects.isNull(member.getMemberEndDate()) ? null : DateUtils.formatDate(member.getMemberEndDate()));
		cabSysUserRef.setUserId(cabUserId);
		cabSysUserRef.setThirdId(member.getUserId());
		cabSysUserRef.setThirdType(member.getClubType());
		cabSysUserRef.setDelFlag(BaseEntity.DEL_FLAG_NORMAL);
		int row = cabSysUserThirdRefDao.insertThirdRef(cabSysUserRef);
		if (row == 0) {
			throw new ZAException(ZAErrorCode.ZA_ERROR, "绑定登录手机号失败，请重试！");
		}
	}

	public String getLoginNameByUserId(String userId) {
		return dao.getLoginNameByUserId(userId);
	}

	public CabSysUser getByLoginMobile(String loginMobile) {
		return this.cabSysUserThirdRefDao.selectByMobile(loginMobile);
	}

	@Transactional(readOnly = false, rollbackFor = Exception.class)
	public int reviseMemberCardType() {
		return dao.reviseMemberCardType();
	}

	/**
	 * 创建未实名认证的临时会员，便于鉴赏课程的报名
	 * 
	 * @param sysMember
	 */
	@Transactional(readOnly = false, rollbackFor = Exception.class)
	public Member saveUnauthorizedMember(Member sysMember) {
		if (!ValidateUtil.Mobile(sysMember.getMobile())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "手机号格式不正确");
		}
		String memberCode = SysCodeUtil.getMemberCode();
		Member member = new Member();
		member.setMemberCode(memberCode);
		member.setName(sysMember.getName());
		member.setNameEn(PinYinUtil.getFullSpell(member.getName()));
		member.setMemberType(MemberType.basic.toString());// 基础会员
		member.setMemberCardType(MemberCardTypeEnum.DEFAULT_CARD.code());// 普卡会员
		member.setGender("male");// 默认初始化为male
		member.setPaymentState("1"); // 未付费
		member.setAccountBalance("0");
		member.setMobile(sysMember.getMobile());
		member.setPhone(sysMember.getMobile());
		member.setSafeMobile(sysMember.getMobile());
		member.setPrintState("0");
		member.setReviewState("0");// 审核状态
		member.setProvince(sysMember.getProvince());
		member.setCity(sysMember.getCity());
		member.setArea(sysMember.getArea());
		member.setStreet(sysMember.getStreet());
		member.setMemberSite("");
		member.preInsert();
		int row = memberDao.insert(member);
		if (row == 0) {
			throw new ZAException(ZAErrorCode.ZA_ERROR, "创建会员失败");
		}
		// 会员提醒
		String date = new SimpleDateFormat("yyyy年MM月dd日HH时mm分").format(member.getCreateDate());
		StringBuilder sb = new StringBuilder();
		sb.append("您于").append(date).append("成功注册为爱宠会员,").append("会员号为").append(memberCode).append(",请您牢记会员号以便后期登录使用！");
		remindService.addRemind(sb.toString(), sysMember.getMemberCode());
		return member;
	}

	/**
	 * 收费项是否为会员犬舍收费项
	 * 
	 * @param shortName
	 * @return
	 */
	public boolean isMemberKennelChargingItem(String shortName) {
		if (StringUtils.isNotBlank(shortName)) {
			if (shortName.startsWith("sys_member@") && !shortName.equals("sys_member@recharge")) {
				return true;
			} else if (shortName.equals("kennel@ZC") || shortName.equals("kennel@YJ")
					|| shortName.equals("kennel@ND")) {
				return true;
			}
		}
		return false;
	}

	/**
	 * 后台会员犬舍收费记录会员变动
	 * 
	 * @param paymentRecord
	 * @param oldMember
	 */
	@Transactional(readOnly = false)
	public void saveMemberRecord(String orderCode, Member oldMember, User createBy) {
		Member newMember = this.findMemberAndKennelByMemberCode(oldMember.getMemberCode());
		SysMemberActivityRecord queryRecord = new SysMemberActivityRecord();
		queryRecord.setMemeberCode(oldMember.getMemberCode());
		queryRecord.setOrderCode(orderCode);
		SysMemberActivityRecord record = sysMemberActivityRecordDao.getOneEntity(queryRecord);
		if (record == null) {
			record = new SysMemberActivityRecord();
			record.setId(IdGen.uuid());
			record.setGroomerEndDate(oldMember.getGroomerEndDate());
			record.setGroomerType(oldMember.getGroomerType());
			record.setMemberEndDate(oldMember.getMemberEndDate());
			record.setMemberType(oldMember.getMemberType());
			record.setMemeberCode(newMember.getMemberCode());
			record.setMemeberName(newMember.getName());
			if (oldMember.getKennel() != null) {
				record.setKennelCode(oldMember.getKennel().getKennelCode());
				record.setKennelEndDate(oldMember.getKennel().getEndTime());
				record.setKennelName(oldMember.getKennel().getName());
				record.setKennelType(oldMember.getKennel().getType());
			}
			record.setCreateDate(new Date());
			record.setGiveGift("0");
			record.setGiveMonth("0");
			record.setOrderCode(orderCode);
			record.setParticipationTime(new Date());
			record.setRecordType("2");
			record.setMemberCardType(oldMember.getMemberCardType());
			record.setCreateBy(createBy);
			sysMemberActivityRecordDao.insert(record);
		}
		record.setNewMemberType(newMember.getMemberType());
		record.setNewMemberEndDate(newMember.getMemberEndDate());
		record.setNewKennelEndDate(newMember.getKennel() == null ? null : newMember.getKennel().getEndTime());
		record.setNewMemberCardType(newMember.getMemberCardType());
		record.setNewKennelType(newMember.getKennel() == null ? null : newMember.getKennel().getType());
		record.setNewGroomerEndDate(newMember.getGroomerEndDate());
		record.setNewGroomerType(newMember.getGroomerType());
		sysMemberActivityRecordDao.update(record);
	}

	/**
	 * 根据订单找到真实的会员，修改第一次缴费时间
	 * 
	 * @param orderCode
	 */
	@Transactional(readOnly = false, rollbackFor = Exception.class)
	public void updateFirstPaymentTime(String orderCode, Member oldMember) {
		if (StringUtils.isBlank(orderCode) || oldMember == null) {
			return;
		}
		// 真实会员
		String memberCode = paymentRecordService.getRealMemberByOrder(orderCode);
		if (StringUtils.isBlank(memberCode)) {
			return;
		}
		// 第一次缴费时间
		Member member = memberDao.getByMemberCode(memberCode);
		if (member != null && member.getFirstPaymentTime() == null) {
			// 确认订单是否使会员截止日期从null变为有值
			if (oldMember.getMemberEndDate() == null && member.getMemberEndDate() != null) {
				member.setFirstPaymentTime(new Date());
				memberDao.update(member);
			}
		}
	}

	public String getMemberCardTypeByMemberCode(String memberCode) {
		Member member = getByMemberCode(memberCode);
		String memberCardType = getMemberCardType(member, member.getKennel());
		if (StringUtils.isNotBlank(memberCardType)) {
			return memberCardType;
		}
		return member.getMemberCardType();
	}

	// 获得卡类型代码
	public String getMemberCardType(Member member, Kennel kennel) {
		StringBuilder result = new StringBuilder();
		result.append(this.findMemberType(member.getMemberType(), member.getMemberEndDate(),
				kennel != null ? kennel.getType() : null, kennel != null ? kennel.getEndTime() : null));
		result.append(this.findCardType(member.getMemberType(), member.getMemberEndDate(),
				kennel != null ? kennel.getType() : null, kennel != null ? kennel.getEndTime() : null));
		return result.toString();
	}

	// 前面两位为会员类型
	private Integer findMemberType(String memberType, Date memberEndDate, String kennelType, Date kennelEndDate) {
		Integer memberTypeR = MemberTypeEnum.BASICS_PET.code();
		// 会员有犬舍 犬舍已缴费 视为专业繁育会员
		if (StringUtils.isNotBlank(memberType) && memberEndDate != null && StringUtils.isNotBlank(kennelType)
				&& kennelEndDate != null) {
			memberTypeR = MemberTypeEnum.PROFESSIONAL_BREED.code();
		}
		return memberTypeR;
	}

	// 后面两位为卡类型
	private Integer findCardType(String memberType, Date memberEndDate, String kennelType, Date kennelEndDate) {
		Integer cardType = CardTypeEnum.DEFAULT_CARD.code();
		// 会员过期时间为空 均视为 普卡会员
		if (memberEndDate == null) {
			cardType = CardTypeEnum.DEFAULT_CARD.code();
		}
		// 银卡用户 对应基础会员
		else if ("basic".equals(memberType)) {
			cardType = CardTypeEnum.SILVER_CARD.code();
		} else if ("professional".equals(memberType)) {
			// 金卡用户 对应 专业会员无犬舍
			if (kennelEndDate == null) {
				cardType = CardTypeEnum.GOLDEN_CARD.code();
			}
			// 紫金卡用户 对应 专业会员有犬舍（永久）
			else if ("permanent".equals(kennelType)) {
				cardType = CardTypeEnum.PURPLE_CARD.code();
			}
			// 铂金卡用户 对应 专业会员有犬舍（年度）
			else {
				cardType = CardTypeEnum.PLATINUM_CARD.code();
			}
		}
		return cardType;
	}

	public Page<ReportMemberVO> findReportMemberPage(Page<ReportMemberVO> page, ReportMemberVO sysMember) {
		sysMember.setPage(page);
		List<ReportMemberVO> list = dao.findReportMemberList(sysMember);
		page.setList(list);
		return page;

	}

	// 注销验证
	public CancelVerifyResp cancelVerify(String flag) {
		Member member = UserUtils.getLoginMember();
		member = this.get(member.getId());

		// 当前关联唯一账户
		Member temp = new Member();
		temp.setUser(new User());
		temp.getUser().setLoginName(member.getUser().getLoginName());
		List<Member> list = this.findList(temp);

		CancelVerifyResp resp = new CancelVerifyResp();
		VerifyInfoResp unique = new VerifyInfoResp();
		if (list.size() > 1) {
			unique.setFlag(Boolean.FALSE);
			unique.setDescribe("当前关联账户不唯一，请联系客服解绑其他会员身份，仅保留唯一会员身份可申请注销");
			resp.setMsg(unique.getDescribe());
		} else {
			unique.setFlag(Boolean.TRUE);
			unique.setDescribe("当前关联唯一账户");
		}
		resp.setUnique(unique);

		VerifyInfoResp balance = new VerifyInfoResp();
		// 账户余额
		BigDecimal b1 = BigDecimal.ZERO;
		if (member != null) {
			b1 = new BigDecimal(member.getAccountBalance());
		}
		if (b1.compareTo(BigDecimal.ZERO) > 0) {
			balance.setFlag(Boolean.FALSE);
			balance.setDescribe("当前账户仍存在余额，请联系客服协商处理方案");
			resp.setMsg(balance.getDescribe());
		} else {
			balance.setFlag(Boolean.TRUE);
			balance.setDescribe("当前账户余额为" + b1.toString());
		}
		resp.setBalance(balance);

		VerifyInfoResp order = new VerifyInfoResp();
		// 订单
		int detailCount = paymentOrderDetailDao.memberCancelOrder(member.getMemberCode());
		int orderCount = paymentOrderDetailDao.memberCancelOrderDetail(member.getMemberCode());
		if (detailCount + orderCount > 0) {
			order.setFlag(Boolean.FALSE);
			order.setDescribe("当前存在未付款订单，删除后可注销｜当前存在未退款订单，删除后可注销");
			resp.setMsg(order.getDescribe());
		} else {
			order.setFlag(Boolean.TRUE);
			order.setDescribe("当前无未支付或未退款订单");
		}
		resp.setOrder(order);

		// 放弃权限 （非货币属性资产 活动参与及资质申请权益）
		if ("1".equals(flag)) {
			VerifyInfoResp info = new VerifyInfoResp();
			info.setFlag(Boolean.TRUE);
			resp.setAssets(info);
			resp.setRights(info);
		} else {
			VerifyInfoResp assets = new VerifyInfoResp();
			assets.setFlag(Boolean.TRUE);
			assets.setDescribe("当前查无犬舍，犬只档案，犬精子登记等信息");
			// 犬舍-犬只-犬精子存档
			int dogCount = dogDao.countByMemberCode(member.getMemberCode());
			Kennel kennel = kennelService.getKennelByMemberCode(member.getMemberCode());
			DogSemen dogSemen = new DogSemen();
			dogSemen.setMemberCode(member.getMemberCode());
			List<DogSemen> dogSemens = dogSemenDao.findList(dogSemen);
			if (dogCount > 0 || kennel != null || !CollectionUtils.isEmpty(dogSemens)) {
				assets.setFlag(Boolean.FALSE);
				assets.setDescribe("当前存在犬舍，犬只档案，犬精子登记数据，是否确认放弃管理权限？");
				resp.setMsg("当前存在犬舍，犬只档案，犬精子登记数据");
			}
			resp.setAssets(assets);

			VerifyInfoResp rights = new VerifyInfoResp();
			rights.setFlag(Boolean.TRUE);

			// 培训 未结束的活动是否有报名信息，是否有申领有效期内待申领证书
			HandlerRegister handlerRegister = new HandlerRegister();
			handlerRegister.setMemberCode(member.getMemberCode());
			handlerRegister.setEndFlag("1");
			List<HandlerRegister> handlerRegisters = handlerRegisterDao.getRegisterList(handlerRegister);

			HandlerQualificationCertificate handlerQualificationCertificate = new HandlerQualificationCertificate();
			handlerQualificationCertificate.setMemberCode(member.getMemberCode());
			handlerQualificationCertificate.setEndFlag("1");
			List<HandlerQualificationCertificate> handlerQualificationCertificateList = handlerQualificationCertificateDao
					.getCertificateList(handlerQualificationCertificate);

			// 美容 未结束的活动是否有报名信息，是否有申领有效期内待申领证书
			GroomerRegister groomerRegister = new GroomerRegister();
			groomerRegister.setMemberCode(member.getMemberCode());
			groomerRegister.setEndFlag("1");
			List<GroomerRegister> registers = groomerRegisterDao.getRegisterList(groomerRegister);
			// 申领有效期内的待申领证书
			GroomerQualificationCertificate qualificationCertificate = new GroomerQualificationCertificate();
			qualificationCertificate.setMemberCode(member.getMemberCode());
			qualificationCertificate.setEndFlag("1");
			List<GroomerQualificationCertificate> certificates = groomerQualificationCertificateDao
					.getCertificateList(qualificationCertificate);

			if (CollectionUtils.isEmpty(registers) && CollectionUtils.isEmpty(certificates)
					&& CollectionUtils.isEmpty(handlerRegisters)
					&& CollectionUtils.isEmpty(handlerQualificationCertificateList)) {
				rights.setDescribe("当前查无活动权益及未申领资质");
			}
			if (!CollectionUtils.isEmpty(registers) || !CollectionUtils.isEmpty(handlerRegisters)) {
				rights.setFlag(Boolean.FALSE);
				rights.setDescribe(StringUtils.isEmpty(rights.getDescribe()) ? "当前存在已报名活动尚未参加，是否放弃权利？"
						: "|" + "当前存在已报名活动尚未参加，是否放弃权利？");
				resp.setMsg("当前存在已报名活动尚未参加");

			}
			if (!CollectionUtils.isEmpty(certificates)
					|| !CollectionUtils.isEmpty(handlerQualificationCertificateList)) {
				rights.setFlag(Boolean.FALSE);
				rights.setDescribe(StringUtils.isEmpty(rights.getDescribe()) ? "当前存在未申领的人才资质，是否放弃权利？"
						: "|" + "当前存在未申领的人才资质，是否放弃权利？");
				resp.setMsg("当前存在未申领的人才资质");

			}

			resp.setRights(rights);
		}
		resp.setSafeMobile(member.getSafeMobile());
		return resp;
	}

	@Transactional(readOnly = false)
	public ResultDto<String> cancel(String flag, String smsCode) {
		Member member = UserUtils.getLoginMember();

		CancelVerifyResp resp = this.cancelVerify(flag);
		if (!(resp.getAssets().isFlag() && resp.getBalance().isFlag() && resp.getOrder().isFlag()
				&& resp.getRights().isFlag() && resp.getUnique().isFlag())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, resp.getMsg());
		}

		member.setLoginMobile("");
		member.setLoginName("");
		return this.editBindRelationByCancel(member);
	}

	public List<ReportMemberVO> findReportMemberListFExport(ReportMemberVO sysMember) {
		return dao.findReportMemberListFExport(sysMember);
	}

	public List<ReportMemberVO> findReportMemberList(ReportMemberVO sysMember) {
		return dao.findReportMemberList(sysMember);
	}

	public List<ReportMemberVO> findExportReportMemberList(ReportMemberVO sysMember) {
		return dao.findExportReportMemberList(sysMember);
	}

	public List<Member> findMemberListByRegistrant(Member member) {
		return dao.findMemberListByRegistrant(member);
	}
}
