package com.cku.oa.sys.service;

import java.util.List;

import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.cku.oa.sys.entity.MemberMobileLog;
import com.cku.oa.sys.dao.MemberMobileLogDao;

/**
 * 会员手机号变更日志Service
 *
 * @author yuanshuai
 * @version 2018-02-11
 */
@Service
@Transactional(readOnly = true)
public class MemberMobileLogService extends CrudService<MemberMobileLogDao, MemberMobileLog> {

    public MemberMobileLog get(String id) {
        return super.get(id);
    }

    public List<MemberMobileLog> findList(MemberMobileLog memberMobileLog) {
        return super.findList(memberMobileLog);
    }

    public Page<MemberMobileLog> findPage(Page<MemberMobileLog> page, MemberMobileLog memberMobileLog) {
        return super.findPage(page, memberMobileLog);
    }

    @Transactional(readOnly = false)
    public void save(MemberMobileLog memberMobileLog) {
        super.save(memberMobileLog);
    }

    @Transactional(readOnly = false)
    public void delete(MemberMobileLog memberMobileLog) {
        super.delete(memberMobileLog);
    }

    @Transactional(readOnly = false)
    public void saveMobileLog(String memberCode, String type, String mobileOld, String mobileNew) {
        MemberMobileLog memberMobileLog = new MemberMobileLog();
        memberMobileLog.setMemberCode(memberCode);
        memberMobileLog.setType(type);
        memberMobileLog.setMobileOld(mobileOld);
        memberMobileLog.setMobileNew(mobileNew);
        super.save(memberMobileLog);
    }

}