/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.sys.badword.entity;

import com.thinkgem.jeesite.common.persistence.DataEntity;
import org.hibernate.validator.constraints.Length;

/**
 * 敏感词Entity
 * @author wangjie
 * @version 2018-03-13
 */
public class DemandSensitiveWord extends DataEntity<DemandSensitiveWord> {

	private static final long serialVersionUID = 1L;
	private String badWord;		// 敏感词

	public DemandSensitiveWord() {
		super();
	}

	public DemandSensitiveWord(String id){
		super(id);
	}

	@Length(min=0, max=100, message="敏感词长度必须介于 0 和 100 之间")
	public String getBadWord() {
		return badWord;
	}

	public void setBadWord(String badWord) {
		this.badWord = badWord;
	}

}