package com.cku.oa.statistics.web;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.cku.oa.statistics.entity.RegionExport;
import com.cku.oa.statistics.service.RegionExportService;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.modules.sys.entity.User;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

@Controller
@RequestMapping(value = "${adminPath}/statistics/region/export")
public class RegionExportController extends BaseController {

	@Autowired
	private RegionExportService regionExportService;

	@ModelAttribute
	public RegionExport get(@RequestParam(required = false) String id) {
		RegionExport entity = null;
		if (StringUtils.isNotBlank(id)) {
			entity = regionExportService.get(id);
		}
		if (entity == null) {
			entity = new RegionExport();
		}
		return entity;
	}

	@RequiresPermissions("statistics:region:export")
	@RequestMapping(value = { "list", "" })
	public String list(RegionExport regionExport, HttpServletRequest request, HttpServletResponse response,
			Model model) {

		Page<RegionExport> page = regionExportService.findPage(new Page<RegionExport>(request, response), regionExport);
		model.addAttribute("page", page);
		return "oa/statistics/region/regionExportList";
	}

	@RequestMapping(value = { "download" })
	@ResponseBody
	public void upload(RegionExport regionExport, HttpServletRequest request, HttpServletResponse response, Model model)
			throws IOException {
		String id = request.getParameter("id");
		regionExport = get(id);

		// 下载本地文件
		String fileName = regionExport.getFileName().toString(); // 文件的默认保存名
		// 读到流中
		InputStream inStream = new FileInputStream(regionExport.getUrl());// 文件的存放路径
		// 设置输出的格式
		response.reset();
		response.setContentType("bin");
		response.addHeader("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
		// 循环取出流中的数据
		byte[] b = new byte[100];
		int len;
		try {
			while ((len = inStream.read(b)) > 0) {
				response.getOutputStream().write(b, 0, len);
			}
			inStream.close();
		} catch (IOException e) {
			e.printStackTrace();
		}

	}

}