package com.cku.oa.statistics.dao;
import java.util.Date;
import java.util.List;
import java.util.Map;

import org.apache.ibatis.annotations.Param;

import com.cku.oa.statistics.entity.MemberInfo;
import com.thinkgem.jeesite.common.persistence.CrudDao;
import com.thinkgem.jeesite.common.persistence.annotation.MyBatisDao;

/**
 * 会员信息统计的数据库查询
 * @author xuzhenxing
 *
 */
@MyBatisDao
public interface MemberInfoDao extends CrudDao<MemberInfo> {
	public double getMoney(String memberCode);
	/**
	 * 查询各个地区的会员总数
	 */
	public List<Map> countByRegion(@Param("province") String province) ;
	/**
	 * 查询各个地区的会员消费统计
	 */
	public List<Map> countByConsumption(@Param("province") String province,@Param("startDate") String startDate,@Param("endDate") String endDate) ;
	
	/**
	 * 查询会员消费统计
	 */
	public List<MemberInfo> countByMember(MemberInfo memberInfo) ;
	/**
	 * 总数
	 * @Author chaixueteng
	 * @2017年1月13日上午11:20:52
	 */
	public int countByMemberCount(@Param("memberCode") String memberCode,@Param("startDate") String startDate,@Param("endDate") String endDate) ;
	/**
	 * 查询会员消费统计(总金额)
	 */
	public Map<String,String> countByMemberOnIn(@Param("memberCode") String memberCode,@Param("startDate") Date startDate,@Param("endDate") Date endDate) ;
	
	
}
