package com.cku.oa.show.web;

import com.cku.core.ResultDto;
import com.cku.core.ZAErrorCode;
import com.cku.oa.show.entity.*;
import com.cku.oa.show.service.ChildShowsService;
import com.cku.oa.show.service.MainShowsService;
import com.cku.oa.show.service.ShowJudgeService;
import com.cku.oa.show.service.ShowReportInfoService;
import com.cku.oa.show.service.ShowReportScoreService;
import com.cku.oa.show.vo.ShowReportInfoRequest;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;
import jodd.util.StringUtil;
import org.apache.ibatis.annotations.Param;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * 犬展播报信息Controller
 * @author lyy
 * @version 2018-01-22
 */
@Controller
@RequestMapping(value = "${adminPath}/show/showReportInfo")
public class ShowReportInfoController extends BaseController {

	@Autowired
	private ShowReportInfoService showReportInfoService;
	@Autowired
	private ChildShowsService childShowsService;
	@Autowired
	private MainShowsService mainShowsService;
	@Autowired
	private ShowReportScoreService showReportScoreService;
	@Autowired
	private ShowJudgeService showJudgeService;

	@ModelAttribute
	public ShowReportInfo get(@RequestParam(required=false) String id) {
		ShowReportInfo entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = showReportInfoService.get(id);
		}
		if (entity == null){
			entity = new ShowReportInfo();
		}
		return entity;
	}
	
	@RequiresPermissions("show:showReportInfo:view")
	@RequestMapping(value = {"list", ""})
	public String list(ShowReportInfo showReportInfo, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<ShowReportInfo> page = showReportInfoService.findPage(new Page<ShowReportInfo>(request, response), showReportInfo); 
		model.addAttribute("page", page);
		return "oa/show/reportinfo/showReportInfoList";
	}

	@RequiresPermissions("show:showReportInfo:view")
	@RequestMapping(value = "form")
	public String form(ShowReportInfo showReportInfo, Model model) {
		//全部主犬展
		List<MainShows> allMain = mainShowsService.findAllMainShows();
		model.addAttribute("allMain",allMain);
		//全部裁判
		List<ShowJudge> showJudgeList = showJudgeService.findAllShowJudge();
		model.addAttribute("showJudgeList", showJudgeList);
		//犬展播报对象
		model.addAttribute("showReportInfo", showReportInfo);
		//子犬展信息
		List<ChildShows> allChild = childShowsService.findChildShowsByMainShowId(showReportInfo.getMainShowId());
		model.addAttribute("allChild", allChild);
		String showName = null;
		if (!StringUtil.isBlank(showReportInfo.getShowCode())) {
			showName = allChild.stream()
					.filter(c -> showReportInfo.getShowCode().equals(c.getShowCode()))
					.map(ChildShows::getShowName)
					.findFirst()
					.orElse(null);
		}
		model.addAttribute("showName", showName);
		//处理裁判
		String[] judgePics = showReportInfo.getJudgePic().split(",");
		if (judgePics.length > 1) {
			if (judgePics.length == 3) {
				showReportInfo.setJudgePic3(judgePics[2]);
			}
			showReportInfo.setJudgePic2(judgePics[1]);
			showReportInfo.setJudgePic(judgePics[0]);
		}
		String[] judgeIds = showReportInfo.getJudgeId().split(",");
		if (judgeIds.length > 1) {
			if (judgeIds.length == 3) {
				showReportInfo.setJudgeId3(judgeIds[2]);
			}
			showReportInfo.setJudgeId2(judgeIds[1]);
			showReportInfo.setJudgeId(judgeIds[0]);
		}
		//处理成绩
		model.addAttribute("bis1Score",showReportScoreService.findScore(showReportInfo.getShowCode(),showReportInfo.getBis1Order()));
		model.addAttribute("bis2Score",showReportScoreService.findScore(showReportInfo.getShowCode(),showReportInfo.getBis2Order()));
		model.addAttribute("bis3Score",showReportScoreService.findScore(showReportInfo.getShowCode(),showReportInfo.getBis3Order()));
		model.addAttribute("bis4Score",showReportScoreService.findScore(showReportInfo.getShowCode(),showReportInfo.getBis4Order()));
		model.addAttribute("jbis1Score",showReportScoreService.findScore(showReportInfo.getShowCode(),showReportInfo.getJbis1Order()));
		model.addAttribute("jbis2Score",showReportScoreService.findScore(showReportInfo.getShowCode(),showReportInfo.getJbis2Order()));
		model.addAttribute("jbis3Score",showReportScoreService.findScore(showReportInfo.getShowCode(),showReportInfo.getJbis3Order()));
		model.addAttribute("jbis4Score",showReportScoreService.findScore(showReportInfo.getShowCode(),showReportInfo.getJbis4Order()));
		model.addAttribute("pbis1Score",showReportScoreService.findScore(showReportInfo.getShowCode(),showReportInfo.getPbis1Order()));
		model.addAttribute("pbis2Score",showReportScoreService.findScore(showReportInfo.getShowCode(),showReportInfo.getPbis2Order()));
		model.addAttribute("pbis3Score",showReportScoreService.findScore(showReportInfo.getShowCode(),showReportInfo.getPbis3Order()));
		model.addAttribute("pbis4Score",showReportScoreService.findScore(showReportInfo.getShowCode(),showReportInfo.getPbis4Order()));
		model.addAttribute("bbis1Score",showReportScoreService.findScore(showReportInfo.getShowCode(),showReportInfo.getBbis1Order()));
		model.addAttribute("bbis2Score",showReportScoreService.findScore(showReportInfo.getShowCode(),showReportInfo.getBbis2Order()));
		model.addAttribute("bbis3Score",showReportScoreService.findScore(showReportInfo.getShowCode(),showReportInfo.getBbis3Order()));
		model.addAttribute("bbis4Score",showReportScoreService.findScore(showReportInfo.getShowCode(),showReportInfo.getBbis4Order()));
		return "oa/show/reportinfo/showReportInfoForm";
	}

	@RequiresPermissions("show:showReportInfo:edit")
	@RequestMapping(value = "editForm")
	public String editForm(ShowReportInfo showReportInfo, Model model) {
		//全部主犬展
		List<MainShows> allMain = mainShowsService.findAllMainShows();
		model.addAttribute("allMain",allMain);
		//全部裁判
		List<ShowJudge> showJudgeList = showJudgeService.findAllShowJudge();
		model.addAttribute("showJudgeList", showJudgeList);
		//犬展播报对象
		model.addAttribute("showReportInfo", showReportInfo);
		if(StringUtils.isNotBlank(showReportInfo.getId())) {
			//子犬展信息
			List<ChildShows> allChild = childShowsService.findChildShowsByMainShowId(showReportInfo.getMainShowId());
			model.addAttribute("allChild", allChild);
			String showName = null;
			if (StringUtil.isBlank(showReportInfo.getShowCode())) {
				showName = allChild.stream()
						.filter(c -> showReportInfo.getShowCode().equals(c.getShowCode()))
						.map(ChildShows::getShowName)
						.findFirst()
						.orElse(null);
			}
			model.addAttribute("showName", showName);
			//处理裁判
			String[] judgePics = showReportInfo.getJudgePic().split(",");
			if (judgePics.length > 1) {
				if (judgePics.length == 3) {
					showReportInfo.setJudgePic3(judgePics[2]);
				}
				showReportInfo.setJudgePic2(judgePics[1]);
				showReportInfo.setJudgePic(judgePics[0]);
			}
			String[] judgeIds = showReportInfo.getJudgeId().split(",");
			if (judgeIds.length > 1) {
				if (judgeIds.length == 3) {
					showReportInfo.setJudgeId3(judgeIds[2]);
				}
				showReportInfo.setJudgeId2(judgeIds[1]);
				showReportInfo.setJudgeId(judgeIds[0]);
			}
			//处理成绩
			model.addAttribute("bis1Score", StringUtils.isBlank(showReportInfo.getBis1Order()) ? null : showReportScoreService.findScore(showReportInfo.getShowCode(), showReportInfo.getBis1Order()));
			model.addAttribute("bis2Score", StringUtils.isBlank(showReportInfo.getBis2Order()) ? null : showReportScoreService.findScore(showReportInfo.getShowCode(), showReportInfo.getBis2Order()));
			model.addAttribute("bis3Score", StringUtils.isBlank(showReportInfo.getBis3Order()) ? null : showReportScoreService.findScore(showReportInfo.getShowCode(), showReportInfo.getBis3Order()));
			model.addAttribute("bis4Score", StringUtils.isBlank(showReportInfo.getBis4Order()) ? null : showReportScoreService.findScore(showReportInfo.getShowCode(), showReportInfo.getBis4Order()));
			model.addAttribute("jbis1Score", StringUtils.isBlank(showReportInfo.getJbis1Order()) ? null : showReportScoreService.findScore(showReportInfo.getShowCode(), showReportInfo.getJbis1Order()));
			model.addAttribute("jbis2Score", StringUtils.isBlank(showReportInfo.getJbis2Order()) ? null : showReportScoreService.findScore(showReportInfo.getShowCode(), showReportInfo.getJbis2Order()));
			model.addAttribute("jbis3Score", StringUtils.isBlank(showReportInfo.getJbis3Order()) ? null : showReportScoreService.findScore(showReportInfo.getShowCode(), showReportInfo.getJbis3Order()));
			model.addAttribute("jbis4Score", StringUtils.isBlank(showReportInfo.getJbis4Order()) ? null : showReportScoreService.findScore(showReportInfo.getShowCode(), showReportInfo.getJbis4Order()));
			model.addAttribute("pbis1Score", StringUtils.isBlank(showReportInfo.getPbis1Order()) ? null : showReportScoreService.findScore(showReportInfo.getShowCode(), showReportInfo.getPbis1Order()));
			model.addAttribute("pbis2Score", StringUtils.isBlank(showReportInfo.getPbis2Order()) ? null : showReportScoreService.findScore(showReportInfo.getShowCode(), showReportInfo.getPbis2Order()));
			model.addAttribute("pbis3Score", StringUtils.isBlank(showReportInfo.getPbis3Order()) ? null : showReportScoreService.findScore(showReportInfo.getShowCode(), showReportInfo.getPbis3Order()));
			model.addAttribute("pbis4Score", StringUtils.isBlank(showReportInfo.getPbis4Order()) ? null : showReportScoreService.findScore(showReportInfo.getShowCode(), showReportInfo.getPbis4Order()));
			model.addAttribute("bbis1Score", StringUtils.isBlank(showReportInfo.getBbis1Order()) ? null : showReportScoreService.findScore(showReportInfo.getShowCode(), showReportInfo.getBbis1Order()));
			model.addAttribute("bbis2Score", StringUtils.isBlank(showReportInfo.getBbis2Order()) ? null : showReportScoreService.findScore(showReportInfo.getShowCode(), showReportInfo.getBbis2Order()));
			model.addAttribute("bbis3Score", StringUtils.isBlank(showReportInfo.getBbis3Order()) ? null : showReportScoreService.findScore(showReportInfo.getShowCode(), showReportInfo.getBbis3Order()));
			model.addAttribute("bbis4Score", StringUtils.isBlank(showReportInfo.getBbis4Order()) ? null : showReportScoreService.findScore(showReportInfo.getShowCode(), showReportInfo.getBbis4Order()));
		}
		return "oa/show/reportinfo/showReportInfoEditForm";
	}

	@RequestMapping(value = "findChildShowsByMainShowId")
	@ResponseBody
	public List findChildShowsByMainShowId(@Param("mainShowId")String mainShowId) {
		List<ChildShows> allChild = childShowsService.findChildShowsByMainShowId(mainShowId);
		for(ChildShows childShows :allChild){
			if(StringUtils.isNotBlank(childShows.getReferee()) && childShows.getReferee().indexOf(",")>0){
				String refereeIds = childShows.getReferee();
				childShows.setReferee(refereeIds.split(",")[0]);
			}
		}
		return allChild;
	}

	@RequestMapping(value = "findJudgeByMainShowId")
	@ResponseBody
	public List<ShowJudge> findJudgeByMainShowId(@Param("mainShowId")String mainShowId) {
		return showReportInfoService.findJudgeByMainShowId(mainShowId);
	}

	@RequestMapping(value = "findJudgeNameById")
	@ResponseBody
	public String findJudgeNameById(@Param("judgeId")String judgeId) {
		if(StringUtils.isBlank(judgeId)) {
			return "";
		}
		ShowJudge showJudge = showReportInfoService.findJudgeNameById(judgeId);
		return showJudge.getJudgeName();
	}

	@RequestMapping(value = "findAllScoreByShowCode")
	@ResponseBody
	public ResultDto<ShowReportInfoRequest> findAllScoreByShowCode(@Param("showCode") String showCode) {
		if (StringUtils.isBlank(showCode)) {
			return ResultDto.error(ZAErrorCode.ZA_ERC_UNKNOWN, "犬展编号为空");
		}
		try {
			return ResultDto.success(showReportInfoService.findAllScoreByShowCode(showCode));
		}catch (Exception e){
			return ResultDto.error(ZAErrorCode.ZA_ERC_UNKNOWN, e.getMessage());
		}
	}


	@RequestMapping(value = "findScore")
	@ResponseBody
	public ShowReportScore findScore(@Param("showCode")String showCode, @Param("order")String order) {
		ShowReportScore showReportScore = showReportScoreService.findScore(showCode,order);
		return showReportScore;
	}

	@RequiresPermissions("show:showReportInfo:edit")
	@RequestMapping(value = "save")
	public String save(ShowReportInfo showReportInfo, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, showReportInfo)){
			return form(showReportInfo, model);
		}
		showReportInfoService.save(showReportInfo);
		addMessage(redirectAttributes, "保存犬展播报信息成功");
		return "redirect:"+Global.getAdminPath()+"/show/showReportInfo/?repage";
	}
	
	@RequiresPermissions("show:showReportInfo:edit")
	@RequestMapping(value = "delete")
	public String delete(ShowReportInfo showReportInfo, RedirectAttributes redirectAttributes) {
		showReportInfoService.delete(showReportInfo);
		addMessage(redirectAttributes, "删除犬展播报信息成功");
		return "redirect:"+Global.getAdminPath()+"/show/showReportInfo/?repage";
	}

}