package com.cku.oa.show.service;

import java.util.List;

import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.cku.oa.show.dao.ShowJudgeDao;
import com.cku.oa.show.entity.ShowJudge;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;

/**
 * 赛事裁判Service
 * @author lgl
 * @version 2016-08-20
 */
@Service
@Transactional(readOnly = true)
public class ShowJudgeService extends CrudService<ShowJudgeDao, ShowJudge> {

	public ShowJudge get(String id) {
		return super.get(id);
	}
	
	public List<ShowJudge> findList(ShowJudge showJudge) {
		return super.findList(showJudge);
	}
	
	public Page<ShowJudge> findPage(Page<ShowJudge> page, ShowJudge showJudge) {
		return super.findPage(page, showJudge);
	}
	
	@Transactional(readOnly = false)
	public void save(ShowJudge showJudge) {
		if (StringUtils.isNotBlank(showJudge.getIntroduce())) {
			showJudge.setIntroduce(StringEscapeUtils.unescapeHtml4(showJudge.getIntroduce()));
		}
		super.save(showJudge);
	}
	
	@Transactional(readOnly = false)
	public void delete(ShowJudge showJudge) {
		super.delete(showJudge);
	}
	
	public List<ShowJudge> findAllShowJudge(){
		return dao.findAllShowJudge();
	}
	
}