/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.show.dao;

import java.util.List;

import org.apache.ibatis.annotations.Param;

import com.cku.oa.show.entity.ShowResultsHk;
import com.thinkgem.jeesite.common.persistence.CrudDao;
import com.thinkgem.jeesite.common.persistence.annotation.MyBatisDao;

/**
 * 香港赛事成绩表DAO接口
 * @author xx
 * @version 2024-11-14
 */
@MyBatisDao
public interface ShowResultsHkDao extends CrudDao<ShowResultsHk> {
	
	/**
	 * @description: 根据赛事编号和血统证书号查询条数
	 */
	int countByShowCodeAndPedigreeCertified(@Param("showCode") String showCode,
			@Param("pedigreeCertified") String pedigreeCertified);
	
	List<ShowResultsHk> findAllYear(@Param("yearLike") String yearLike);
	
	int countShowResultByYear(@Param("year") String year);
	
	List<ShowResultsHk> rankingByYear(@Param("year") String year);
	
	ShowResultsHk getNewOne(@Param("pedigreeCertified") String pedigreeCertified);
	
	String getNewShowCode(@Param("year") String year);
	
}