package com.cku.oa.order.service.impl;

import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.common.SKUIDConstants;
import com.cku.oa.groomer.entity.GroomerQualificationCertificate;
import com.cku.oa.groomer.service.GroomerQualificationCertificateService;
import com.cku.oa.order.service.BaseSkuBusinessService;
import com.cku.oa.order.service.IOrderBusinessService;
import com.cku.oa.order.vo.ChargingItemVo;
import com.cku.oa.order.vo.OrderSkuVo;
import com.cku.oa.order.vo.SingleIdOrderBusinessVo;
import com.cku.oa.order.vo.request.SingleIdRequest;
import com.cku.oa.sys.entity.user.Member;
import com.cku.restful.v2.order.vo.request.OrderApplyRequest;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * 伴侣猫洗护师资格证书处理类
 * @author hjx
 * @date 2025年6月6日
 */
@Service
public class GroomerQCCatNurseOrderServiceImpl extends BaseSkuBusinessService<SingleIdOrderBusinessVo> implements IOrderBusinessService<SingleIdRequest> {

	@Autowired
	private GroomerQualificationCertificateService groomerQualificationCertificateService;

	@Override
	public void businessValidate(OrderApplyRequest orderRequest, SingleIdRequest businessRequest, Member member) {
		if (StringUtils.isBlank(businessRequest.getId())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "参数为空");
		}
		GroomerQualificationCertificate groomerQualificationCertificate = groomerQualificationCertificateService.get(businessRequest.getId());
		if (Objects.isNull(groomerQualificationCertificate)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "查询不到伴侣猫洗护证书信息");
		}
		if (!"1".equals(groomerQualificationCertificate.getPaymentState())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该伴侣猫洗护证书信息已经缴费");
		}
	}

	@Override
	public List<OrderSkuVo> preOrder(OrderApplyRequest orderRequest, SingleIdRequest businessRequest, Member member) {
		GroomerQualificationCertificate groomerQualificationCertificate = groomerQualificationCertificateService.get(businessRequest.getId());
		String skuId;


		if ("PRIMARY LEVEL".equals(groomerQualificationCertificate.getLevelEn())) {
			skuId = SKUIDConstants.GROOMER_QUALIFICATION_CERTIFICATE_CAT_PRIMARY_LEVEL;
		} else if ("PROFESSIONAL LEVEL".equals(groomerQualificationCertificate.getLevelEn())) {
			skuId = SKUIDConstants.GROOMER_QUALIFICATION_CERTIFICATE_CAT_PROFESSIONAL_LEVEL;
		} else if ("MASTER".equals(groomerQualificationCertificate.getLevelEn())) {
			skuId = SKUIDConstants.GROOMER_QUALIFICATION_CERTIFICATE_CAT_MASTER;
		} else {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "级别有误，请联系工作人员");
		}
		//sku列表
		List<OrderSkuVo> skuVoList = Lists.newArrayList();
		//添加证书费SKU
		skuVoList.add(OrderSkuVo.builder()
				.skuId(skuId)
				.num(1)
				.businessList(Stream.of(SingleIdOrderBusinessVo.builder()
								.id(businessRequest.getId())
								.build())
						.collect(Collectors.toList()))
				.build());
		return skuVoList;
	}

	@Override
	public void processBusinessPrePay(OrderApplyRequest orderRequest, SingleIdOrderBusinessVo businessData, OrderSkuVo skuVo) {
		//无需处理
	}

	@Override
	@Transactional(readOnly = false)
	public void findChargingItemBusinessTableId(OrderApplyRequest orderRequest, OrderSkuVo skuVo, List<ChargingItemVo> itemList) {
		//获取业务信息
		SingleIdOrderBusinessVo businessData = (SingleIdOrderBusinessVo) skuVo.getBusinessList().get(0);
		GroomerQualificationCertificate groomerQualificationCertificate = groomerQualificationCertificateService.get(businessData.getId());
		itemList.forEach(item -> item.setBusinessIds(groomerQualificationCertificate.getId()));
	}
}
