/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.order.entity;

import com.thinkgem.jeesite.common.persistence.DataEntity;
import org.hibernate.validator.constraints.Length;

/**
 * 业务订单Entity
 * @author yuanshuai
 * @version 2023-06-20
 */
public class BusinessOrder extends DataEntity<BusinessOrder> {
	
	private static final long serialVersionUID = 1L;
	private String cateId;		// 分类ID
	private String cateName;		// 分类名称
	private String businessId;		// 业务ID
	private String businessName;		// 业务名称
	private String skuId;		// sku_id
	private String skuName;		// sku名称
	private Double unitPrice;		// 单价
	private Integer num;		// 数量
	private Double totalPrice;		// 总价
	private String memberCode;		// 办理人会员号
	private String orderCode;		// 订单号
	private String chargingItemIds;		// 收费项id
	private String chargingItemNames;		// 收费项名称
	
	public BusinessOrder() {
		super();
	}

	public BusinessOrder(String id){
		super(id);
	}

	@Length(min=1, max=32, message="分类ID长度必须介于 1 和 32 之间")
	public String getCateId() {
		return cateId;
	}

	public void setCateId(String cateId) {
		this.cateId = cateId;
	}
	
	@Length(min=1, max=32, message="分类名称长度必须介于 1 和 32 之间")
	public String getCateName() {
		return cateName;
	}

	public void setCateName(String cateName) {
		this.cateName = cateName;
	}
	
	@Length(min=1, max=32, message="业务ID长度必须介于 1 和 32 之间")
	public String getBusinessId() {
		return businessId;
	}

	public void setBusinessId(String businessId) {
		this.businessId = businessId;
	}
	
	@Length(min=1, max=32, message="业务名称长度必须介于 1 和 32 之间")
	public String getBusinessName() {
		return businessName;
	}

	public void setBusinessName(String businessName) {
		this.businessName = businessName;
	}
	
	@Length(min=1, max=32, message="sku_id长度必须介于 1 和 32 之间")
	public String getSkuId() {
		return skuId;
	}

	public void setSkuId(String skuId) {
		this.skuId = skuId;
	}
	
	@Length(min=1, max=32, message="sku名称长度必须介于 1 和 32 之间")
	public String getSkuName() {
		return skuName;
	}

	public void setSkuName(String skuName) {
		this.skuName = skuName;
	}
	
	public Double getUnitPrice() {
		return unitPrice;
	}

	public void setUnitPrice(Double unitPrice) {
		this.unitPrice = unitPrice;
	}
	
	public Integer getNum() {
		return num;
	}

	public void setNum(Integer num) {
		this.num = num;
	}
	
	public Double getTotalPrice() {
		return totalPrice;
	}

	public void setTotalPrice(Double totalPrice) {
		this.totalPrice = totalPrice;
	}
	
	@Length(min=1, max=32, message="办理人会员号长度必须介于 1 和 32 之间")
	public String getMemberCode() {
		return memberCode;
	}

	public void setMemberCode(String memberCode) {
		this.memberCode = memberCode;
	}
	
	@Length(min=1, max=32, message="订单号长度必须介于 1 和 32 之间")
	public String getOrderCode() {
		return orderCode;
	}

	public void setOrderCode(String orderCode) {
		this.orderCode = orderCode;
	}
	
	@Length(min=1, max=500, message="收费项id长度必须介于 1 和 500 之间")
	public String getChargingItemIds() {
		return chargingItemIds;
	}

	public void setChargingItemIds(String chargingItemIds) {
		this.chargingItemIds = chargingItemIds;
	}
	
	@Length(min=1, max=500, message="收费项名称长度必须介于 1 和 500 之间")
	public String getChargingItemNames() {
		return chargingItemNames;
	}

	public void setChargingItemNames(String chargingItemNames) {
		this.chargingItemNames = chargingItemNames;
	}
	
}