/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.handler.web;

import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.cku.oa.constant.Constants;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.cku.oa.groomer.entity.GroomerShowReferee;
import com.cku.oa.groomer.service.GroomerShowRefereeService;
import com.cku.oa.handler.entity.HandlerQualificationCertificate;
import com.cku.oa.handler.service.HandlerQualificationCertificateService;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;

/**
 * 资格证书Controller
 * @author 柴雪腾
 * @version 2016-08-08
 */
@Controller
@RequestMapping(value = "${adminPath}/handler/handlerQualificationCertificate")
public class HandlerQualificationCertificateController extends BaseController {

	@Autowired
	private HandlerQualificationCertificateService handlerQualificationCertificateService;
	@Autowired
	private GroomerShowRefereeService showRefereeService;
	@ModelAttribute
	public HandlerQualificationCertificate get(@RequestParam(required=false) String id) {
		HandlerQualificationCertificate entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = handlerQualificationCertificateService.get(id);
		}
		if (entity == null){
			entity = new HandlerQualificationCertificate();
		}
		return entity;
	}
	
	@RequiresPermissions("handler:handlerQualificationCertificate:view")
	@RequestMapping(value = {"list", ""})
	public String list(HandlerQualificationCertificate handlerQualificationCertificate, HttpServletRequest request, HttpServletResponse response, Model model) {
		//查询牵犬师证书
		handlerQualificationCertificate.setCertificateType(Constants.STRING_ZERO);
		Page<HandlerQualificationCertificate> page = handlerQualificationCertificateService.findPage(new Page<HandlerQualificationCertificate>(request, response), handlerQualificationCertificate);
		model.addAttribute("page", page);
		return "oa/handler/handlerQualificationCertificateList";
	}

	@RequiresPermissions("handler:handlerQualificationCertificate:edit")
	@RequestMapping(value = "form")
	public String form(HandlerQualificationCertificate handlerQualificationCertificate, Model model) {
		model.addAttribute("handlerQualificationCertificate", handlerQualificationCertificate);
		return "oa/handler/handlerQualificationCertificateForm";
	}
	
	@RequiresPermissions("handler:handlerQualificationCertificate:add")
	@RequestMapping(value = "addFrom")
	public String addFrom(HandlerQualificationCertificate handlerQualificationCertificate, Model model) {
		List<GroomerShowReferee> showRefereeList = showRefereeService.findHanlerReferee();
		model.addAttribute("showRefereeList", showRefereeList);
		model.addAttribute("handlerQualificationCertificate", handlerQualificationCertificate);
		return "oa/handler/handlerQualificationCertificateAdd";
	}
	
	
	@RequiresPermissions("handler:handlerQualificationCertificate:add")
	@RequestMapping(value = "add")
	public String add(HandlerQualificationCertificate handlerQualificationCertificate, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, handlerQualificationCertificate)){
			return addFrom(handlerQualificationCertificate, model);
		}
		handlerQualificationCertificateService.save(handlerQualificationCertificate);
		addMessage(redirectAttributes, "保存资格证书成功");
		return "redirect:"+Global.getAdminPath()+"/handler/handlerQualificationCertificate/?repage";
	}
	/**
	 * 查看
	 * @Author chaixueteng
	 * @2016年8月27日下午3:32:13
	 */
	@RequiresPermissions("handler:handlerQualificationCertificate:view")
	@RequestMapping(value = "view")
	public String view(HandlerQualificationCertificate handlerQualificationCertificate, Model model) {
		model.addAttribute("handlerQualificationCertificate", handlerQualificationCertificate);
		return "oa/handler/handlerQualificationCertificateView";
	}

	@RequiresPermissions("handler:handlerQualificationCertificate:edit")
	@RequestMapping(value = "save")
	public String save(HandlerQualificationCertificate handlerQualificationCertificate, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, handlerQualificationCertificate)){
			return form(handlerQualificationCertificate, model);
		}
		handlerQualificationCertificateService.save(handlerQualificationCertificate);
		addMessage(redirectAttributes, "保存资格证书成功");
		return "redirect:"+Global.getAdminPath()+"/handler/handlerQualificationCertificate/?repage";
	}
	
	@RequiresPermissions("handler:handlerQualificationCertificate:edit")
	@RequestMapping(value = "delete")
	public String delete(HandlerQualificationCertificate handlerQualificationCertificate, RedirectAttributes redirectAttributes) {
		handlerQualificationCertificateService.delete(handlerQualificationCertificate);
		addMessage(redirectAttributes, "删除资格证书成功");
		return "redirect:"+Global.getAdminPath()+"/handler/handlerQualificationCertificate/?repage";
	}
	
	/**
	 * 批量提醒
	 * @Author chaixueteng
	 * @2016年8月2日上午10:54:23
	 */
	@RequiresPermissions("handler:handlerQualificationCertificate:edit")
	@RequestMapping(value = "reminder")
	public String reminder(HttpServletRequest request, HttpServletResponse response,RedirectAttributes redirectAttributes) {
		String ids = request.getParameter("ids");
		handlerQualificationCertificateService.reminder(ids);
		addMessage(redirectAttributes, "提醒成功");
		return "redirect:"+Global.getAdminPath()+"/handler/handlerQualificationCertificate/?repage";
	}
	
	/**
	 * 批量提醒
	 * @Author chaixueteng
	 * @2016年8月2日上午10:54:23
	 */
	@RequiresPermissions("handler:handlerQualificationCertificate:edit")
	@RequestMapping(value = "reminderOne")
	public String reminderOne(String id,HttpServletRequest request, HttpServletResponse response,RedirectAttributes redirectAttributes) {
		handlerQualificationCertificateService.reminder(id);
		addMessage(redirectAttributes, "提醒成功");
		return "redirect:"+Global.getAdminPath()+"/handler/handlerQualificationCertificate/?repage";
	}
	
	/**
	 * 生成资格证书号
	 * @Author chaixueteng
	 * @2016年8月3日下午1:39:10
	 */
	@RequiresPermissions("handler:handlerQualificationCertificate:create")
	@RequestMapping("createCode")
	public String createCode(String id, RedirectAttributes redirectAttributes){
		HandlerQualificationCertificate hqc = handlerQualificationCertificateService.get(id);
		handlerQualificationCertificateService.createCode(id);
		if ("1".equals(hqc.getCertificateType())) {
			return "redirect:"+Global.getAdminPath()+"/handler/handlerQualificationCertificate/trainer/list/?repage";
		}
		return "redirect:"+Global.getAdminPath()+"/handler/handlerQualificationCertificate/?repage";
	}
	
	/**
	 * 资格证书导出(全部)
	 * @Author chaixueteng
	 * @2016年8月3日下午4:48:21
	 */
	@RequiresPermissions("handler:handlerQualificationCertificate:export")
    @RequestMapping(value = "export")
    public String export(HandlerQualificationCertificate handlerQualificationCertificate,HttpServletResponse response, RedirectAttributes redirectAttributes) {
		try {
			//牵犬师
			handlerQualificationCertificate.setCertificateType("0");
			handlerQualificationCertificateService.export(handlerQualificationCertificate,response);
		} catch (Exception e) {
			addMessage(redirectAttributes, "导出资格证书失败！失败信息："+e.getMessage());
		}
		return null;
    }
	
	
	/**
	 * 资格证书打印
	 * @Author chaixueteng
	 * @2016年8月22日下午5:47:16
	 */
	@RequiresPermissions("handler:handlerQualificationCertificate:print")
	@RequestMapping(value = "print")
	public String print(String id,Model model){ 
		HandlerQualificationCertificate handlerQualificationCertificate=handlerQualificationCertificateService.print(id);
        model.addAttribute("handlerQualificationCertificate", handlerQualificationCertificate);
        return "oa/handler/handlerQualificationCertificatePrint";
    }
	
	/**
	 * 重置打印
	 * @Author chaixueteng
	 * @2016年8月22日下午5:47:58
	 */
	@RequiresPermissions("handler:handlerQualificationCertificate:resetPrint")
	@RequestMapping(value = "resetPrint")
	public String resetPrint(String id, RedirectAttributes redirectAttributes){
		HandlerQualificationCertificate handlerQualificationCertificate = handlerQualificationCertificateService.get(id);
		handlerQualificationCertificateService.resetPrint(id);
		if ("1".equals(handlerQualificationCertificate.getCertificateType())) {
			return "redirect:" + Global.getAdminPath() + "/handler/handlerQualificationCertificate/trainer/list/?repage";
		}
		return "redirect:"+Global.getAdminPath()+"/handler/handlerQualificationCertificate/?repage";
	}

	@RequiresPermissions("handler:handlerQualificationCertificate:view")
	@RequestMapping(value = "/trainer/list")
	public String trainerList(HandlerQualificationCertificate handlerQualificationCertificate, HttpServletRequest request, HttpServletResponse response, Model model) {
		//查询训练师证书
		handlerQualificationCertificate.setCertificateType(Constants.STRING_NUM_ONE);
		Page<HandlerQualificationCertificate> page = handlerQualificationCertificateService.findPage(new Page<HandlerQualificationCertificate>(request, response), handlerQualificationCertificate);
		model.addAttribute("page", page);
		return "oa/handler/handlerQualificationCertificateTrainerList";
	}

	/**
	 * 训练师伴侣犬资格证书打印
	 * @Author chaixueteng
	 * @2016年8月22日下午5:47:16
	 */
	@RequiresPermissions("handler:handlerQualificationCertificate:print")
	@RequestMapping(value = "/trainer/partnerPrint")
	public String trainerPartnerPrint(String id,Model model){
		HandlerQualificationCertificate handlerQualificationCertificate=handlerQualificationCertificateService.trainerPartnerPrint(id);
		model.addAttribute("handlerQualificationCertificate", handlerQualificationCertificate);
		return "oa/handler/handlerQualificationCertificatePartnerPrint";
	}

	@RequiresPermissions("handler:handlerQualificationCertificate:export")
	@RequestMapping(value = "/export/trainer")
	public String exportTrainer(HandlerQualificationCertificate handlerQualificationCertificate,HttpServletResponse response, RedirectAttributes redirectAttributes) {
		try {
			//训练师
			handlerQualificationCertificate.setCertificateType("1");
			handlerQualificationCertificateService.export(handlerQualificationCertificate,response);
		} catch (Exception e) {
			addMessage(redirectAttributes, "导出训练师资格证书失败！失败信息："+e.getMessage());
		}
		return null;
	}
	@RequiresPermissions("handler:handlerQualificationCertificate:edit")
	@RequestMapping(value = "/trainer/form")
	public String trainerForm(HandlerQualificationCertificate handlerQualificationCertificate, Model model) {
		model.addAttribute("handlerQualificationCertificate", handlerQualificationCertificate);
		return "oa/handler/handlerQualificationCertificateTrainerForm";
	}

	@RequiresPermissions("handler:handlerQualificationCertificate:edit")
	@RequestMapping(value = "/trainer/save")
	public String trainerSave(HandlerQualificationCertificate handlerQualificationCertificate, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, handlerQualificationCertificate)){
			return form(handlerQualificationCertificate, model);
		}
		handlerQualificationCertificateService.save(handlerQualificationCertificate);
		addMessage(redirectAttributes, "保存训练师资格证书成功");
		return "redirect:"+Global.getAdminPath()+"/handler/handlerQualificationCertificate/trainer/list?repage";
	}
	
}