/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.groomer.dao;

import com.cku.oa.groomer.entity.GroomerQualificationCertificate;
import com.cku.oa.groomer.entity.GroomerRegister;
import com.cku.oa.groomer.vo.FciGroomerQualificationCertificateVO;
import com.thinkgem.jeesite.common.persistence.CrudDao;
import com.thinkgem.jeesite.common.persistence.annotation.MyBatisDao;
import com.cku.oa.groomer.entity.FciGroomerQualificationCertificate;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * fci资格证书DAO接口
 * @author hjx
 * @version 2024-01-17
 */
@MyBatisDao
public interface FciGroomerQualificationCertificateDao extends CrudDao<FciGroomerQualificationCertificate> {

    List<FciGroomerQualificationCertificate> queryFciGroomerQualificationCertificateList(@Param("certificateIds") List<String> certificateIds);

    void resetFciPrint(FciGroomerQualificationCertificate fciGroomerQualificationCertificate);

    GroomerRegister print(String id);

    void updateFciCertificateState(String id);

    FciGroomerQualificationCertificate getByCertificateId(String certificateId);

    List<FciGroomerQualificationCertificate> eqCertificatepay(@Param("memberCode")String memberCode,@Param("levelEn")String levelEn);

    List<FciGroomerQualificationCertificate> eqCertificate(@Param("memberCode")String memberCode,@Param("levelEn")String levelEn);
    List<FciGroomerQualificationCertificate> getLevel(@Param("memberCode")String memberCode);

    void deleteFciCertificate(FciGroomerQualificationCertificate fciGroomerQualificationCertificate);

    FciGroomerQualificationCertificate printFciShowQGC(String id);

    List<FciGroomerQualificationCertificateVO> exportFciGroomerQualificationCertificates(FciGroomerQualificationCertificate fciGroomerQualificationCertificate);

    List<FciGroomerQualificationCertificate> findListByCertificate(FciGroomerQualificationCertificate fciGroomerQualificationCertificate);

}