package com.cku.oa.gcWeb.entity;

import com.drew.lang.annotations.NotNull;
import com.thinkgem.jeesite.common.persistence.DataEntity;
import org.hibernate.validator.constraints.Length;

/**
 * 美容官网考试大赛Entity
 *
 * @author yuanshuai
 * @version 2023-01-29
 */
public class GCWebContest extends DataEntity<GCWebContest> {

	private static final long serialVersionUID = 1L;
	private Integer type;        // 类型(1:规则,2:活动预告,3:活动回顾)
	private String title;        // 标题
	private String image;        // 图片
	private String thumb;        // 缩略图
	private String content;        // 内容
	private Integer showFlag;        // 显示标记（0不显示1显示）
	private Integer sort;        // 排序

	public GCWebContest() {
		super();
	}

	public GCWebContest(String id) {
		super(id);
	}

	@NotNull
	public Integer getType() {
		return type;
	}

	public void setType(Integer type) {
		this.type = type;
	}

	@Length(min = 1, max = 64, message = "标题长度必须介于 1 和 64 之间")
	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	@Length(min = 0, max = 255, message = "图片长度必须介于 0 和 255 之间")
	public String getImage() {
		return image;
	}

	public void setImage(String image) {
		this.image = image;
	}

	@Length(min = 0, max = 255, message = "缩略图长度必须介于 0 和 255 之间")
	public String getThumb() {
		return thumb;
	}

	public void setThumb(String thumb) {
		this.thumb = thumb;
	}

	public String getContent() {
		return content;
	}

	public void setContent(String content) {
		this.content = content;
	}

	@NotNull
	public Integer getShowFlag() {
		return showFlag;
	}

	public void setShowFlag(Integer showFlag) {
		this.showFlag = showFlag;
	}

	public Integer getSort() {
		return sort;
	}

	public void setSort(Integer sort) {
		this.sort = sort;
	}

}