/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.finance.web;

import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.cku.oa.finance.entity.PaymentChargingItem;
import com.cku.oa.finance.entity.PaymentOrderProject;
import com.cku.oa.finance.entity.PaymentProjectCart;
import com.cku.oa.finance.entity.SaFinanceSubjectMapping;
import com.cku.oa.finance.service.PaymentChargingItemGroupService;
import com.cku.oa.finance.service.PaymentChargingItemService;
import com.cku.oa.finance.service.PaymentOrderProjectService;
import com.cku.oa.finance.service.PaymentProjectCartService;
import com.cku.oa.finance.service.SaFinanceSubjectMappingService;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.service.user.MemberService;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;

/**
 * 项目临时购物车Controller
 * @author lyy
 * @version 2016-08-08
 */
@Controller
@RequestMapping(value = "${adminPath}/finance/paymentProjectCart")
public class PaymentProjectCartController extends BaseController {

	@Autowired
	private PaymentProjectCartService paymentProjectCartService;
	@Autowired
	private PaymentOrderProjectService paymentOrderProjectService;
	@Autowired
	private PaymentChargingItemService paymentChargingItemService;
	@Autowired
	private MemberService memberService;
	@Autowired
	private PaymentChargingItemGroupService paymentChargingItemGroupService;

	@Autowired
	private SaFinanceSubjectMappingService saFinanceSubjectMappingService;
	@ModelAttribute
	public PaymentProjectCart get(@RequestParam(required=false) String id) {
		PaymentProjectCart entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = paymentProjectCartService.get(id);
		}
		if (entity == null){
			entity = new PaymentProjectCart();
		}
		return entity;
	}
	
	@RequiresPermissions("finance:paymentProjectCart:view")
	@RequestMapping(value = {"list", ""})
	public String list(PaymentProjectCart paymentProjectCart, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<PaymentProjectCart> page = paymentProjectCartService.findPage(new Page<PaymentProjectCart>(request, response), paymentProjectCart);
		model.addAttribute("page", page);
		return "oa/finance/paymentProjectCartList";
	}

	@RequiresPermissions("finance:paymentProjectCart:view")
	@RequestMapping(value = "form")
	public String form(PaymentProjectCart paymentProjectCart, Model model) {
		PaymentOrderProject paymentOrderProject = new PaymentOrderProject();
		paymentOrderProject.setId(paymentProjectCart.getProjectId());
		paymentOrderProject.setIsValid("1");
		List<PaymentOrderProject> list = paymentOrderProjectService.findListById(paymentOrderProject);
		model.addAttribute("projectIsValidList", list);
//		List<PaymentChargingItem> chargingItems1 = paymentChargingItemService.findTypeList("1");
//		List<PaymentChargingItem> chargingItems2 = paymentChargingItemService.findTypeList("2");
//		chargingItems1.addAll(chargingItems2);
//		model.addAttribute("chargingItems", chargingItems1);
		List<PaymentChargingItem> chargingItems = paymentChargingItemService.findTypeList(null);
		//组合收费项添加
		chargingItems.addAll(paymentChargingItemGroupService.getPaymentChargingItemGroupList());
		model.addAttribute("chargingItems", chargingItems);
		List<PaymentProjectCart> voucherList = paymentProjectCartService.findListByVoucherCode(paymentProjectCart);
		model.addAttribute("voucherList", voucherList);
		if(voucherList!=null && voucherList.size()>0){
			if(paymentProjectCart.getMemberCode()==null || "".equals(paymentProjectCart.getMemberCode())){
				paymentProjectCart.setMemberCode(voucherList.get(0).getMemberCode());
			}
		}
		if(paymentProjectCart.getMemberCode()!=null && !"".equals(paymentProjectCart.getMemberCode())){
			Member member = memberService.getByMemberCode(paymentProjectCart.getMemberCode());
			paymentProjectCart.setMemberName(member.getName());
		}
		model.addAttribute("paymentProjectCart", paymentProjectCart);
		List<SaFinanceSubjectMapping> bizList = saFinanceSubjectMappingService.findAllBusinessList();
		model.addAttribute("bizList", bizList);
		return "oa/finance/paymentProjectCartForm";
	}

	@RequiresPermissions("finance:paymentProjectCart:add")
	@RequestMapping(value = "save")
	@ResponseBody
	public String save(PaymentProjectCart paymentProjectCart, Model model, RedirectAttributes redirectAttributes) {
		try {
			if (!beanValidator(model, paymentProjectCart)){
				return form(paymentProjectCart, model);
			}
			paymentProjectCartService.save(paymentProjectCart);
		}catch (Exception e) {
			return "{\"rc\":1,\"msg\":\""+e.getMessage()+"\"}";
		}
		
		//addMessage(redirectAttributes, "保存项目临时购物车成功");
        //return "redirect:"+Global.getAdminPath()+"/finance/paymentProjectCart/form?projectId="+paymentProjectCart.getProjectId()+"&voucherCode="+paymentProjectCart.getVoucherCode()+"&memberCode="+paymentProjectCart.getMemberCode()+"&amount="+paymentProjectCart.getAmount();
		return "{\"rc\":0}";
	}
	@RequiresPermissions("finance:paymentProjectCart:add")
	@RequestMapping(value = "add")
	@ResponseBody
	public String add(String id, Model model, RedirectAttributes redirectAttributes) {
		paymentProjectCartService.add(id);
		return "ok";
	}
	@RequiresPermissions("finance:paymentProjectCart:add")
	@RequestMapping(value = "del")
	@ResponseBody
	public String del(String id, Model model, RedirectAttributes redirectAttributes) {
		paymentProjectCartService.del(id);
		return "ok";
	}
	@RequiresPermissions("finance:paymentProjectCart:delete")
	@RequestMapping(value = "delete")
	public String delete(PaymentProjectCart paymentProjectCart, RedirectAttributes redirectAttributes) {
		paymentProjectCartService.deletePaymentProjectCart(paymentProjectCart);
		//addMessage(redirectAttributes, "删除项目临时购物车成功");
		return "redirect:"+Global.getAdminPath()+"/finance/paymentProjectCart/form?projectId="+paymentProjectCart.getProjectId()+"&voucherCode="+paymentProjectCart.getVoucherCode();
	}
	@RequiresPermissions("finance:paymentProjectCart:add")
	@RequestMapping(value = "changePrice")
	@ResponseBody
	public String changePrice(String id, String price) {
		paymentProjectCartService.changePrice(id,price);
		return "ok";
	}

}