package com.cku.oa.finance.web;

import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.collections.CollectionUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.cku.annotation.MultiSubmit;
import com.cku.core.ResultDto;
import com.cku.core.ZAErrorCode;

/**
 * Created with IntelliJ IDEA.
 * User: lyy
 * Date: 2016/7/26
 * Time: 16:31
 */

import com.cku.core.ZAException;
import com.cku.oa.finance.entity.PaymentChargingItem;
import com.cku.oa.finance.entity.PaymentOrder;
import com.cku.oa.finance.entity.PaymentOrderDetail;
import com.cku.oa.finance.entity.PaymentRecord;
import com.cku.oa.finance.entity.SaFinanceSubjectMapping;
import com.cku.oa.finance.service.DeductCostService;
import com.cku.oa.finance.service.PaymentChargingItemService;
import com.cku.oa.finance.service.PaymentOrderService;
import com.cku.oa.finance.service.SaFinanceSubjectMappingService;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.service.user.MemberService;
import com.cku.restful.v1.finance.service.RestOrderService;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;

/**
 * 补扣费用公用类
 */
@Controller
@RequestMapping(value = "${adminPath}/finance/deductCost")
public class DeductCostController extends BaseController {
	@Autowired
	private DeductCostService deductCostService;
	@Autowired
	private PaymentChargingItemService paymentChargingItemService;
	@Autowired
	private MemberService memberService;
	@Autowired
	private PaymentOrderService paymentOrderService;
	@Autowired
	private RestOrderService restOrderService;
	@Autowired
	private SaFinanceSubjectMappingService saFinanceSubjectMappingService;

	private static final String LOVE_CUTE_DOG_OFFICE_NO = "100000022";

	/**
	 * 扣费方法
	 *
	 * @param paymentRecord
	 * @param redirectAttributes
	 * @return
	 */
	@RequiresPermissions("finance:deductCost:deductCost")
	@RequestMapping(value = "deductCost")
	@ResponseBody
	@MultiSubmit
	public ResultDto<String> deductCost(PaymentRecord paymentRecord, HttpServletRequest request, RedirectAttributes redirectAttributes) {
		ResultDto<String> result = ResultDto.success("会员扣费成功",paymentRecord.getMemberCode()); 
		try {
			deductCostService.deductCost(paymentRecord);
		}catch (Exception e) {
			e.printStackTrace();
			result = ResultDto.error(ZAErrorCode.ZA_ERROR,"扣费失败：" + e.getMessage());
		}
		return result;
	}

	/**
	 * 跳转扣费页面
	 *
	 * @param code  部门编号  财务部门code 没有值
	 * @param model
	 * @return
	 */
	@RequiresPermissions("finance:deductCost:deductCost")
	@RequestMapping(value = "toDeductCostPage")
	public String toDeductCostPage(String code, Model model) {

		List<PaymentChargingItem> list = paymentChargingItemService.findListByDeptCode(code);
		if (StringUtils.isNotBlank(code)) {
			List<SaFinanceSubjectMapping> bizList = saFinanceSubjectMappingService.findListBySysOfficeCode(code);
			//美容部门code
			if ("100000004".equals(code)) {
				//美容部门也要查询爱萌犬的收费项
				List<PaymentChargingItem> listNew= paymentChargingItemService.findListByDeptCode(LOVE_CUTE_DOG_OFFICE_NO);
				if (CollectionUtils.isNotEmpty(listNew)) {
					list.addAll(listNew);
				}
				List<SaFinanceSubjectMapping> bizListNew = saFinanceSubjectMappingService.findListBySysOfficeCode(LOVE_CUTE_DOG_OFFICE_NO);
				if (CollectionUtils.isNotEmpty(bizListNew)) {
					bizList.addAll(bizListNew);
				}
			}
			model.addAttribute("chargingItemList", list);
			model.addAttribute("code", code);
			model.addAttribute("bizList", bizList);
			return "oa/finance/deductCostOfCommon";
		} else {
			List<SaFinanceSubjectMapping> bizList = saFinanceSubjectMappingService.findAllBusinessList();
			model.addAttribute("chargingItemList", list);
			model.addAttribute("code", code);
			model.addAttribute("bizList", bizList);
			return "oa/finance/deductCostOfFinance";
		}

	}

	/**
	 * 跳转到会员扣费页面
	 *
	 * @param model
	 * @return
	 */
	//@RequiresPermissions("finance:deductCost:payment")
	@RequestMapping(value = "toMemberPay")
	public String toMemberPay(String memberCode, String type, Integer num, String price, String id, Model model) {
		model.addAttribute("payType", paymentChargingItemService.getByShortName(type));
		model.addAttribute("memberForm", memberService.getByMemberCode(memberCode));
		model.addAttribute("num", num);
		if (price != null && !"".equals(price)) {
			model.addAttribute("price", price);
		} else {
			model.addAttribute("price", null);
		}
		model.addAttribute("id", id);
		return "oa/finance/memberPay";
	}


	/**
	 *
	 * @param model
	 * @return
	 */
	/**
	 * 后台的合并扣款功能(同一个业务，合并付款)
	 * 比如基础会员升级为专业会员，
	 * 需要同时缴纳升级费用80+专业会员的一年费用360
	 * 注意 ：  目前的代码只能支撑俩项同时付款
	 *
	 * @param memberCode 缴费用户的会员号
	 * @param types      缴费项目的集合
	 * @param prices     付款的价格
	 * @param businessId 业务id
	 * @param model
	 * @return
	 */
	@RequestMapping(value = "toMergeMemberPay")
	public String toMergeMemberPay(String memberCode, String[] types, String[] prices, String businessId, Model model) {

		List<PaymentChargingItem> paymentChargingItems = new ArrayList<PaymentChargingItem>();
		for (String type : types) {
			PaymentChargingItem paymentChargingItem = paymentChargingItemService.getByShortName(type);
			paymentChargingItems.add(paymentChargingItem);
		}

		List<Integer> numbers = new ArrayList<Integer>();
		for (Integer number : numbers) {
			numbers.add(number);
		}

		model.addAttribute("payTypes", paymentChargingItems);
		model.addAttribute("memberForm", memberService.getByMemberCode(memberCode));

		model.addAttribute("id", businessId);
		return "oa/finance/mergeMemberPay";
	}

	/**
	 * 公用支付方法
	 *
	 * @param paymentRecord
	 * @param model
	 * @return
	 */
	@RequiresPermissions("finance:deductCost:payment")
	@RequestMapping(value = "paySave")
	@ResponseBody
	public String paySave(PaymentRecord paymentRecord, Model model) {
		if (!beanValidator(model, paymentRecord)) {
			return "{\"rc\":-1,\"msg\":\"error\"}";
		}
		try {
			deductCostService.paySave(paymentRecord);
		} catch (ZAException e) {
			return "{\"rc\":" + e.get_code() + ",\"msg\":\"" + e.getMessage() + "\"}";
		}
		return "{\"rc\":0,\"msg\":\"success\"}";
	}

	/**
	 * 公用支付方法
	 * 目前只支持俩项费用合并付款
	 *
	 * @param paymentRecord
	 * @param model
	 * @return
	 */
	@RequiresPermissions("finance:deductCost:payment")
	@RequestMapping(value = "mergePaySave")
	@ResponseBody
	public String mergePaySave(PaymentRecord paymentRecord, HttpServletRequest request, Model model) {
		PaymentRecord r1 = new PaymentRecord();
		PaymentRecord r2 = new PaymentRecord();

		r1.setBusinessId(paymentRecord.getBusinessId());
		r1.setChargingItemId(request.getParameter("chargingItemId1"));
		r1.setChargingItemNum(1);
		r1.setMemberCode(paymentRecord.getMemberCode());
		r1.setPrice(request.getParameter("price1"));
		r1.setPaymentRemarks(request.getParameter("paymentRemarks1"));
		r1.setPaymentAmount(request.getParameter("paymentAmount1"));

		r2.setBusinessId(paymentRecord.getBusinessId());
		r2.setChargingItemId(request.getParameter("chargingItemId2"));
		r2.setChargingItemNum(1);
		r2.setMemberCode(paymentRecord.getMemberCode());
		r2.setPrice(request.getParameter("price2"));
		r2.setPaymentRemarks(request.getParameter("paymentRemarks2"));
		r2.setPaymentAmount(request.getParameter("paymentAmount2"));

		List<PaymentRecord> records = new ArrayList<PaymentRecord>();
		records.add(r1);
		records.add(r2);

		if (!beanValidator(model, r1)) {
			return "{\"rc\":-1,\"msg\":\"error\"}";
		}
		if (!beanValidator(model, r2)) {
			return "{\"rc\":-1,\"msg\":\"error\"}";
		}

		try {
			deductCostService.mergePaySave(records);
		} catch (ZAException e) {
			return "{\"rc\":" + e.get_code() + ",\"msg\":\"" + e.getMessage() + "\"}";
		}
		return "{\"rc\":0,\"msg\":\"success\"}";
	}

	@RequestMapping(value = "toMergeMemberPayByOrder")
	public String toMergeMemberPayByOrder(String memberCode, String[] items, String businessId,String businessTable, Model model) {
		List<PaymentChargingItem> paymentChargingItems = new ArrayList<>();
		for (String item : items) {
			PaymentChargingItem paymentChargingItem = paymentChargingItemService.getByShortName(item);
			paymentChargingItems.add(paymentChargingItem);
		}
		model.addAttribute("items", paymentChargingItems);
		model.addAttribute("member", memberService.getByMemberCode(memberCode));
		model.addAttribute("businessId", businessId);
		model.addAttribute("businessTable", businessTable);
		return "oa/finance/mergeMemberPayByOrder";
	}

	/**
	 * 公用支付方法
	 * 目前只支持俩项费用合并付款
	 * @return
	 */
	@RequiresPermissions("finance:deductCost:payment")
	@RequestMapping(value = "mergePaySaveByOrder")
	@ResponseBody
	public String mergePaySaveByOrder(PaymentOrder paymentOrder, HttpServletRequest request, Model model) {
		String businessId = request.getParameter("businessId");
		String businessTable = request.getParameter("businessTable");
		String memberCode = request.getParameter("memberCode");
		String chargingItemId1 = request.getParameter("chargingItemId1");
		String chargingItemId2 = request.getParameter("chargingItemId2");
		String remarks = request.getParameter("remarks");
		Member member = memberService.getByMemberCode(memberCode);
		//构建订单
		paymentOrder.setIsRecharge("0");
		paymentOrder.setIsBuying("0");
		paymentOrder.setPaymentWay("25");
		List<PaymentOrderDetail> detailList = new ArrayList<>();
		if (!StringUtils.isBlank(chargingItemId1)) {
			PaymentChargingItem item = paymentChargingItemService.get(chargingItemId1);
			PaymentOrderDetail detail = new PaymentOrderDetail();
			detail.setMemberCode(memberCode);
			detail.setMemberName(member.getName());
			detail.setBusinessTable(businessTable);
			detail.setBusinessIds(businessId);
			detail.setChargingItemId(item.getId());
			detail.setChargingItemName(item.getName());
			detail.setPrice(item.getPrice());
			detail.setNum("1");
			detail.setShowBusinessModelFlag("0");
			detail.setRemarks(remarks);
			detail.setDelFlag("0");
			detailList.add(detail);
		}
		if (!StringUtils.isBlank(chargingItemId2)) {
			PaymentChargingItem item = paymentChargingItemService.get(chargingItemId2);
			PaymentOrderDetail detail = new PaymentOrderDetail();
			detail.setMemberCode(memberCode);
			detail.setMemberName(member.getName());
			detail.setBusinessTable(businessTable);
			detail.setBusinessIds(businessId);
			detail.setChargingItemId(item.getId());
			detail.setChargingItemName(item.getName());
			detail.setPrice(item.getPrice());
			detail.setNum("1");
			detail.setShowBusinessModelFlag("0");
			detail.setRemarks(remarks);
			detail.setDelFlag("0");
			detailList.add(detail);
		}
		paymentOrder.setOrderDetailList(detailList);
		try {
			paymentOrderService.save(paymentOrder);
			restOrderService.updateBusiness(paymentOrder);
		} catch (ZAException e) {
			return "{\"rc\":" + e.get_code() + ",\"msg\":\"" + e.getMessage() + "\"}";
		}
		return "{\"rc\":0,\"msg\":\"success\"}";
	}

	@RequestMapping(value = "payBusinessOrderForm")
	public String payBusinessOrderForm(String memberCode, Model model) {
		model.addAttribute("member", memberService.getByMemberCode(memberCode));
		return "oa/finance/memberPayBusinessOrderForm";
	}
}
