/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.dog.dao;

import com.cku.oa.dog.entity.DogPedigreeCertifiedExport;
import com.cku.restful.v1.dog.model.SysCountry;
import com.thinkgem.jeesite.common.persistence.CrudDao;
import com.thinkgem.jeesite.common.persistence.annotation.MyBatisDao;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 出口证书申请DAO接口
 * 
 * @author lgl
 * @version 2016-08-19
 */
@MyBatisDao
public interface DogPedigreeCertifiedExportDao extends CrudDao<DogPedigreeCertifiedExport> {
	int listCount(DogPedigreeCertifiedExport dogPedigreeCertifiedExport);

	DogPedigreeCertifiedExport getByDogId(String dogId);
	DogPedigreeCertifiedExport getByExport(DogPedigreeCertifiedExport dogPedigreeCertifiedExport);

	/**
	 * 
	 * @description: 证书出口处理更新Dog表
	 * @author: laiguanglong
	 * @date: 2016年11月17日 下午4:28:37
	 */
	void resolveUpdateDog(@Param("id") String id, @Param("dogOwner") String dogOwner,
			@Param("dogState") String dogState, @Param("printState") String printState);

	List<DogPedigreeCertifiedExport> findListFyx(DogPedigreeCertifiedExport dogPedigreeCertifiedExport);

	List<SysCountry> getCountryList();
	
	SysCountry getCountry(@Param("en") String en);
	
	DogPedigreeCertifiedExport getByPedigreeCertified(@Param("pedigreeCertified") String pedigreeCertified);
}