//新生犬芯片埋植管理列表页
//新生犬芯片埋植查询
function findNewDogChipList(page){
    var sendData = {};
    sendData["birthCode"] = $("#newDogChipList").val().trim();
    sendData["pageSize"] = "10";
    sendData["pageNo"] = page;
    util.sendAjax({
        url:'dog/newdogchip',
        data:sendData,
        async:false,
        type:'GET',
        cache:false,
        success:function(data){
            if(data.rc==0){
                if(data.list!=null && data.list.length>0){
                    $("#newDogChipList").html("");
                    $.each(data.list,function(index,item){
                        var processState = "";
                        if(item.isCanceled=="1"){
                            processState = "已撤销";
                        }else{
                            processState = "撤销";
                        }
                        $("#newDogChipList").append("<tr>"
                            +"<td>"+item.birthCode+"</td>"
                            +"<td>"+item.createDate+"</td>"
                            +"<td>"+item.hospitalName+"</td>"
                            +"<td class='reviewState'>"+item.reviewState+"</td>"
                            +"<td class='bornPage'>"+processState+"</td>"
                            +"</tr>");
                        if(item.isCanceled!='1'&&item.reviewState=="通过"&&item.canCanceled==true){
                            $(".bornPage").eq(index).css("color","#F00").on("click",function(){
                                layer.open({
                                    content:"是否确认撤销血统证书申请?",
                                    btn:["关闭","确定"],
                                    yes:function(index){
                                        layer.close(index)
                                    },
                                    no:function(index){
                                        delnewdogchip(item.id);
                                        layer.close(index);
                                    }
                                })
                            });
                        }else if(item.isCanceled=='1'){
                            $(".bornPage").eq(index).css("color","#666");
                        }else{
                            $(".bornPage").eq(index).css("color","#B2B2B2");
                        }
                        if(item.reviewState=="未审核"||item.reviewState=="待审核"){
                            $(".reviewState").eq(index).css("color","#329a40");
                        }else if(item.reviewState=="未通过"||item.reviewState=="不通过"){
                            $(".reviewState").eq(index).css("color","#F00").click(function(){
                                layer.open({
                                    title:['未通过原因：','text-align:left;font-size:14px;'],
                                    content:item.reviewRemarks,
                                    btn:["关闭"]
                                })
                            });
                        }
                    })
                    initPage(page,10,data.total);
                }else{
                    $("#newDogChipList").html("");
                    layer.open({
                        content:"新生犬登记列表为空！",
                        skin:"msg",
                        time:2
                    })
                    initPage(page,10,data.total);
                }
            }else{
                layer.open({
                    content:"查询失败："+data.msg,
                    skin:"msg",
                    time:2
                })
            }
        }
    });
}
//撤销
function delnewdogchip(id){
    util.sendAjax({
        url: 'dog/newdogchip/canceled/' + id,
        data: {},
        async: true,
        loadFlag: true,
        type: 'PUT',
        cache: false,
        success: function (data) {
            if (data.rc == 0) {
                layer.open({
                    content:"芯片埋植撤销成功！",
                    skin:"msg",
                    time:2
                });
                window.location.reload();
            } else {
                layer.open({
                    content:"芯片埋植撤销失败:" + data.msg,
                    skin:"msg",
                    time:2
                });
            }
        }
    });
}
//初始化分页
function initPage(nowPage,pageSize,total){
    var html="<div class=\"new-tbl-cell\"><a href=\"?page="+(nowPage==1?1:nowPage-1)+"\" class=\"new-a-prve\"><span>上一页</span></a></div>"+
        "<div class=\"new-tbl-cell new-p-re\"><div class=\"new-a-page\"><span class=\"new-open\">"+nowPage+"/"+Math.ceil(total/pageSize)+"</span></div>"+
        "<select class=\"new-select\" onchange=\"window.location.href=this.value;\">";
    for(var i=1;i<=Math.ceil(total/pageSize);i++){
        html+="<option value=\"?page="+i+"\" "+(nowPage==i?'selected':'')+">第"+i+"页</option>";
    }
    html+="</select></div><div class=\"new-tbl-cell\"><a class=\"new-a-next\" href=\"?page="+(nowPage==Math.ceil(total/pageSize)?nowPage:parseInt(nowPage)+1)+"\"><span>下一页</span></a></div>";
    $("#showPageContent").html(html);
}
$(function(){
    var page =1;
    var obj = util.getQueryString();
    if(obj.page==undefined){
        page=1;
    }else{
        page=obj.page;
    }
    findNewDogChipList(page);
})