<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>报名信息</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {

		});
	</script>
</head>
<body>
<ul class="nav nav-tabs">
	<li class="active"><a href="${ctxSchools}/schoolsCourse/groomerCourseApplicationDetail?id=${groomerCourseApplication.id}">课程报名信息查看</a></li>
</ul><br/>
<form:form id="inputForm" modelAttribute="groomerCourseApplication"  class="form-horizontal">
	<form:hidden path="id"/>
	<sys:message content="${message}"/>
	<h2>会员信息</h2>
	<div class="control-group">
		<label class="control-label">会员号：</label>
		<div class="controls">
				${fns:escapeHtml(groomerCourseApplication.memberCode) }
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">美容师类型：</label>
		<div class="controls">
				${fns:getDictLabels(groomerCourseApplication.member.groomerType, 'user_groomer_type', '无')}
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">姓名：</label>
		<div class="controls">
				${fns:escapeHtml(groomerCourseApplication.name) }
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">手机号：</label>
		<div class="controls">
				${fns:escapeHtml(groomerCourseApplication.member.mobile)}
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">性别：</label>
		<div class="controls">
				${fns:getDictLabels(groomerCourseApplication.member.gender, 'user_gender', '无')}
		</div>
	</div>
	<h2>课程报名信息</h2>
	<div class="control-group">
		<label class="control-label">课程编号：</label>
		<div class="controls">
				${fns:escapeHtml(groomerCourse.code)}
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">课程名称：</label>
		<div class="controls">
				${fns:escapeHtml(groomerCourse.courseName)}
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">课程类型：</label>
		<div class="controls">
			${fns:getDictLabel(groomerCourse.type, 'course_type', '')}
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">课程等级：</label>
		<div class="controls">
			${fns:getDictLabel(groomerCourse.diplomaLevel, 'course_level', '')}
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">课程价格：</label>
		<div class="controls">
				${fns:escapeHtml(groomerCourse.price)}
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">课程讲师：</label>
		<div class="controls">
				${fns:escapeHtml(groomerCourse.teacher)}
		</div>
	</div>
	<c:if test='${groomerCourse.type != 3}'>
		<div class="control-group">
			<label class="control-label">报名时间：</label>
			<div class="controls">
				<fmt:formatDate value="${groomerCourseApplication.createDate}" pattern="yyyy-MM-dd"/>
			</div>
		</div>
	</c:if>
	<c:if test='${groomerCourse.type == 3}'>
		<div class="control-group">
			<label class="control-label">培训时间：</label>
			<div class="controls">
				<fmt:formatDate value="${groomerCourse.startDate}" pattern="yyyy-MM-dd"/>-<fmt:formatDate value="${groomerCourse.endDate}" pattern="yyyy-MM-dd"/>
			</div>
		</div>
	</c:if>

	<div class="form-actions">
		<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
	</div>
</form:form>
</body>
</html>