<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<%@page import="com.cku.oa.sys.entity.user.MemberCardTypeEnum"%>
<html>
<head>
	<title>用户会员信息表管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {

		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
	</script>
</head>
<body>
	<h2><font color="red">会员信息管理</font></h2>
	<HR style="FILTER: progid:DXImageTransform.Microsoft.Glow(color=#987cb9,strength=10)"  color=#987cb9 SIZE=1>
	<form:form id="searchForm" modelAttribute="member" action="${ctxPartner}/clubMember/list" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>会员号/姓名：</label>
				<form:input path="memberCode" htmlEscape="false" maxlength="100" class="input-small"/>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<c:if test="${org.orgType == 'singleTypeClub'}">
				<li class="btns" style="float:right"><a  class="btn btn-primary"  href="${ctxPartner}/clubMember/form" >会员注册</a></li>
				<li class="btns" style="float:right"><a  class="btn btn-primary"  href="${ctxPartner}/clubMember/reform" >会员续费</a></li>
			</c:if>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>会员编号</th>
				<th>姓名</th>
				<th>电话</th>
				<th>会员类型</th>
				<th>会员有效期</th>
				<th>犬舍名称</th>
				<th>犬舍有效期</th>
				<th>登记日期</th>
				<th>编辑</th>
				<th>删除</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="member">
			<tr>
				<td>
					${fns:escapeHtml(member.memberCode) }
				</td>
				<td>
					${fns:escapeHtml(member.name)}
				</td>
				<td>
					${fns:escapeHtml(member.mobile)}
				</td>
				<td>
					${fns:getDictLabels(member.memberCardType, 'member_card_type', '')}
				</td>
				<td>
					<fmt:formatDate value="${member.memberEndDate}" pattern="yyyy-MM-dd"/>
					<font color="red">${fns:getDictLabels(member.paymentState, 'user_payment_state', '')}</font>
					<c:if test="${member.memberType=='basic' && member.memberEndDate > date && org.orgType != 'singleTypeClub'}">
						<a href="${ctxPartner}/payment/pay?memberCode=${member.memberCode}&orgId=${org.id}">续费</a>
					</c:if>

					<c:if test="${ member.memberEndDate >date && org.orgType == 'singleTypeClub' && member.memberSite != '4' && member.memberSite != '6'}">
						<a href="${ctxPartner}/payment/pay?memberCode=${member.memberCode}&orgId=${org.id}">续费</a>
					</c:if>
					<c:if test="${empty member.memberEndDate && member.memberCardType ne MemberCardTypeEnum.DEFAULT_CARD.code()}">
						<a href="${ctxPartner}/payment/pay?memberCode=${member.memberCode}&orgId=${org.id}">缴费</a>
					</c:if>
					<c:if test="${not empty member.memberEndDate && member.memberEndDate < date && org.orgType == 'singleTypeClub'}">
						<a href="${ctxPartner}/clubMember/reform?memberCode=${member.memberCode}" >缴费</a>
					</c:if>
				</td>
				<td>
			<%-- 		<c:if test="${member.memberType eq 'professional' && empty member.kennel}">
						<a href="${ctxPartner}/clubMember/addKennel?id=${member.id}">登记犬舍</a>
					</c:if> --%>
					<c:if test="${empty member.kennel.endTime && not empty member.kennel}">
						<a href="${ctxPartner}/clubMember/editKennel?memberCode=${member.memberCode}">${fns:escapeHtml(member.kennel.name)}</a>
					</c:if>
					<c:if test="${not empty member.kennel.endTime && not empty member.kennel}">
						${fns:escapeHtml(member.kennel.name)}
					</c:if>
				</td>
				<td>
					<fmt:formatDate value="${member.kennel.endTime}" pattern="yyyy-MM-dd"/>
					<c:if test="${not empty member.kennel.endTime && not empty member.kennel && member.kennel.endTime >date}">
						<font color="red">已缴费</font>
					</c:if>
<%-- 					<c:if test="${empty member.kennel.endTime && not empty member.kennel && member.registerFlag eq '0'}">
						<a href="${ctxPartner}/payment/kennelPay?memberCode=${member.memberCode}">缴费</a>
					</c:if>
					<c:if test="${empty member.kennel.endTime && not empty member.kennel && member.registerFlag eq '1'}">
						<a href="${ctxPartner}/payment/pay?memberCode=${member.memberCode}&orgId=${org.id}">缴费</a>
					</c:if>
 --%>				</td>
				<td>
					<fmt:formatDate value="${member.createDate}" pattern="yyyy-MM-dd"/>
				</td>
				<td>
					<c:if test="${empty member.memberEndDate || member.memberEndDate <date}">
    					<a href="${ctxPartner}/clubMember/edit?id=${member.id}">编辑</a>
    				</c:if>
				</td>
				<td>
					<c:if test="${empty member.memberEndDate}">
						<a href="${ctxPartner}/clubMember/delete?id=${member.id}" onclick="return confirmx('确认要删除该用户会员吗？此操作不可回退!', this.href)">删除</a>
					</c:if>
				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>