<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>犬展报名表管理</title>
	<meta name="decorator" content="default"/>
	<style type="text/css">
	.form-horizontal .control-label {
	    width: 120px!important;
	}
	</style>
	<script type="text/javascript">
		$(document).ready(function() {
			//$("#name").focus();
			$("#inputForm").validate({
				submitHandler: function(form){
					loading('正在提交，请稍等...');
					form.submit();
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});

		});
		function setChildShows(value){
		    $.post('${ctx}/apply/showApply/findChildShowsByMainShowId', {
		    	mainShowId: value
		    }, function(data) {
		    	$("#showCode").empty();
	            $.each(data, function(i,item){     
	                $("#showCode").append("<input name='showCode' type='checkbox' value='"+item.id+"' onclick='calculateShowApplyFee();' checked='checked' class='required' />"+item.showName+"<br/>");
	            });     
			    calculateShowApplyFee();
		    });
		}
		function calculateShowApplyFee(){
            var showCodes =[];
            $('input[name="showCode"]:checked').each(function(){
            	showCodes.push($(this).val());
            });  
 		    $.post('${ctx}/apply/showApply/calculateShowApplyFee', {
		    	showCodes: showCodes.toString()
		    }, function(data) {
 		     	$("#fee").val(data);
		    }); 
		}
		function setShowApplyInfo(){
			var mainShowId = $("#mainShowId").val();
			if(mainShowId==''){
				$.jBox.alert("请选择犬展地点！","提示");
				return;
			}
			var pedigreeCertified = $("#pedigreeCertified").val();
			if(pedigreeCertified==''){
				$.jBox.alert("请输cku血统证书号！","提示");
				return;
			}
			var showCode_value =[]; 
			$('input[name="showCode"]:checked').each(function(){ 
				showCode_value.push($(this).val()); 
			}); 
		    $.post('${ctx}/apply/showApply/setShowApplyInfo', {
		    	mainShowId: mainShowId,
		    	pedigreeCertified: pedigreeCertified,
		    	showCode: showCode_value.toString()
		    }, function(data) {
		    	
		    	if(data.status=='1'){
		    		$.jBox.alert(data.msg,"提示");
			    	$("#dogOwnerNameCn").val("");
			    	$("#dogOwnerNameEn").val("");
			    	$("#dogOwnerMemberCode").val("");
			    	$("#ageGroup").html("");
			    	$("#fciCode").val("");
			    	$("#dogBreedNameCn").val("");
			    	$("#dogBreedNameEn").val("");
			    	$("#dogBreedGroup").val("");
			    	$("#dogName").val("");
			    	$("input[name=dogGender]").attr("checked",false);
			    	$("#dogGeneration").val("");
			    	$("#dogBirthday").val("");
			    	$("#breeder").val("");
			    	$("#otherCertified").val("");
			    	$("#fdogPedigreeCertified").val("");
			    	$("#fdogName").val("");
			    	$("#mdogPedigreeCertified").val("");
			    	$("#mdogName").val("");
			    	$("#secondDogOwner").val("");
			    	$("#secondOwnerMember").val("");
		    		return;
		    	}
		    	
		    	$("#dogOwnerNameCn").val(data.dogOwnerNameCn);
		    	$("#dogOwnerNameEn").val(data.dogOwnerNameEn);
		    	$("#dogOwnerMemberCode").val(data.dogOwnerMemberCode);
		    	$("#ageGroup").html("");
		    	var ageGroupList = ""+data.ageGroupList;
				var refereeArray = ageGroupList.split(",");
				$.each(refereeArray, function(i,val) {
					var array = val.split("=");
					$("#ageGroup").append("<input name='ageGroup' class='required' type='radio' value='"+array[0]+"'><lable>"+array[1]+"</lable>");
			    });
		    	$("#fciCode").val(data.fciCode);
		    	$("#dogBreedNameCn").val(data.dogBreedNameCn);
		    	$("#dogBreedNameEn").val(data.dogBreedNameEn);
		    	$("#dogBreedGroup").val(data.dogBreedGroup);
		    	$("#dogName").val(data.dogName);
		    	$("input[name=dogGender][value="+data.dogGender+"]").attr("checked",'checked');
		    	$("#dogGeneration").val(data.dogGeneration);
		    	$("#dogBirthday").val(data.dogBirthday);
		    	$("#breeder").val(data.breeder);
		    	$("#otherCertified").val(data.otherCertified);
		    	$("#fdogPedigreeCertified").val(data.fdogPedigreeCertified);
		    	$("#fdogName").val(data.fdogName);
		    	$("#mdogPedigreeCertified").val(data.mdogPedigreeCertified);
		    	$("#mdogName").val(data.mdogName);
		    	$("#secondDogOwner").val(data.secondDogOwner);
		    	$("#secondOwnerMember").val(data.secondOwnerMember); 
		    	
		    });
		}
		function getMenberInfo(){
			var handlerMemberCode = $("#handlerMemberCode").val();
			if(handlerMemberCode==''){
				$.jBox.alert("请输入参展人会员号！","提示");
				return;
			}
		    $.post('${ctx}/apply/showApply/getHandlerInfo', {
		    	handlerMemberCode: handlerMemberCode
		    }, function(data) {
		    	$("#remarks").val(data);
		    });
		}
	</script>
	<link rel="stylesheet" href="${ctxStatic }/modules/common/two-column.css"/>
</head>
<body>
	<ul class="nav nav-tabs">
		<shiro:hasPermission name="apply:showApply:view"><li><a href="${ctx}/apply/showApply/">犬展报名表列表</a></li></shiro:hasPermission>
		<li class="active"><a href="${ctx}/apply/showApply/form?id=${showApply.id}">犬展报名表查看</a></li>
	</ul><br/>
	<form:form id="inputForm" modelAttribute="showApply" action="${ctx}/apply/showApply/save" method="post" class="form-horizontal">
		<form:hidden path="id"/>
		<form:hidden id="dogGeneration" path="dogGeneration"/>
		<input type="hidden" name="phoneApplyFlag" value="${not empty showApply.id?showApply.phoneApplyFlag:'0'}" />
		<sys:message content="${message}"/>		
		<div class="control-group">
			<label class="control-label">选择犬展：</label>
			<div id="showCode" class="controls">
				${fns:escapeHtml(showApply.showCode)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">展前退费：</label>
			<div id="refundFlag" class="controls">
				<c:if test="${showApply.refundFlag=='0'}">否</c:if>
				<c:if test="${showApply.refundFlag=='1'}">是</c:if>
			</div>
		</div>
		<div style = "clear:both;"/>
		<div class="control-group">
			<label class="control-label">CKU血统证书号：</label>
			<div class="controls">
				${fns:escapeHtml(showApply.pedigreeCertified)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">现场请假：</label>
			<div id="absenceFlag" class="controls">
				<c:if test="${showApply.absenceFlag=='0'}">否</c:if>
				<c:if test="${showApply.absenceFlag=='1'}">是</c:if>
			</div>
		</div>
		<div style = "clear:both;"/>
		<div class="control-group">
			<label class="control-label">犬主人：</label>
			<div class="controls">
				${fns:escapeHtml(showApply.dogOwnerNameCn)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">会员号：</label>
			<div class="controls">
				${fns:escapeHtml(showApply.dogOwnerMemberCode)}
			</div>
		</div>
		<div style = "clear:both;"/>
		<c:set var="showCodeArray" value="${fn:split(showApply.showCode,',')}"/>
		<c:set var="ageGroupArray" value="${fn:split(showApply.ageGroup,',')}"/>
		<c:set var="isOwnerArray" value="${fn:split(showApply.isOwner,',')}"/>
		<c:forEach items="${showCodeArray}" var="showCode" varStatus="status">
			<div class="control-group">
				<label class="control-label">犬展编号：</label>
				<div id="showCode" class="controls">${showCode}</div>
			</div>
			<div class="control-group">
				<label class="control-label">参展组别：</label>
				<div class="controls">${ageGroupArray[status.index]}${empty fn:trim(isOwnerArray[status.index]) ? '' : ','.concat(isOwnerArray[status.index])}</div>
			</div>
			<div style = "clear:both;"/>
		</c:forEach>
		<div class="control-group">
			<label class="control-label">报名费：</label>
			<div class="controls">
				${fns:escapeHtml(showApply.fee)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">报名序号：</label>
			<div class="controls">
				${fns:escapeHtml(showApply.applyCode)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">备注：</label>
			<div class="controls">
				${fns:escapeHtml(showApply.remarks)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">参展人：</label>
			<div class="controls">
				${fns:escapeHtml(showApply.handlerMemberCode)}
			</div>
		</div>
		<div style = "clear:both;"/>
		<div class="control-group">
			<label class="control-label">订单编号：</label>
			<div class="controls">
				${fns:escapeHtml(showApply.runningNumber)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">提交时间：</label>
			<div class="controls">
				<fmt:formatDate value="${showApply.createDate}" pattern="yyyy-MM-dd HH:mm:ss"/>
			</div>
		</div>
		<div style = "clear:both;"/>
		<div class="control-group">
			<label class="control-label">最后修改人：</label>
			<div class="controls">
				${fns:escapeHtml(showApply.updateBy.name)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">最后修改时间：</label>
			<div class="controls">
				<fmt:formatDate value="${showApply.updateDate}" pattern="yyyy-MM-dd HH:mm:ss"/>
			</div>
		</div>
		<div style = "clear:both;"/>
		<hr style="height:3px;border:none;border-top:3px double red;" />
        <ul>
           <li><font color="#FF0000">以下内容可以不填，系统自动调取。（如填写，则以填写的内容为准） </font></li>
        </ul>
		
		<div style = "clear:both;"/>
		<div class="control-group">
			<label class="control-label">犬主英文名：</label>
			<div class="controls">
				${fns:escapeHtml(showApply.dogOwnerNameEn)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">FCI码：</label>
			<div class="controls">
				${fns:escapeHtml(showApply.fciCode)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">第二犬主姓名：</label>
			<div class="controls">
				${fns:escapeHtml(showApply.secondDogOwner)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">第二犬主会员号：</label>
			<div class="controls">
				${fns:escapeHtml(showApply.secondOwnerMember)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">犬种中文名：</label>
			<div class="controls">
				${fns:escapeHtml(showApply.dogBreedNameCn)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">犬种英文名：</label>
			<div class="controls">
				${fns:escapeHtml(showApply.dogBreedNameEn)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">犬名：</label>
			<div class="controls">
				${fns:escapeHtml(showApply.dogName)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">犬种组：</label>
			<div class="controls">
				${fns:escapeHtml(showApply.dogBreedGroup)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">性别：</label>
			<div class="controls">
				${fns:getDictLabel(showApply.dogGender, 'dog_gender', '')}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">出生日期：</label>
			<div class="controls">
				<fmt:formatDate value="${showApply.dogBirthday}" pattern="yyyy-MM-dd"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">国外血统证书号：</label>
			<div class="controls">
				${fns:escapeHtml(showApply.otherCertified)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">繁殖人：</label>
			<div class="controls">
				${fns:escapeHtml(showApply.breeder)}
			</div>
		</div>
		<div style = "clear:both;"/>
		<div class="control-group">
			<label class="control-label">父血统证书号：</label>
			<div class="controls">
				${fns:escapeHtml(showApply.fdogPedigreeCertified)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">父犬名：</label>
			<div class="controls">
				${fns:escapeHtml(showApply.fdogName)}
			</div>
		</div>
		<div style = "clear:both;"/>
		<div class="control-group">
			<label class="control-label">母血统证书号：</label>
			<div class="controls">
				${fns:escapeHtml(showApply.mdogPedigreeCertified)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">母犬名：</label>
			<div class="controls">
				${fns:escapeHtml(showApply.mdogName)}
			</div>
		</div>
		<div style = "clear:both;"/>
		<div class="control-group">
			<label class="control-label">芯片号：</label>
			<div class="controls">
			${fns:escapeHtml(showApply.chipCode)}
			</div>
		</div>
		<div style = "clear:both;"/>
		<div class="form-actions">
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
		</div>
	</form:form>
</body>
</html>