<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>原生犬新闻管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/nativedog/nativeDogNews/">原生犬新闻列表</a></li>
		<shiro:hasPermission name="nativedog:nativeDogNews:edit"><li><a href="${ctx}/nativedog/nativeDogNews/form">原生犬新闻添加</a></li></shiro:hasPermission>
	</ul>
	<form:form id="searchForm" modelAttribute="nativeDogNews" action="${ctx}/nativedog/nativeDogNews/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>标题：</label>
				<form:input path="title" htmlEscape="false" maxlength="50" class="input-medium"/>
			</li>
			<li><label>作者：</label>
				<form:input path="author" htmlEscape="false" class="input-medium"/>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>标题</th>
				<th>作者</th>
				<th>修改时间</th>
				<th>备注信息</th>
				<shiro:hasPermission name="nativedog:nativeDogNews:edit"><th>操作</th></shiro:hasPermission>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="nativeDogNews">
			<tr>
				<td><a href="${ctx}/nativedog/nativeDogNews/form?id=${nativeDogNews.id}">
					${nativeDogNews.title}
				</a></td>
				<td>
					${nativeDogNews.author}
				</td>
				<td>
					<fmt:formatDate value="${nativeDogNews.updateDate}" pattern="yyyy-MM-dd HH:mm:ss"/>
				</td>
				<td>
					${nativeDogNews.remarks}
				</td>
				<shiro:hasPermission name="nativedog:nativeDogNews:edit"><td>
    				<a href="${ctx}/nativedog/nativeDogNews/form?id=${nativeDogNews.id}">修改</a>
					<a href="${ctx}/nativedog/nativeDogNews/delete?id=${nativeDogNews.id}" onclick="return confirmx('确认要删除该原生犬新闻吗？', this.href)">删除</a>
				</td></shiro:hasPermission>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>