<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>上传榜单数据</title>
	<meta name="decorator" content="default"/>
	<script src="${ctxStatic}/jquery-validation/1.11.0/lib/jquery.form.js" type="text/javascript"></script>
	<script type="text/javascript">
		$(document).ready(function() {
			
			//页面初始化
			if('${handlerScoreRanking.tableType}' != ''){
					if('Y'== '${handlerScoreRanking.tableType}'){
						$("#quarterDiv").hide();
				    	$("#monthDiv").hide();
					}else if('M'== '${handlerScoreRanking.tableType}'){
						$("#quarterDiv").hide();
				    	$("#monthDiv").show();
					}else if('Q'== '${handlerScoreRanking.tableType}'){
						$("#quarterDiv").show();
				    	$("#monthDiv").hide();
					}
					$("input[name='tableType']").each(function(){
		                $(this).attr("disabled","true");
		            });
					$("#year").attr("disabled","true");
					$("#month").attr("disabled","true");
					$("#quarter").attr("disabled","true"); 
				}
			
			$("#inputForm").validate({
				submitHandler: function(form){
					form.submit();
				},
				rules:{
					tableType:{
						required:true
					},
					year:{
						required:true
					},
					month:{
						required:true
					},
					quarter:{
						required:true
					},
					fj:{
						required:true
					}
				}, 
				 messages:{
					tableType:{
						required:"榜单类型不能为空"
					},
					year:{
						required:"年份不能为空"
					},
					month:{
						required:"月份不能为空"
					},
					quarter:{
						required:"季度不能为空"
					},
					fj:{
						required:"附件不能为空"
					}
				}, 
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});
			
			
			$("#btnSubmit").click(function () {
				layer.load();
				if('${handlerScoreRanking.tableType}' != ''){
					$("input[name='tableType']").each(function(){
		                $(this).removeAttr("disabled");
		            });
					$("#year").removeAttr("disabled");
					$("#month").removeAttr("disabled");
					$("#quarter").removeAttr("disabled"); 

					inputFormAjaxSubmit();
					layer.closeAll('loading');
					return false;
				}else{
					if (!$("#inputForm").valid()) {
						return false;
					}
					//验证此榜单是否已经有数据进行提示
					 $.ajax({
		                type: "post",
		                url: "${ctx}/handler/handlerScoreRanking/uploadCheck",
		                dataType: "json",
		                data : {
		                	tableType : $("input[name='tableType']:checked").val(),
		                	year : $("#year").val(),
		                	month : $("#month").val(),
		                	quarter : $("#quarter").val()
						},
		                async: false,
		                error: function (request, textStatus, errorThrown) {
		                    alert("系统错误！");
		                    layer.closeAll('loading');
							return false;
		                },
		                success: function (data) {
		                	if (data.rc == 1) {
		                		if(confirm(data.msg)){
		                			inputFormAjaxSubmit();
		    						layer.closeAll('loading');
		    						return false;
		                		}else{
		                			layer.closeAll('loading');
									return false;
		                		}
		                	}else{
		                		inputFormAjaxSubmit(); 
		                		layer.closeAll('loading');
								return false;
		                	}
		                }
		            });		
				}
			});
			function inputFormAjaxSubmit(){
				$("#inputForm").ajaxSubmit({
					dataType: 'json',
					beforeSubmit: function () {
						if (!$("#inputForm").valid()) {
							layer.closeAll('loading');
							return false;
						}
					},
					success: function (data) {
						layer.closeAll('loading');
						if (data.rc == 0) {
							layer.msg("保存成功！");
							parent.isYes = true;
						} else {
							layer.msg(data.msg);
							parent.isYes = false;
						}
						setTimeout(function(){
							if(parent.document.getElementById("mainFrame").contentWindow.bindUserCallback != undefined){
									parent.document.getElementById("mainFrame").contentWindow.bindUserCallback(data);
							}
							var index = parent.layer.getFrameIndex(window.name); //获取窗口索引
							parent.layer.close(index);
						},1500);

					},
					error: function (err) {
						layer.closeAll('loading');
						layer.msg("操作失败!");
					}
				});	
			}
			
			
			
			$('input[type=radio][name=tableType]').change(function () {
			    if(this.value == 'M'){
			    	$("#quarterDiv").hide();
			    	$("#monthDiv").show();
			    }else if(this.value == 'Q'){
			    	$("#quarterDiv").show();
			    	$("#monthDiv").hide();
			    }else if(this.value == 'Y'){
			    	$("#quarterDiv").hide();
			    	$("#monthDiv").hide();
			    }
			})
		});
	</script>
</head>
<body>
	<div id="bindForm" style="padding-top:20px;">
	<form:form id="inputForm" modelAttribute="handlerScoreRanking" action="${ctx}/handler/handlerScoreRanking/upload" method="post" 
		class="form-horizontal" enctype="multipart/form-data">
		<sys:message content="${message}"/>	
			<div class="control-group">
				<label class="control-label">榜单类型：</label>
				<form:radiobutton path="tableType" value="M" checked="true"/>月榜
				<form:radiobutton path="tableType" value="Q" />季榜
				<form:radiobutton path="tableType" value="Y" />年榜
			    <font color="red">*</font>
			</div>
			<div class="control-group">
				<label class="control-label">年份：</label>
				<form:select path="year" class="input-medium" >
					<form:option value="" label=""/>
					<c:forEach items="${yearList}" var="year">
						<form:option value="${year}" label="${year}" />
					</c:forEach>
				</form:select>
			    <font color="red">*</font>
			</div>
			<div class="control-group" id='monthDiv' >
				<label class="control-label">月份：</label>
				<form:select path="month" class="input-medium">
					<form:option value="" label=""/>
					<c:forEach items="${monthList}" var="month">
						<form:option value="${month}" label="${month}月"/>
					</c:forEach>
				</form:select>
			    <font color="red">*</font>
			</div>
			<div class="control-group"  id='quarterDiv' style="display:none;">
				<label class="control-label">季度：</label>
				<form:select path="quarter" class="input-medium">
					<form:option value="" label=""/>
					<form:options items="${fns:getDictList('quarter')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
				<font color="red">*</font>
			</div>
			
			<div class="control-group">
				<label class="control-label">附件：</label>
				<input id="fj" name='fj' type="file"/>
			    <font color="red">*</font>
			</div>
			<div class="control-group">
				<label class="control-label">模板：</label>
				<a href="https://ckuoa.oss-cn-qingdao.aliyuncs.com/ckuoa/templates/%E7%89%B5%E7%8A%AC%E5%B8%88%E6%8E%92%E8%A1%8C%E6%A6%9C%E5%AF%BC%E5%85%A5%E6%A8%A1%E7%89%88.xlsx">
					下载模板
				</a>
			</div>
			<center><input id="btnSubmit" class="btn btn-primary" type="button" value="提交"/></center>
	</form:form>
	</div>
</body>
</html>