<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>推荐课程</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//查重
			$("#curriculumIndex").blur(function () {
				var curriculumIndex = $("#curriculumIndex").val();
				var id = $("#id").val();

				$.ajax({
					url:'${ctx}/groomer/curriculum/iSrepeat',
					data: {curriculumIndex:curriculumIndex,id:id},
					async:true,
					loadFlag:true,
					type:'get',
					cache:false,
					success:function(json){
						if(json.rc!=0){
							layer.msg(json.msg);
						}
					}
				});
			});
			$("#btnSubmit").click(function(){
				var  rotationType = $("#rotationType").val();
				if ($("#curriculumName").val() == "") {
					alert("请输入课程名称");
					return false;
				}
				if ($("#curriculumPicture").val() == "") {
					alert("请上传banner图素材");
					return false;
				}

				if(rotationType=="1"){
					if ($("#curriculumJump").val() == "") {
						alert("请输入课程编号");
						return false;
					}
				}else if(rotationType=="2"){
					if ($("#curriculumHref").val() == "") {
						alert("输入banner图链接");
						return false;
					}
				}else{
					if ($("#curriculumJump").val() == "" && $("#curriculumHref").val() == "") {
						alert("请输入课程编号或请输入banner图链接");
						return false;
					}
					if($("#curriculumJump").val()!=''){
						$("#rotationType").val("1");
					}
					if($("#curriculumHref").val()!=''){
						$("#rotationType").val("2");
					}

				}
				if ($("#curriculumIndex").val() == "") {
					alert("请输入序号");
					return false;
				}
				$("#inputForm").submit();
			});

			$("#curriculumJump").blur(function(){
				var curriculumJump = $("#curriculumJump").val();
				var curriculumHref = $("#curriculumHref").val();

				if(curriculumJump!=''){
					$("#rotationType").val("1");
					$("#curriculumHref").val("");
				}

				if(curriculumJump=='' && curriculumHref!=''){
					$("#rotationType").val("2");
					$("#curriculumJump").val("");
				}
			});

			$("#curriculumHref").blur(function(){
				var curriculumHref = $("#curriculumHref").val();
				var curriculumJump = $("#curriculumJump").val();

				if(curriculumHref!=''){
					$("#rotationType").val("2");
					$("#curriculumJump").val("");
				}

				if(curriculumHref=='' && curriculumJump!=''){
					$("#rotationType").val("1");
					$("#curriculumHref").val("");
				}
			});





		});



	</script>
	<link rel="stylesheet" href="${ctxStatic }/modules/common/two-column.css"/>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="javascript:void(0);">推荐课程</a></li>
	</ul><br/>
	<form:form id="inputForm" modelAttribute="curriculum" action="${ctx}/groomer/curriculum/save" method="post" class="form-horizontal">
		<sys:message content="${message}"/>
		<form:input path="id" id="id" type="hidden" htmlEscape="false" maxlength="100" class="input-xlarge required"/>
		<input id="rotationType" type="hidden" htmlEscape="false" maxlength="100" class="input-xlarge required"/>
		<h4>请填写推荐课程相关信息</h4>
        <br/>
		<div class="control-group">
			<label class="control-label">课程名称：</label><span class="help-inline"><font color="red">*</font></span>
			<div class="controls">
				<form:input path="curriculumName" id="curriculumName"  htmlEscape="false" maxlength="25" class="input-xlarge required" placeholder ="请输入课程名称"/>

			</div>
		</div>
		<div class="control-group" style="width:80%">
			<label class="control-label">banner图素材：</label><span class="help-inline"><font color="red">*</font></span>
			<div class="controls">
				<sys:singleImgUpload module="member"  imgId="${curriculum.curriculumPicture}" fileSizeLimit="1024*1024*1" fileSingleSizeLimit="1024*1024*1" successCallback="uploadSuccess"/>
				<form:input path="curriculumPicture" id="curriculumPicture" htmlEscape="false" maxlength="255" class="input-xlarge " type="hidden"/>
				<!-- 文件上传成功的回调方法 -->
				<script type="text/javascript">
					function uploadSuccess(file,response){
						$("#curriculumPicture").val(response.id);
					}
				</script>

			</div>
		</div>
		<div style = "clear:both;"></div>
		<div class="control-group">
			<label class="control-label">跳转课程：</label>
			<div class="controls">
				<form:input path="curriculumJump" id="curriculumJump" htmlEscape="false" maxlength="64" class="input-xlarge " placeholder ="请输入课程编号"/>
			</div>
		</div>
		<div style = "clear:both;"></div>
		<div class="control-group">
			<label class="control-label">banner图链接：</label>
			<div class="controls">
				<form:input path="curriculumHref" id="curriculumHref" htmlEscape="false" maxlength="125" class="input-xlarge " placeholder ="请输入banner图链接"/>
			</div>
		</div>
		<div style = "clear:both;"></div>
		<div class="control-group">
			<label class="control-label">序号：</label><span class="help-inline"><font color="red">*</font></span>
			<div class="controls">
				<form:input path="curriculumIndex" id="curriculumIndex" min="1" type="number" htmlEscape="false" maxlength="64"/>

			</div>
		</div>
		<div style = "clear:both;"></div>

		<div class="form-actions">
			<shiro:hasPermission name="groomer:curriculum:save">
				<c:if test="${curriculum.id!=null and curriculum.id!=''}">
					<input id="btnSubmit" class="btn btn-primary" type="button" value="保存"/>&nbsp;
                </c:if>
                <c:if test="${curriculum.id==null}">
					<input id="btnSubmit" class="btn btn-primary" type="button" value="立即添加"/>&nbsp;
                </c:if>
			</shiro:hasPermission>
			<input id="btnCancel" class="btn" type="button" value="取消" onclick="history.go(-1)"/>
		</div>
	</form:form>
</body>
</html>