<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>第二繁殖人管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			$("#inputForm").validate({
				submitHandler: function(form){
					loading('正在提交，请稍等...');
					$.post('${ctx}/dog/dogSecondBreeder/saveOrder',
							$('#inputForm').serialize(),
							function(data) {
								console.log("data"+data)
								if(data.rc==0){
									alert("存档成功！");
									parent.isYes = true;
									parent.layer.closeAll();
								}else{
									alert("提交失败,错误信息："+data.msg);
								}
							});
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});
		});

		function getByBreedCertifiedCode(){
			var breedCertifiedCode = $("#breedCertifiedCode").val();
			if(breedCertifiedCode==''){
				return;
			}
			$.post('${ctx}/dog/dogSecondBreeder/findByFmdogBreedCertifiedCode', {
				fmdogBreedCertifiedCode: breedCertifiedCode
			}, function(data) {
				var secondBreederMemberCode = "";
				$("#tbody").empty();
				$("#secondBreeder").html("");
				$("#memberCardType").html("");
				$("#states").html("");
				$("#secondBreederMemberCode").val("");
				if(data != ""){
					$.each(data, function(i,birth) {
						$("#tbody").append(
								"<tr>"+
								"<td>"+birth.pedigreeCertified+"</td>"+
								"<td>"+birth.birthCerRegCode+"</td>"+
								"<td>"+birth.dogBreed+"</td>"+
								"<td>"+birth.dogEnName+"</td>"+
								"<td>"+birth.breeder+"</td>"+
								"<td>"+birth.dogOwenr+"</td>"+
								"</tr>"
						)
						secondBreederMemberCode = birth.secondBreederMemberCode;
					});
					if(secondBreederMemberCode != ''){

						$.post('${ctx}/dog/dogSecondBreeder/getSecondBreeder', {
							secondBreederMemberCode: secondBreederMemberCode
						}, function(data) {
							$("#secondBreeder").html(data.secondBreeder);
							$("#memberCardType").html(data.memberCardType);
							$("#secondBreederMemberCode").val(data.secondBreederMemberCode);
							if (data.states==1) {
								$("#states").html("有效");
							}else{
								$("#states").html("无效");
							}
						});
					}
				}else {
					alert("查询不到出生纸信息");
				}
			});
		}
		function searchSecondBreederInfo(){
			$("#secondBreeder").html("");
			$("#memberCardType").html("");
			$("#states").html("");
			var secondBreederMemberCode = $("#secondBreederMemberCode").val();
			if(secondBreederMemberCode==''){
				return;
			}
			$.post('${ctx}/dog/dogSecondBreeder/getSecondBreeder', {
			secondBreederMemberCode: secondBreederMemberCode
		}, function(data) {
				if(data.rc != 0){
					alert(data.msg)
				}else{
					$("#secondBreeder").html(data.secondBreeder);
					$("#memberCardType").html(data.memberCardType);
					if (data.states==1) {
						$("#states").html("有效");
					}else{
						$("#states").html("无效");
					}
				}
			});
		}
		function closeLayer(){
			parent.layer.closeAll();
		}
	</script>
</head>
<body>
	<form:form id="inputForm" modelAttribute="dogSecondBreeder" class="form-horizontal">
		<input type="hidden" name="runningNumber" value="${runningNumber}"/>
		<sys:message content="${message}"/>
		<div class="control-group">
			<label>配种证明编号：</label>
			<form:input path="breedCertifiedCode" htmlEscape="false" maxlength="64" class="input-medium"/>
			<input  class="btn btn-primary" type="button" onclick="getByBreedCertifiedCode()" value="查询"/>
			<span id="msg"></span>
		</div>
		<div style="width: 100%">
			<table id="contentTable" class="table table-striped table-bordered table-condensed">
				<thead>
				<tr>
					<th>血统证书编号</th>
					<th>登记卡编号</th>
					<th>品种</th>
					<th>犬名</th>
					<th>繁殖人</th>
					<th>犬主人</th>
				</tr>
				</thead>
				<tbody id="tbody">
				</tbody>
			</table>
		</div>
		<div class="control-group">
			<label>第二繁殖人：</label>
			<form:input path="secondBreederMemberCode" htmlEscape="false" maxlength="64" class="input-medium"/>
			<input id="" class="btn btn-primary" type="button" onclick="searchSecondBreederInfo()" value="查询"/>

		</div>
		<div class="control-group">
			<label>会员姓名：</label>
			<span id="secondBreeder" style="color:green">
		</div>
		<div class="control-group">
			<label>会员类型：</label>
			<span id="memberCardType" style="color:green">
		</div>
		<div class="control-group">
			<label>会员状态：</label>
			<span id="states" style="color:green">
		</div>

		<div class="form-actions">
			<input id="btnSubmit" class="btn btn-primary" type="submit" value="保 存"/>
			<input id="btnCancel" class="btn" type="button" value="关闭" onclick="closeLayer()"/>
		</div>
	</form:form>
</body>
</html>