<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>犬只DNA存档换绑采样包</title>
	<meta name="decorator" content="default"/>
	<script src="${ctxStatic}/jquery-validation/1.11.0/lib/jquery.form.js" type="text/javascript"></script>
	<script type="text/javascript">
		$(document).ready(function() {
			//保存事件
			$("#btnSubmit").click(function () {
				let samplingMemberName = $("#samplingMemberNameDiv").html().trim();
				if (samplingMemberName == '') {
					alert("请先查询采样包归属人");
					return;
				}
				if ('${dogDnaArchive.organizationName}' != samplingMemberName) {
					alert("采样包归属机构与当前办理机构不一致");
					return;
				}
				$("#inputForm").ajaxSubmit({
					dataType: 'json',
					beforeSubmit: function () {
						if (!$("#inputForm").valid() || $(".error:visible").length > 0) {
							return false;
						} else {
							return true;
						}
					},
					success: function (json) {
						let data = eval(json);
						if (data.rc == 0) {
							layer.msg(data.data);
							parent.isYes = true;
							parent.layer.closeAll();
						} else {
							layer.msg(data.msg);
						}
					},
					error: function (err) {
						layer.msg("操作失败!");
					}
				});
			});
		});

		function findBySamplingCode() {
			var samplingCode = $("#samplingCode").val();
			if (samplingCode == '') {
				alert("请输入采样包编号");
                return;
			}
			$.ajax({
				type: "GET",
				url: "${ctx}/sampling/sampling/samplingCode?samplingCode=" + samplingCode,
				async: false,
				success: function (json) {
					let data = eval(json)
					if (data.rc == 0) {
						if (data.data.bindType == 1) {
							alert("该采样包已被使用");
							$("#samplingMemberNameDiv").html("");
						} else {
							if (data.data.memberName == '') {
								alert("请输入办理机构名下的采样包");
								$("#samplingMemberNameDiv").html("");
							} else if ('${dogDnaArchive.organizationName}' != data.data.memberName) {
								alert("采样包归属机构与当前办理机构不一致");
								$("#samplingMemberNameDiv").html(data.data.memberName);
							} else {
								$("#samplingMemberNameDiv").html(data.data.memberName);
							}
						}
					} else {
						$("#samplingMemberNameDiv").html("");
						layer.msg(data.msg);
					}
				},
				error: function (err) {
					layer.msg("操作失败!");
				}
			});
		}

		function closeLayer(){
			parent.layer.closeAll();
		}

	</script>
</head>
<body>
	<form:form id="inputForm" modelAttribute="dogDnaArchive" action="${ctx}/dnaarchive/dogDnaArchive/rebind" method="post" class="form-horizontal">
		<form:hidden path="id"/>
		<div class="control-group">
			<label class="control-label">血统证书号：</label>
			<div class="controls">
				<form:input path="pedigreeCertified" htmlEscape="false" readonly="true" maxlength="64" class="input-xlarge"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">国外证书号：</label>
			<div class="controls">
				<form:input path="overseasPedigreeCertified" htmlEscape="false" readonly="true" maxlength="64" class="input-xlarge"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">出生纸编号：</label>
			<div class="controls">
				<form:input path="birthCode" htmlEscape="false" readonly="true" maxlength="64" class="input-xlarge"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">犬主人：</label>
			<div class="controls">
				<span title="${fns:escapeHtml(dogDnaArchive.paymentMemberCode)}">
						${fns:escapeHtml(dogDnaArchive.memberName)}
				</span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">申请日期：</label>
			<div class="controls">
				<input name="bindTime" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate "
					   value="<fmt:formatDate value="${dogDnaArchive.createDate}" pattern="yyyy-MM-dd HH:mm:ss"/>"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">办理机构：</label>
			<div class="controls">
					${fns:escapeHtml(dogDnaArchive.organizationName)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">原采样包编号：</label>
			<div class="controls">
				${fns:escapeHtml(originSamplingCode)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">采样包编号：</label>
			<div class="controls">
				<form:input path="samplingCode" htmlEscape="false" maxlength="64" class="input-xlarge "/>
				<span class="help-inline"><font color="red">*</font> </span>
				<button type="button" class="btn btn-primary" onclick="findBySamplingCode()">查询</button>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">采样包归属人：</label>
			<div class="controls" id="samplingMemberNameDiv">
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">备注信息：</label>
			<div class="controls">
				<form:textarea path="remarks" htmlEscape="false" rows="4" maxlength="255" class="input-xxlarge "/>
			</div>
		</div>
		<div class="form-actions">
			<shiro:hasPermission name="dnaarchive:dogDnaArchive:rebind"><input id="btnSubmit" class="btn btn-primary" type="button" value="保 存"/>&nbsp;</shiro:hasPermission>
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="closeLayer()"/>
		</div>
	</form:form>
</body>
</html>