/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.subsystem.dog;

import com.cku.core.ZAException;
import com.cku.oa.dog.entity.DogBirthCertificate;
import com.cku.oa.dog.entity.DogBirthCertificateApply;
import com.cku.oa.dog.service.DogBirthCertificateService;
import com.cku.oa.dog.service.DogColorMarkService;
import com.cku.oa.sys.service.LoginServerService;
import com.cku.oa.sys.util.RequestUtil;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.modules.sys.entity.Office;
import com.thinkgem.jeesite.modules.sys.entity.User;
import com.thinkgem.jeesite.modules.sys.service.OfficeService;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.*;

/**
 * 出生证明Controller
 * @author lgl
 * @version 2016-08-04
 */
@Controller
@RequestMapping(value = "/subSystem/dogBirthCertificate")
public class SubDogBirthCertificateController extends BaseController {

	@Autowired
	private DogBirthCertificateService dogBirthCertificateService;
	@Autowired
	private DogColorMarkService dogColorMarkService;
	@Autowired
	private OfficeService officeService;
	@Autowired
	private LoginServerService loginServerService;

	/**
	 * 查询当前登录人登录类型得到跳转路径头
	 * @return
	 * @author chaixueteng
	 */
	public String getUrlByUserType(){
		User loginUser = UserUtils.getLoginUser();
		return loginServerService.getShortNameByUserType(loginUser.getUserType());
	}

	@ModelAttribute
	public DogBirthCertificate get(@RequestParam(required=false) String id) {
		DogBirthCertificate entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = dogBirthCertificateService.get(id);
		}
		if (entity == null){
			entity = new DogBirthCertificate();
		}
		return entity;
	}
	
	@RequestMapping(value = {"list", ""})
	public String list(DogBirthCertificate dogBirthCertificate, HttpServletRequest request, HttpServletResponse response, Model model) {
//		if(!RequestUtil.hasParameter(request)){
//			//没有参数的查询，默认只查询最近的三个月
//			Calendar calendar = Calendar.getInstance();//日历对象
//			Date date = new Date();
//			date.setHours(0);
//			date.setMinutes(0);
//			date.setSeconds(0);
//			calendar.setTime(date);//设置当前日期
//			calendar.add(Calendar.MONTH, -3);//年份+1
//			dogBirthCertificate.setBeginCreateDate(calendar.getTime());
//		}
		Page<DogBirthCertificate> page = dogBirthCertificateService.findPage(new Page<DogBirthCertificate>(request, response), dogBirthCertificate); 
		for(DogBirthCertificate po:page.getList()){
			po.setBusinessState(dogBirthCertificateService.getBusinessState(po));
		}
		model.addAttribute("page", page);
		List<Office> agencyList = officeService.findAgency();
		Office other = new Office();
		other.setName("北京办事处");
		other.setId("other");
		agencyList.add(other);
		model.addAttribute("agencyList", agencyList);
		//预设的参数不带回到页面
		if(!RequestUtil.hasParameter(request)){
			dogBirthCertificate.setBeginCreateDate(null);
		}
		return "subSystem/"+getUrlByUserType()+"/dog/birthcertificate/dogBirthCertificateList";
	}

	@RequestMapping(value = "form")
	public String form(DogBirthCertificate dogBirthCertificate, Model model) {
		model.addAttribute("dogColorMarkList", dogColorMarkService.findAllList());
		model.addAttribute("dogBirthCertificate", dogBirthCertificate);
		return "subSystem/"+getUrlByUserType()+"/dog/birthcertificate/dogBirthCertificateForm";
	}

}