package com.cku.schools.mrschool.web;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Objects;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.cku.logUtil.JSONObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;

import com.cku.oa.groomer.entity.GroomerQualificationCertificate;
import com.cku.oa.groomer.entity.GroomerRegister;
import com.cku.oa.groomer.service.GroomerQualificationCertificateService;
import com.cku.oa.groomer.service.GroomerRegisterService;
import com.cku.oa.trainschool.entity.TrainingInstitution;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.modules.sys.entity.User;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

import edu.emory.mathcs.backport.java.util.Arrays;

@Controller
@RequestMapping(value = "/schools/schoolsGroomerQualificationCertificate")
public class SchoolsGroomerQualificationCertificateController extends BaseController {
	
	@Autowired
	private GroomerQualificationCertificateService groomerQualificationCertificateService;
	@Autowired
	private GroomerRegisterService groomerRegisterService;
	
	
	@RequestMapping(value = { "list", "" })
	public String list(GroomerQualificationCertificate groomerQualificationCertificate, HttpServletRequest request, HttpServletResponse response,
			Model model) {
		TrainingInstitution trainingInstitution = (TrainingInstitution) UserUtils.getSession().getAttribute("trainingInstitution");
		//只展示我自己在学校后台给他报名的部分 
		groomerQualificationCertificate.setRegisterCreateBy(trainingInstitution.getUser());

		//只展示国际宠物美容师和C级证书数据和洗护师证书
		groomerQualificationCertificate.setLevelCnList(
				Arrays.asList(new String[]{"C", "国际宠物美容师", "PRIMARY", "SENIOR", "MATCH"}));
		Page<GroomerQualificationCertificate> pageParam = new Page<>(request, response);
		pageParam.setOrderBy("b.payment_time");
		Page<GroomerQualificationCertificate> page = groomerQualificationCertificateService.findPageByJg(pageParam, groomerQualificationCertificate);
		model.addAttribute("page", page);
		//截止日期
		Calendar calendar = new GregorianCalendar();
		calendar.setTime(new Date());
		calendar.add(Calendar.DATE, -61);
		model.addAttribute("deadline",calendar.getTime() );	
		return "schools/mrschool/groomerQualificationCertificateList";
	}
	
	@RequestMapping(value = "view")
	public String groomerCourseApplicationDetail(String id, Model model) {
		GroomerQualificationCertificate certificate = groomerQualificationCertificateService.get(id);
		GroomerRegister groomerRegister = groomerRegisterService.get(certificate.getRegisterId());
		logger.info("-------------------certificate : {}", JSONObjectUtils.toJsonString(certificate));
		logger.info("-------------------groomerRegister : {}", JSONObjectUtils.toJsonString(groomerRegister));
		model.addAttribute("groomerQualificationCertificate", certificate);
		model.addAttribute("groomerRegister", groomerRegister);
		return "schools/mrschool/groomerQualificationCertificateDetail";
	}

}
