package com.cku.restful.v1.groomer.service;

import java.util.Date;
import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.cku.core.RESTResponse;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.dog.entity.DogBirthCertificate;
import com.cku.oa.finance.dao.PaymentOrderDao;
import com.cku.oa.finance.entity.PaymentCart;
import com.cku.oa.finance.entity.PaymentChargingItem;
import com.cku.oa.finance.entity.PaymentOrder;
import com.cku.oa.finance.service.PaymentCartService;
import com.cku.oa.finance.service.PaymentChargingItemService;
import com.cku.oa.groomer.entity.GroomerCourse;
import com.cku.oa.groomer.entity.GroomerCourseApplication;
import com.cku.oa.groomer.service.GroomerCourseApplicationService;
import com.cku.oa.groomer.service.GroomerCourseService;
import com.cku.oa.sys.coupon.service.SysCouponService;
import com.cku.oa.sys.entity.user.Member;
import com.cku.restful.v1.finance.service.RestOrderService;
import com.cku.restful.v1.groomer.model.RestGroomerCourseApplication;
import com.cku.restful.v1.sys.utils.BeanUtil;
import com.thinkgem.jeesite.common.utils.IdGen;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

import net.sf.json.JSONObject;

@Service
@Transactional(readOnly = true)
public class RestGroomerCourseApplicationService {

	@Autowired
	private GroomerCourseApplicationService groomerCourseApplicationService;

	@Autowired
	private GroomerCourseService groomerCourseService;

	@Autowired
	private PaymentChargingItemService paymentChargingItemService;

	@Autowired
	private PaymentCartService paymentCartService;

	@Autowired
	private RestOrderService restOrderService;

	@Autowired
	public SysCouponService sysCouponService;

	@Autowired
	public PaymentOrderDao paymentOrderDao;

	// 美容课程报名收费项
	private static final String PAYMENTCHARGINGITEM_GROOMER_COURSE_APPLICATION = "groomer_course_application@0";

	@Transactional(readOnly = false)
	public RESTResponse post(String json) {

		Member member = UserUtils.getLoginMember();
		// 获取参数
		RestGroomerCourseApplication vo = BeanUtil.toBean(json, RestGroomerCourseApplication.class);
		// 参数校验
		validateParameter(vo, member);
		// 构造持久对象
		GroomerCourseApplication po = buildPo(vo, member);
		// 写入业务表
		groomerCourseApplicationService.save(po);
		// 写入购物车
		String businessOrderCode = IdGen.uuid();
		PaymentCart paymentCart = buildPaymentCart(po);
		paymentCart.setBusinessOrderCode(businessOrderCode);
		// sa_finance_subject_mapping
		paymentCartService.addToCart(paymentCart, "1083");
		String[] cardIds = paymentCart.getId().split(",");
		// 优惠券加入购物车 这期不做
		if (StringUtils.isNotBlank(vo.getCouponId()))
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "目前本业务优惠券未开放");
		RESTResponse re = restOrderService.cartToOrder(cardIds);
		JSONObject jo = new JSONObject();
		jo.put("id", ((JSONObject) re.getData().get("data")).get("id"));
		PaymentOrder paymentOrder = paymentOrderDao.get(((JSONObject) re.getData().get("data")).get("id").toString());
		jo.put("orderCode", paymentOrder.getOrderCode());
		return new RESTResponse("data", jo);
	}

	public void buildCoupon(List<DogBirthCertificate> poList, int num) {

	}

	private void validateParameter(RestGroomerCourseApplication vo, Member member) {
		// 同一课程不能重复报名
		GroomerCourseApplication g = groomerCourseApplicationService.getOneByMemberCodeACourseId(member.getMemberCode(),
				vo.getCourseId());
		if (g != null) {
			if ("1".equals(g.getPaymentState()))
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "您有该课程订单待支付，同一课程不能重复报名");
			else
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "同一课程不能重复报名");
		}
	}

	private GroomerCourseApplication buildPo(RestGroomerCourseApplication vo, Member member) {
		GroomerCourse groomerCourse = groomerCourseService.get(vo.getCourseId());
		if (groomerCourse == null || !"0".equals(groomerCourse.getDelFlag()))
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "课程查不到");
		if (!"3".equals(groomerCourse.getStates()))// 3 审核通过
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "课程状态不对");
		if (!(groomerCourse.getRegistrationEndTime() == null && groomerCourse.getRegistrationStarteTime() == null)
				&& !(groomerCourse.getRegistrationEndTime() != null && groomerCourse.getRegistrationStarteTime() != null
						&& groomerCourse.getRegistrationEndTime().after(new Date())
						&& groomerCourse.getRegistrationStarteTime().before(new Date())))
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "您报名的课程不在报名时间内，无法报名");

		GroomerCourseApplication po = new GroomerCourseApplication();
		po.setCourseCode(groomerCourse.getCode());
		po.setCourseId(groomerCourse.getId());
		po.setCoursePrice(groomerCourse.getPrice());
		po.setMemberCode(member.getMemberCode());
		po.setName(member.getName());
		po.setMobile(member.getMobile());
		po.setProvince(member.getProvince());
		po.setCity(member.getCity());
		po.setArea(member.getArea());
		po.setStreet(member.getStreet());
		po.setAddress(member.getAddress());
		po.setPaymentState("1");
		return po;
	}

	private PaymentCart buildPaymentCart(GroomerCourseApplication po) {
		PaymentChargingItem paymentChargingItem = paymentChargingItemService
				.getByShortName(PAYMENTCHARGINGITEM_GROOMER_COURSE_APPLICATION);
		if (paymentChargingItem == null || !"0".equals(paymentChargingItem.getDelFlag()))
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "收费项查不到");

		PaymentCart paymentCart = new PaymentCart();
		paymentCart.setChargingItemId(paymentChargingItem.getId());
		paymentCart.setChargingItemName(paymentChargingItem.getName());
		paymentCart.setNum("1");
		paymentCart.setPrice(po.getCoursePrice());// 根据课程价格
		paymentCart.setTotalPrice(po.getCoursePrice());// 根据课程价格
		paymentCart.setBusinessTable("groomer_course_application");
		paymentCart.setBusinessIds(po.getId());
		// sa_finance_subject_mapping
		return paymentCartService.addBusinessManage(paymentCart, "1083");// 所属业务类型
	}

}
