package com.cku.oa.sys.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.util.CollectionUtils;

import com.cku.oa.groomer.entity.GroomerShowBreeds;
import com.cku.oa.groomer.service.GroomerShowBreedsService;
import com.cku.oa.groomer.vo.GroomerShowBreedsGroupVO;
import com.cku.oa.sampling.entity.Sampling;
import com.cku.oa.sampling.service.SamplingService;
import com.cku.oa.statistics.service.ShowOfficeRegionService;
import com.cku.oa.statistics.vo.RegionVo;
import com.cku.oa.sys.entity.Appraiser;
import com.cku.oa.sys.entity.Org;
import com.cku.oa.sys.service.AppraiserService;
import com.cku.oa.sys.service.OrgService;
import com.cku.thirdparty.oss.OssApiClient;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.utils.SpringContextHolder;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

import edu.emory.mathcs.backport.java.util.Arrays;

public class FnsUtils {

	private static OrgService orgService = SpringContextHolder.getBean(OrgService.class);

	private static AppraiserService appraiserService = SpringContextHolder.getBean(AppraiserService.class);

	private static GroomerShowBreedsService groomerShowBreedsService = SpringContextHolder
			.getBean(GroomerShowBreedsService.class);

	private static ShowOfficeRegionService showOfficeRegionService = SpringContextHolder
			.getBean(ShowOfficeRegionService.class);

	private static SamplingService samplingService = SpringContextHolder.getBean(SamplingService.class);

	public static List<Org> getOrgsByType(String orgType) {
		List<Org> resultList = new ArrayList<>();
		try {
			Org org = new Org();
			org.setOrgType(orgType);
			// 查询有效期内的合作机构
			org.setState("0");
			List<Org> tempList = orgService.findList(org);
			if (!CollectionUtils.isEmpty(tempList)) {
				resultList = tempList;
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return resultList;
	}

	public static List<GroomerShowBreedsGroupVO> getGroomerShowBreeds(String showLevel) {
		List<GroomerShowBreedsGroupVO> resultList = new ArrayList<>();
		try {
			GroomerShowBreeds breeds = new GroomerShowBreeds();
			breeds.setShowLevels(showLevel);
			List<GroomerShowBreeds> tempList = groomerShowBreedsService.findList(breeds);
			if (!CollectionUtils.isEmpty(tempList)) {
				Map<String, List<GroomerShowBreeds>> breedMap = tempList.stream()
						.collect(Collectors.groupingBy(GroomerShowBreeds::getBreedGroup));
				breedMap.forEach((key, val) -> {
					resultList.add(GroomerShowBreedsGroupVO.builder().breedGroup(key).breedList(val).build());
				});
				FnsUtils.sortGroupList(resultList);
			}

		} catch (Exception e) {
			e.printStackTrace();
		}
		return resultList;
	}

	// 可选犬种分组排序，排序规则按犬种表每组的最大值，进行分组排序
	public static void sortGroupList(List<GroomerShowBreedsGroupVO> resultList) {
		Collections.sort(resultList, new Comparator<GroomerShowBreedsGroupVO>() {
			@Override
			public int compare(GroomerShowBreedsGroupVO o1, GroomerShowBreedsGroupVO o2) {
				int o1sort = o1.getBreedList().stream().max(Comparator.comparing(GroomerShowBreeds::getSort)).get()
						.getSort();
				int o2sort = o2.getBreedList().stream().max(Comparator.comparing(GroomerShowBreeds::getSort)).get()
						.getSort();
				int diff = o1sort - o2sort;
				if (diff > 0) {
					return 1;
				} else if (diff < 0) {
					return -1;
				}
				return 0;
			}
		});
	}

	public static String getOrgNameById(String orgId) {
		String orgName = "";
		try {
			Org org = orgService.get(orgId);
			if (org != null) {
				orgName = org.getName();
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return orgName;
	}

	public static Org getOrgById(String orgId) {
		Org org = new Org();
		try {
			Org tempOrg = orgService.get(orgId);
			if (org != null) {
				org = tempOrg;
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return org;
	}

	public static List<Appraiser> getAppraiserListByOrgId(String orgId) {
		Appraiser entity = new Appraiser();
		entity.setOrgId(orgId);
		entity.setReviewState("1");
		List<Appraiser> result = appraiserService.findList(entity);
		if (!CollectionUtils.isEmpty(result)) {
			return result;
		}
		return new ArrayList<Appraiser>();
	}

	/**
	 * 敏感数据脱敏
	 * 
	 * 1 血统证书 隐藏倒数7-9位 ；2 芯片号 隐藏倒数4-7位 ；3 宠爱护照号 隐藏倒数4-7位 ；4 登记卡编号 隐藏倒数3-5位 ；
	 * 
	 * 5 宠爱登记卡编号 隐藏倒数4-7位 ；6 DNA编号 隐藏倒数3-5位
	 */
	public static String desensitize(String text, int type) {
		// 是否显示敏感数据
		if ("0".equals(UserUtils.getUser().getIsShowSensitiveData()) && StringUtils.isNotBlank(text)) {// 是否展示敏感数据 0不展示
			if (1 == type && text.length() >= 9) {// 隐藏倒数7-9位
				text = text.substring(0, text.length() - 9) + "***" + text.substring(text.length() - 7 + 1);
			} else if ((2 == type || 3 == type || 5 == type) && text.length() >= 7) {// 隐藏倒数4-7位
				text = text.substring(0, text.length() - 7) + "****" + text.substring(text.length() - 4 + 1);
			} else if ((4 == type || 6 == type) && text.length() >= 5) {// 隐藏倒数3-5位
				text = text.substring(0, text.length() - 5) + "***" + text.substring(text.length() - 3 + 1);
			}
		}
		return text;
	}

	public static String substringAfter(String param, String symbol) {
		if (StringUtils.isNotBlank(param) && StringUtils.isNotBlank(symbol) && param.length() >= symbol.length()) {
			return param.endsWith(symbol) ? param.substring(0, param.lastIndexOf(symbol)) : param;
		}
		return param;
	}

	public static boolean splitContains(String param, String search, String symbol) {
		if (StringUtils.isNotBlank(param) && StringUtils.isNotBlank(search) && StringUtils.isNotBlank(symbol)) {
			return Arrays.asList(param.split(symbol)).contains(search);
		}
		return Boolean.FALSE;
	}

	public static String replaceContainsEmpty(String param, String search, String symbol) {
		if (StringUtils.isNotBlank(param) && StringUtils.isNotBlank(search) && StringUtils.isNotBlank(symbol)) {
			List<String> source = new ArrayList<String>(Arrays.asList(param.split(symbol)));
			List<String> target = Arrays.asList(search.split(symbol));
			source.removeAll(target);
			return source.stream().collect(Collectors.joining(","));
		}
		return param;
	}

	public static String getOssEndpoint() {
		String endpoint = Global.getConfig("aliyun.oss.endpoint");
		if (StringUtils.isNotEmpty(endpoint)) {
			endpoint = endpoint.replace(OssApiClient.HTTPS, "");
		}
		String bucketName = Global.getConfig("aliyun.oss.bucketName");
		return OssApiClient.HTTPS + bucketName + "." + endpoint;
	}

	public static List<String> getShowOfficeRegionNames() {
		// 增加权限
		List<String> resultList = new ArrayList<>();
		List<RegionVo> dataList = showOfficeRegionService.findRegionList();
		try {
			if (!CollectionUtils.isEmpty(dataList)) {
				resultList.addAll(dataList.stream().map(RegionVo::getRegion).collect(Collectors.toSet()));
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return resultList;
	}

	public static List<Sampling> getSamplingUnuseList() {
		return samplingService.findUnuseList();
	}

}
