package com.cku.oa.sys.util;

public class DesensitizeUtils {

	public static final int TEXT_TYPE_PEDIGREECERTIFIEDCODE = 1;

	public static final int TEXT_TYPE_IDENTIFICATIONFLAG = 2;

	/**
	 * 敏感数据脱敏
	 * 
	 * 1 血统证书 隐藏倒数7-9位 ；2 芯片号 隐藏倒数4-7位 ；
	 */
	public static String desensitize(String text, int type) {
		if (text != null) {
			if (TEXT_TYPE_PEDIGREECERTIFIEDCODE == type && text.length() >= 9) {// 隐藏倒数7-9位
				text = text.substring(0, text.length() - 9) + "***" + text.substring(text.length() - 7 + 1);
			} else if (TEXT_TYPE_IDENTIFICATIONFLAG == type && text.length() >= 7) {// 隐藏倒数4-7位
				text = text.substring(0, text.length() - 7) + "****" + text.substring(text.length() - 4 + 1);
			}
		}
		return text;
	}

}
