/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.sys.entity;

import org.hibernate.validator.constraints.Length;
import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;

import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 计划任务执行日志Entity
 * @author zhuoHeng
 * @version 2017-03-31
 */
public class TaskLog extends DataEntity<TaskLog> {
	
	private static final long serialVersionUID = 1L;
	private String taskId;		// 计划任务表主键
	private String jobInfo;		// 任务描述
	private String jobName;		// 任务名称
	private String jobGroup;		// 任务组名
	private String executeType;		// 执行类型
	private Date executeTime;		// 执行时间
	private String successCount;		// 执行成功条数
	private String successState;		// 执行结果标识
	
	public TaskLog() {
		super();
	}

	public TaskLog(String id){
		super(id);
	}

	@Length(min=1, max=64, message="计划任务表主键长度必须介于 1 和 64 之间")
	public String getTaskId() {
		return taskId;
	}

	public void setTaskId(String taskId) {
		this.taskId = taskId;
	}
	
	@Length(min=0, max=255, message="任务描述长度必须介于 0 和 255 之间")
	public String getJobInfo() {
		return jobInfo;
	}

	public void setJobInfo(String jobInfo) {
		this.jobInfo = jobInfo;
	}
	
	@Length(min=0, max=100, message="任务名称长度必须介于 0 和 100 之间")
	public String getJobName() {
		return jobName;
	}

	public void setJobName(String jobName) {
		this.jobName = jobName;
	}
	
	@Length(min=0, max=64, message="任务组名长度必须介于 0 和 64 之间")
	public String getJobGroup() {
		return jobGroup;
	}

	public void setJobGroup(String jobGroup) {
		this.jobGroup = jobGroup;
	}
	
	@Length(min=0, max=1, message="执行类型长度必须介于 0 和 1 之间")
	public String getExecuteType() {
		return executeType;
	}

	public void setExecuteType(String executeType) {
		this.executeType = executeType;
	}
	
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getExecuteTime() {
		return executeTime;
	}

	public void setExecuteTime(Date executeTime) {
		this.executeTime = executeTime;
	}
	
	@Length(min=0, max=100, message="执行成功条数长度必须介于 0 和 100 之间")
	public String getSuccessCount() {
		return successCount;
	}

	public void setSuccessCount(String successCount) {
		this.successCount = successCount;
	}
	
	@Length(min=0, max=1, message="执行结果标识长度必须介于 0 和 1 之间")
	public String getSuccessState() {
		return successState;
	}

	public void setSuccessState(String successState) {
		this.successState = successState;
	}
	
}