package com.cku.oa.statistics.web;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.utils.excel.ExportExcel;
import com.cku.oa.shop.entity.ShopGoods;
import com.cku.oa.shop.service.ShopGoodsService;
import com.cku.oa.statistics.dao.ShopGoodsStatisticsDao;
import com.cku.oa.statistics.entity.ShopSalesStatistics;
import com.cku.oa.statistics.service.ShopSalesStatisticsService;
import com.google.common.collect.Lists;

/**
 * 商城销售统计Controller
 * @author chy
 * @version 2017-12-19
 */
@Controller
@RequestMapping(value = "${adminPath}/statistics/shop")
public class ShopSalesStatisticsController extends BaseController {

	@Autowired
	private ShopSalesStatisticsService shopSalesStatisticsService;
	
	@Autowired
	public ShopGoodsStatisticsDao shopGoodsStatisticsDao;
	@Autowired
	public ShopGoodsService shopGoodsService;
	
	
	/**
	 * 商城销售统计
	 * @throws ParseException 
	 * @author chy
	 */
	
	@RequestMapping(value = "shopSalesStatistics")
	public String shopStatistics(HttpServletRequest request,HttpServletResponse response,Model model) throws ParseException{
			String startDate = request.getParameter("startDate");
			String endDate = request.getParameter("endDate");
			String name=request.getParameter("name");
			String isOnSubmit = request.getParameter("isOnSubmit");
			Calendar cal = Calendar.getInstance();
			int year = cal.get(Calendar.YEAR);
			int month = cal.get(Calendar.MONTH )+1;
			int day = cal.get(Calendar.DAY_OF_MONTH);
			if(isOnSubmit == null || isOnSubmit.equals(""))
			{
				if(startDate == null || startDate.equals(""))
					startDate = String.valueOf(year)+"-"+String.valueOf(month)+"-"+String.valueOf(day);
				if(endDate == null || endDate.equals(""))
					endDate = String.valueOf(year)+"-"+String.valueOf(month)+"-"+String.valueOf(day);	
			}
			
		    List<String> list = shopSalesStatisticsService.findCommodityNameList();
			model.addAttribute("list",list);
			model.addAttribute("selectedName",name);
			ShopSalesStatistics salesStatistics = new ShopSalesStatistics();
			salesStatistics.setCommodityName(name);
			salesStatistics.setStatisticalDateFrom(startDate);
			salesStatistics.setStatisticalDateTo(endDate);
			List<ShopSalesStatistics> results = shopSalesStatisticsService.findList(salesStatistics);
			//往页面传值
			model.addAttribute("results",results);
			model.addAttribute("startDate",startDate);
			model.addAttribute("endDate",endDate);
			model.addAttribute("name",name);
			Page<Object> page = new Page<Object>(request, response);//从页面的参数中获取当前的页码等信息
			page.setCount(results.size());
			page.initialize();//重新计算页码信息
			model.addAttribute("page",page);
			return "oa/statistics/shop/shopSalesStatistics";	
	}
	
	/**
	 * 导入赛事信息
	 * @param file
	 * @param redirectAttributes
	 * @author chy
	 */
    @RequestMapping(value = "import", method=RequestMethod.POST)
    public String importFile(MultipartFile file, RedirectAttributes redirectAttributes) {
		try {
			//销售信息导入
			shopSalesStatisticsService.importShops(file);
			addMessage(redirectAttributes, "导入销售信息成功！");
		} catch (Exception e) {
			addMessage(redirectAttributes, "导入销售信息失败！失败信息："+e.getMessage());
		}
		return "redirect:"+Global.getAdminPath()+"/statistics/shop/shopSalesStatistics/?repage";
    }
	
	/**
	 * 下载导入赛事信息模板
	 * @param response
	 * @param redirectAttributes
	 * @author chy
	 */
    @RequestMapping(value = "import/template")
    public String importFileTemplate(HttpServletResponse response, RedirectAttributes redirectAttributes) {
		try {
            String fileName = "销售统计导入模板.xlsx";
    		List<ShopSalesStatistics> list = Lists.newArrayList();
    		ShopSalesStatistics shopSalesStatistics = new ShopSalesStatistics();
    		shopSalesStatistics.setCommodityName("希可优日常养护专用粮（20Kg）");
    		shopSalesStatistics.setStatisticalDate("2017/12/28");
    		shopSalesStatistics.setCommodityType("OEM");
    		shopSalesStatistics.setCommodityNum("100");
    		shopSalesStatistics.setTotalAmount("3000000.00");
    		list.add(shopSalesStatistics);
    		new ExportExcel("销售统计", ShopSalesStatistics.class, 2).setDataList(list).write(response, fileName).dispose();
    		return null;
		} catch (Exception e) {
			addMessage(redirectAttributes, "导入模板下载失败！失败信息："+e.getMessage());
		}
		return "redirect:"+Global.getAdminPath()+"/statistics/shop/shopSalesStatistics/?repage";
    }
    
    /**  
     * 将String型格式化,比如想要将2011-11-11格式化成2011年11月11日,就StringPattern("2011-11-11","yyyy-MM-dd","yyyy年MM月dd日"). 
     * @param date String 想要格式化的日期 
     * @param oldPattern String 想要格式化的日期的现有格式 
     * @param newPattern String 想要格式化成什么格式 
     * @return String  
     * @author chy
     *//*   
    public final String StringPattern(String date, String oldPattern, String newPattern) {   
        if (date == null || oldPattern == null || newPattern == null)   
            return "";   
        SimpleDateFormat sdf1 = new SimpleDateFormat(oldPattern) ;        // 实例化模板对象    
        SimpleDateFormat sdf2 = new SimpleDateFormat(newPattern) ;        // 实例化模板对象    
        Date d = null ;    
        try{    
            d = sdf1.parse(date);   // 将给定的字符串中的日期提取出来    
        }catch(Exception e){            // 如果提供的字符串格式有错误，则进行异常处理    
            e.printStackTrace() ;       // 打印异常信息    
        }    
        return sdf2.format(d);  
    } */ 
}

