package com.cku.oa.statistics.service;

import java.util.List;

import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.cku.oa.statistics.dao.ShowOfficeRegionDao;
import com.cku.oa.statistics.entity.ShowOfficeRegion;
import com.cku.oa.statistics.vo.RegionVo;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.thinkgem.jeesite.modules.sys.entity.User;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

@Service
@Transactional(readOnly = true)
public class ShowOfficeRegionService extends CrudService<ShowOfficeRegionDao, ShowOfficeRegion> {

	public ShowOfficeRegion get(String id) {
		return super.get(id);
	}

	public List<ShowOfficeRegion> findList(ShowOfficeRegion showOfficeRegion) {
		return super.findList(showOfficeRegion);
	}

	public Page<ShowOfficeRegion> findPage(Page<ShowOfficeRegion> page, ShowOfficeRegion showOfficeRegion) {
		return super.findPage(page, showOfficeRegion);
	}

	@Transactional(readOnly = false)
	public void save(ShowOfficeRegion showOfficeRegion) {
		super.save(showOfficeRegion);
	}

	@Transactional(readOnly = false)
	public void delete(ShowOfficeRegion showOfficeRegion) {
		super.delete(showOfficeRegion);
	}
	
	
	
	public List<RegionVo> findRegionList() {
   		User user = UserUtils.getUser();
		ShowOfficeRegion showOfficeRegion = new ShowOfficeRegion();
		//showOfficeRegion.setRegionUserId("21632");
		showOfficeRegion.setRegionUserId(user.getId());
		return dao.findRegionList(showOfficeRegion);
	}
	
	public List<String> findProvince(String officeId) {
		return dao.findProvince(officeId);
	}

}