/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.show.service;

import java.util.HashSet;
import java.util.List;

import javax.validation.Validator;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.show.dao.ShowResultsDdzDao;
import com.cku.oa.show.entity.ShowResultsDdz;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.thinkgem.jeesite.common.utils.excel.ImportExcel;
import com.thinkgem.jeesite.modules.sys.utils.DictUtils;

/**
 * 单独展犬展成绩Service
 * @author lgl
 * @version 2016-07-21
 */
@Service
@Transactional(readOnly = true)
public class ShowResultsDdzService extends CrudService<ShowResultsDdzDao, ShowResultsDdz> {
	
	/**
	 * 验证Bean实例对象
	 */
	@Autowired
	protected Validator validator;
	@Autowired
	private ShowApplyService showApplyService;
	@Autowired
	private ChildShowsService childShowsService;

	public ShowResultsDdz get(String id) {
		return super.get(id);
	}
	
	public List<ShowResultsDdz> findList(ShowResultsDdz showResultsDdz) {
		return super.findList(showResultsDdz);
	}
	
	public Page<ShowResultsDdz> findPage(Page<ShowResultsDdz> page, ShowResultsDdz showResultsDdz) {
		return super.findPage(page, showResultsDdz);
	}
	
	@Transactional(readOnly = false)
	public void save(ShowResultsDdz showResultsDdz) {
		super.save(showResultsDdz);
		//标记为未统计
		childShowsService.updateUnStatisticsState(showResultsDdz.getShowCode());
	}
	
	@Transactional(readOnly = false)
	public void delete(ShowResultsDdz showResultsDdz) {
		super.delete(showResultsDdz);
	}
	
	@Transactional(readOnly = false, rollbackFor = Exception.class)
	public int importShowResultsDdz(MultipartFile file) throws Exception {
		HashSet<String> showCodeSet = new HashSet<String>();
		int count = 0;
		try {
			ImportExcel ei = new ImportExcel(file, 1, 0);
			List<ShowResultsDdz> list = ei.getDataList(ShowResultsDdz.class);
			boolean flag = true;
			for (ShowResultsDdz showResultsDdz : list){
				//跳过无效记录
				if(showResultsDdz.getShowRules()==null||!showResultsDdz.getShowRules().contains("单独展")){
					continue;
				}
				flag = false;
				// cc
//				if(!StringUtils.isEmpty(showResultsDdz.getResultCc())) {
//					showResultsDdz.setResultCc(showResultsDdz.getResultCc().replace("/", ","));
//				}
				//字典类型字段转换
				showResultsDdz.setAgeGroup(DictUtils.getDictValue(showResultsDdz.getAgeGroup(), "show_age_group", ""));
				showResultsDdz.setDogGender(DictUtils.getDictValue(showResultsDdz.getDogGender(), "dog_gender", ""));
				if(StringUtils.isBlank(showResultsDdz.getShowResult())){
					showResultsDdz.setShowResult("0");
				}
				//官网成绩排名所属年份（默认去犬展编号年份，当犬展跨年，可以手动修改年份为下一年）
				String year = "";
				if(StringUtils.isNotBlank(showResultsDdz.getShowCode())&&showResultsDdz.getShowCode().length()>=4){
					year = showResultsDdz.getShowCode().substring(0,4);
				}
				showResultsDdz.setYear(year);
//				showResultsDdz.setRemarks(showResultsDdz.getC43());
				//判断是否报名
//				if(!showApplyService.isApply(showResultsDdz.getShowCode(), showResultsDdz.getPedigreeCertified())){
//					throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "血统证书号为"+showResultsDdz.getPedigreeCertified()+",犬展编号为"+showResultsDdz.getShowCode()+"的记录没有找到相关的报名记录");
//				}
				//判断是否已有成绩
				if(dao.countByShowCodeAndPedigreeCertified(showResultsDdz.getShowCode(), showResultsDdz.getPedigreeCertified())>0){
					System.out.println("123:" + showResultsDdz.getShowCode() + " === " + showResultsDdz.getPedigreeCertified());
					throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "已有血统证书号为"+showResultsDdz.getPedigreeCertified()+",犬展编号为"+showResultsDdz.getShowCode()+"的成绩记录");
				}
				//写数据库
				save(showResultsDdz);
				count++;
				//保存犬展编号
				showCodeSet.add(showResultsDdz.getShowCode());
			}
			if(flag){
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "未找到有效记录！");
			}
		} catch (ZAException e) {
			throw e;
		} catch (Exception e) {
			logger.warn("单独展犬展成绩导入出错！",e);
			throw new Exception(e);
		}
		//标记为未统计
		for(String showCode:showCodeSet){
			childShowsService.updateUnStatisticsState(showCode);
		}
		return count;
	}
	
}