/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.shop.dao;

import com.thinkgem.jeesite.common.persistence.CrudDao;
import com.thinkgem.jeesite.common.persistence.annotation.MyBatisDao;
import com.cku.oa.shop.entity.ShopCarts;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 商城购物车临时DAO接口
 * @author lyy
 * @version 2016-08-23
 */
@MyBatisDao
public interface ShopCartsDao extends CrudDao<ShopCarts> {
    List<ShopCarts> findListByMemberCode(@Param("memberCode")String memberCode);
    ShopCarts getPCart(@Param("goodsId")String goodsId);
    ShopCarts getBuyGift(@Param("memberCode")String memberCode,@Param("goodsId")String goodsId);
    ShopCarts getCommonCarts(@Param("memberCode")String memberCode,@Param("goodsId")String goodsId);
    ShopCarts getShopCarts(@Param("memberCode")String memberCode,@Param("goodsId")String goodsId,@Param("bugGiftGoods")String bugGiftGoods);
}