package com.cku.oa.handler.service;

import java.io.IOException;
import java.time.LocalDate;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.cku.oa.handler.dao.RefereeRankingDao;
import com.cku.oa.handler.dao.RefereeRankingSchemDao;
import com.cku.oa.handler.entity.RefereeRanking;
import com.cku.oa.handler.entity.RefereeRankingSchem;
import com.cku.oa.show.dao.ShowResultsDao;
import com.cku.oa.show.entity.ShowResultsExportVo;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.thinkgem.jeesite.common.utils.excel.ExportExcel;
import com.thinkgem.jeesite.modules.sys.utils.DictUtils;

/**
 * 牵犬师积分Service
 * 
 * @author zxy
 * @version 2023-06-06
 */
@Service
@Transactional(readOnly = true)
public class RefereeRankingService extends CrudService<RefereeRankingDao, RefereeRanking> {

	@Autowired
	private RefereeRankingSchemDao refereeRankingSchemDao;
	@Autowired
	private ShowResultsDao showResultsDao;
	@Autowired
	private RefereeRankingSchemService refereeRankingSchemService;

	public RefereeRanking get(String id) {
		return super.get(id);
	}

	public List<RefereeRanking> findList(RefereeRanking refereeRanking) {
		return super.findList(refereeRanking);
	}

	public Page<RefereeRanking> findPage(Page<RefereeRanking> page, RefereeRanking refereeRanking) {
		return super.findPage(page, refereeRanking);
	}

	@Transactional(readOnly = false)
	public void save(RefereeRanking refereeRanking) {
		super.save(refereeRanking);
	}

	@Transactional(readOnly = false)
	public void delete(RefereeRanking refereeRanking) {
		super.delete(refereeRanking);
	}

	public void export(RefereeRanking refereeRanking, HttpServletResponse response) throws IOException {
		List<RefereeRanking> list = dao.findList(refereeRanking);
		for (RefereeRanking ranking : list) {
			String type = DictUtils.getDictLabel(ranking.getType(), "referee_schem_type", null);
			ranking.setType(type);
			String quarter = DictUtils.getDictLabel(ranking.getQuarter(), "quarter", null);
			ranking.setHalf("1".equals(ranking.getHalf()) ? "上半年" : "下半年");
			ranking.setQuarter(quarter);
		}
		new ExportExcel("", RefereeRanking.class, 2).setDataList(list).write(response, "牵犬师积分排行榜.xlsx").dispose();
	}

	public void exportInfo(RefereeRanking refereeRanking, HttpServletResponse response) throws IOException {
		String serialNum = refereeRanking.getSerialNum();
		RefereeRankingSchem schem = refereeRankingSchemDao.getBySerialNum(serialNum);
		String type = schem.getType();

		List<ShowResultsExportVo> results = new ArrayList<>();
		if (type.equals("1")) {
			results = showResultsDao.getRangeExportResultList(schem.getYear() + "-01-01", schem.getYear() + "-12-31",
					refereeRanking.getMemberCode());
		} else if (type.equals("2")) {
			Map<String, String> quarterMap = refereeRankingSchemService.getQuarter(schem);
			results = showResultsDao.getRangeExportResultList(quarterMap.get("firstDay"), quarterMap.get("lastDay"),
					refereeRanking.getMemberCode());
		} else if (type.equals("3")) {
			// 月第一天
			LocalDate localDate = LocalDate.of(Integer.parseInt(schem.getYear()), Integer.parseInt(schem.getMonth()),
					1);
			// 月最后一天
			LocalDate lastDay = localDate.with(TemporalAdjusters.lastDayOfMonth());
			results = showResultsDao.getRangeExportResultList(localDate.toString(), lastDay.toString(),
					refereeRanking.getMemberCode());
		}else {
			if ("1".equals(schem.getHalf())) { // 上半年
				results = showResultsDao.getRangeExportResultList(schem.getYear() + "-01-01",
						schem.getYear() + "-06-30", refereeRanking.getMemberCode());
			} else {
				results = showResultsDao.getRangeExportResultList(schem.getYear() + "-07-01",
						schem.getYear() + "-12-31", refereeRanking.getMemberCode());
			}
		}
		
		new ExportExcel("", ShowResultsExportVo.class, 2).setDataList(results).write(response, "积分详情.xlsx").dispose();
	}
	
	
}
