package com.cku.oa.groomer.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.cku.oa.groomer.entity.GroomerExamQuestions;
import com.cku.oa.groomer.dao.GroomerExamQuestionsDao;

/**
 * 美容考试题表Service
 * @author hjx
 * @version 2023-11-23
 */
@Service
@Transactional(readOnly = true)
public class GroomerExamQuestionsService extends CrudService<GroomerExamQuestionsDao, GroomerExamQuestions> {

	@Autowired
	private GroomerExamQuestionsDao groomerExamQuestionsDao;

	public GroomerExamQuestions get(String id) {
		return super.get(id);
	}
	
	public List<GroomerExamQuestions> findList(GroomerExamQuestions groomerExamQuestions) {
		return super.findList(groomerExamQuestions);
	}
	
	public Page<GroomerExamQuestions> findPage(Page<GroomerExamQuestions> page, GroomerExamQuestions groomerExamQuestions) {
		return super.findPage(page, groomerExamQuestions);
	}
	
	@Transactional(readOnly = false)
	public void save(GroomerExamQuestions groomerExamQuestions) {
		super.save(groomerExamQuestions);
	}
	
	@Transactional(readOnly = false)
	public void delete(GroomerExamQuestions groomerExamQuestions) {
		super.delete(groomerExamQuestions);
	}

	public List<GroomerExamQuestions> getByExamPaperId(String examPaperId) {
		return groomerExamQuestionsDao.getByExamPaperId(examPaperId);
	}

	/**
	 * 查询考卷无删除标记判断
	 * @param examPaperId
	 * @return
	 */
	public List<GroomerExamQuestions> getByExamPaperIdAndNoDelFlag(String examPaperId) {
		return groomerExamQuestionsDao.getByExamPaperIdAndNoDelFlag(examPaperId);
	}
	
}