/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.goods.entity;

import org.hibernate.validator.constraints.Length;

import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 业务注册Entity
 * @author yuanshuai
 * @version 2023-06-16
 */
public class SysBusinessService extends DataEntity<SysBusinessService> {
	
	private static final long serialVersionUID = 1L;
	private String cateId;		// 分类ID
	private String businessCode;		// 服务编号
	private String businessName;		// 服务名称
	private String serviceName;		// 类名
	private String financeId;		// 财务配置ID

	//查询显示用
	// 分类名称
	private String cateName;
	
	public SysBusinessService() {
		super();
	}

	public SysBusinessService(String id){
		super(id);
	}

	@Length(min=1, max=32, message="分类ID长度必须介于 1 和 32 之间")
	public String getCateId() {
		return cateId;
	}

	public void setCateId(String cateId) {
		this.cateId = cateId;
	}
	
	@Length(min=0, max=50, message="服务编号长度必须介于 0 和 50 之间")
	public String getBusinessCode() {
		return businessCode;
	}

	public void setBusinessCode(String businessCode) {
		this.businessCode = businessCode;
	}
	
	@Length(min=0, max=50, message="服务名称长度必须介于 0 和 50 之间")
	public String getBusinessName() {
		return businessName;
	}

	public void setBusinessName(String businessName) {
		this.businessName = businessName;
	}
	
	@Length(min=0, max=50, message="类名长度必须介于 0 和 50 之间")
	public String getServiceName() {
		return serviceName;
	}

	public void setServiceName(String serviceName) {
		this.serviceName = serviceName;
	}
	
	@Length(min=0, max=50, message="财务配置ID长度必须介于 0 和 50 之间")
	public String getFinanceId() {
		return financeId;
	}

	public void setFinanceId(String financeId) {
		this.financeId = financeId;
	}

	public String getCateName() {
		return cateName;
	}

	public void setCateName(String cateName) {
		this.cateName = cateName;
	}
}