/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.finance.entity;

import org.hibernate.validator.constraints.Length;

import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 支付记录日志Entity
 * @author yuanshuai
 * @version 2018-08-10
 */
public class PaymentPayLog extends DataEntity<PaymentPayLog> {
	
	private static final long serialVersionUID = 1L;
	private String payType;		// 支付的类型（通联、支付宝、微信）等
	private String payState;		// 订单号
	private String orderId;		// 订单号
	private String transactionId;		// 订单号
	private String payInfo;		// 支付信息
	private String error;		// 错误信息

	public PaymentPayLog() {
		super();
	}

	public PaymentPayLog(String id){
		super(id);
	}

	@Length(min=1, max=10, message="支付的类型（通联、支付宝、微信）等长度必须介于 1 和 10 之间")
	public String getPayType() {
		return payType;
	}

	public void setPayType(String payType) {
		this.payType = payType;
	}

	public String getPayState() {
		return payState;
	}

	public void setPayState(String payState) {
		this.payState = payState;
	}

	@Length(min=0, max=64, message="订单号长度必须介于 1 和 64 之间")
	public String getOrderId() {
		return orderId;
	}

	public void setOrderId(String orderId) {
		this.orderId = orderId;
	}

	@Length(min=0, max=64, message="第三方交易号长度必须介于 1 和 64 之间")
	public String getTransactionId() {
		return transactionId;
	}

	public void setTransactionId(String transactionId) {
		this.transactionId = transactionId;
	}

	public String getPayInfo() {
		return payInfo;
	}

	public void setPayInfo(String payInfo) {
		this.payInfo = payInfo;
	}

	public String getError() {
		return error;
	}

	public void setError(String error) {
		this.error = error;
	}
}