package com.cku.oa.dog.enums;

import com.cku.oa.sys.entity.user.IEnum;

/**
 * 风险等级
 */
public enum GeneRiskLevelEnum implements IEnum<Integer> {

	/**
	 * 风险等级
	 */
	NO_RISK(0, "无风险"),
	LOW_RISK(1, "低风险"),
	MEDIUM_RISK(2, "中风险"),
	HIGH_RISK(3, "高风险"),
	VERY_HIGH_RISK(4, "极高风险");

    private Integer code;

    private String message;

    GeneRiskLevelEnum(Integer code, String message) {
        this.code = code;
        this.message = message;
    }

    @Override
    public Integer code() {
        return this.code;
    }

    @Override
    public String message() {
        return this.message;
    }

}